/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.config.AbstractRegistryConfiguration;
import net.sourceforge.nattable.config.DefaultNatTableStyleConfiguration;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.config.IConfiguration;
import net.sourceforge.nattable.config.IEditableRule;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.EditConfigAttributes;
import net.sourceforge.nattable.edit.event.InlineCellEditEvent;
import net.sourceforge.nattable.grid.command.AutoResizeColumnCommandHandler;
import net.sourceforge.nattable.grid.data.DefaultCornerDataProvider;
import net.sourceforge.nattable.grid.data.DefaultRowHeaderDataProvider;
import net.sourceforge.nattable.grid.layer.CornerLayer;
import net.sourceforge.nattable.grid.layer.GridLayer;
import net.sourceforge.nattable.hideshow.ColumnHideShowLayer;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.ILayerListener;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import net.sourceforge.nattable.layer.cell.IConfigLabelAccumulator;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.reorder.ColumnReorderLayer;
import net.sourceforge.nattable.reorder.event.ColumnReorderEvent;
import net.sourceforge.nattable.resize.event.ColumnResizeEvent;
import net.sourceforge.nattable.resize.event.RowResizeEvent;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.command.SelectAllCommand;
import net.sourceforge.nattable.selection.command.SelectRowsCommand;
import net.sourceforge.nattable.selection.config.DefaultSelectionStyleConfiguration;
import net.sourceforge.nattable.selection.event.CellSelectionEvent;
import net.sourceforge.nattable.selection.event.ColumnSelectionEvent;
import net.sourceforge.nattable.selection.event.RowSelectionEvent;
import net.sourceforge.nattable.style.BorderStyle;
import net.sourceforge.nattable.style.HorizontalAlignmentEnum;
import net.sourceforge.nattable.style.VerticalAlignmentEnum;
import net.sourceforge.nattable.util.GUIHelper;
import net.sourceforge.nattable.viewport.ViewportLayer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.celleditors.CellEditorsUtils;
import org.eclipse.emf.facet.widgets.celleditors.ICellEditorsRegistry;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditorContainer;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditorValidator;
import org.eclipse.emf.facet.widgets.celleditors.INaryEAttributeCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.INaryEReferenceCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.INaryFeatureCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.internal.CellEditorsRegistry;
import org.eclipse.emf.facet.widgets.celleditors.internal.ModelCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.internal.ModelCellEditorContainer;
import org.eclipse.emf.facet.widgets.celleditors.internal.core.EEnumCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.AbstractModelCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.BasicCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.NaryFeatureCellEditor;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.UnaryReferenceCellEditor;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IPositionCoordinate;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetView;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetInternalUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.DefaultSizeUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.TableDragSourceListener;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.ColumnHeaderLayerStack;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.DataValidatorAdapter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.GridLayerConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.NatTableCellEditorAdapter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.NatTableDropListener;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.NatTableNaryEAttributeCellEditorAdapter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.NatTableNaryEReferenceCellEditorAdapter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.NatTableNaryReferenceCellEditorAdapter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.RowHeaderLayerStack;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.StyleConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.StyledColumnHeaderConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.StyledRowHeaderConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.dataprovider.BodyDataProvider;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.dataprovider.ColumnHeaderDataProvider;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.handler.CopyToClipboardCommandHandler;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.wrapper.PositionCoordinateWrapper;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableWidget
extends Composite
implements ITableWidgetView {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private static final Color BG_COLOR = GUIHelper.getColor((int)217, (int)232, (int)251);
    private static final String ENUM_CELLEDITOR_LABEL = "enum_celleditor";
    private NatTable natTable;
    private BodyDataProvider fBodyDataProvider;
    private BodyLayerStack bodyLayerStack;
    private GridLayer gridLayer;
    private boolean listenColumn = true;
    private final ITableWidgetInternal tableWidgetController;
    private List<Object> gridSelection = Collections.emptyList();
    private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private final Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};

    public NatTableWidget(Composite parent, ITableWidgetInternal tableWidgetController) {
        super(parent, 0);
        this.tableWidgetController = tableWidgetController;
        this.setLayout((Layout)new FillLayout());
    }

    public void fullRedraw() {
        if (this.natTable == null || !this.natTable.isDisposed()) {
            this.internalFullRedraw();
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.natTable.addMouseListener(listener);
        this.mouseListeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.natTable.removeMouseListener(listener);
        this.mouseListeners.remove(listener);
    }

    protected void internalFullRedraw() {
        Control[] children;
        DebugUtils.debug((boolean)DEBUG, (String)"Start");
        boolean reset = false;
        boolean takeFocus = true;
        int horizontalScrollbarPos = 0;
        int verticalScrollbarPos = 0;
        PositionCoordinate[] selectedCells = null;
        if (this.natTable != null && !this.natTable.isDisposed()) {
            horizontalScrollbarPos = this.natTable.getHorizontalBar().getSelection();
            verticalScrollbarPos = this.natTable.getVerticalBar().getSelection();
            SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
            selectedCells = selectionLayer.getSelectedCells();
            reset = true;
            takeFocus = this.natTable.isFocusControl();
        }
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control childControl = controlArray[n2];
            childControl.dispose();
            ++n2;
        }
        this.fBodyDataProvider = new BodyDataProvider(this);
        ColumnHeaderDataProvider colHeaderDataProvider = new ColumnHeaderDataProvider(this);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)this.fBodyDataProvider);
        this.bodyLayerStack = new BodyLayerStack(this.fBodyDataProvider);
        ColumnHeaderLayerStack columnHeaderLayer = new ColumnHeaderLayerStack(colHeaderDataProvider, this.bodyLayerStack, this.tableWidgetController);
        RowHeaderLayerStack rowHeaderLayer = new RowHeaderLayerStack((IDataProvider)rowHeaderDataProvider, this.bodyLayerStack);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)colHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        this.gridLayer = new GridLayer((ILayer)this.bodyLayerStack, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer, false);
        this.gridLayer.registerCommandHandler((ILayerCommandHandler)new AutoResizeColumnCommandHandler(this.gridLayer));
        this.gridLayer.addConfiguration((IConfiguration)new GridLayerConfiguration(this.gridLayer, this));
        DataLayer bodyDataLayer = this.bodyLayerStack.getBodyDataLayer();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.natTable = new NatTable((Composite)this, (ILayer)this.gridLayer, false);
        for (MouseListener mouseListener : this.mouseListeners) {
            this.natTable.addMouseListener(mouseListener);
        }
        this.addCustomStyling();
        this.natTable.addConfiguration((IConfiguration)new StyleConfiguration(this.bodyLayerStack, this));
        if (this.tableWidgetController.isDataEditable()) {
            this.natTable.addConfiguration((IConfiguration)this.editableGridConfiguration(columnLabelAccumulator, this.fBodyDataProvider));
        }
        this.natTable.configure();
        this.initializeColumnAndRowSize();
        this.addDragAndDropSupport();
        this.addDataLayerListener();
        this.addColumnReorderLayerListener();
        this.updateHiddenColumns();
        this.setupContextMenu();
        this.addSelectionListener();
        this.layout();
        if (reset && !this.natTable.isDisposed()) {
            this.natTable.getHorizontalBar().setSelection(horizontalScrollbarPos);
            this.natTable.getHorizontalBar().notifyListeners(13, new Event());
            this.natTable.getVerticalBar().setSelection(verticalScrollbarPos);
            this.natTable.getVerticalBar().notifyListeners(13, new Event());
            if (selectedCells != null) {
                this.bodyLayerStack.getSelectionLayer().clear();
                PositionCoordinate[] positionCoordinateArray = selectedCells;
                int n3 = selectedCells.length;
                int n4 = 0;
                while (n4 < n3) {
                    PositionCoordinate coordinate = positionCoordinateArray[n4];
                    this.bodyLayerStack.getSelectionLayer().selectCell(coordinate.columnPosition, coordinate.rowPosition, false, true);
                    ++n4;
                }
            }
        }
        this.tableSelectionChanged();
        this.tableWidgetController.notifyActions();
        if (takeFocus) {
            this.natTable.setFocus();
        }
        DebugUtils.debug((boolean)DEBUG, (String)"End");
    }

    private void initializeColumnAndRowSize() {
        DataLayer bodyDataLayer = this.bodyLayerStack.getBodyDataLayer();
        bodyDataLayer.setDefaultRowHeight(DefaultSizeUtils.getCellHeight(-1));
        bodyDataLayer.setRowsResizableByDefault(true);
        bodyDataLayer.setDefaultColumnWidth(DefaultSizeUtils.getCellWidth(-1));
        bodyDataLayer.setColumnsResizableByDefault(true);
        Table table = this.tableWidgetController.getTable();
        int i = 0;
        while (i < bodyDataLayer.getColumnCount()) {
            EList columns = table.getColumns();
            Column column = (Column)columns.get(i);
            int actualWidth = column.getWidth();
            if (actualWidth != -1) {
                int cellWidth = DefaultSizeUtils.getCellWidth(actualWidth);
                bodyDataLayer.setColumnWidthByPosition(i, cellWidth);
            }
            ++i;
        }
        i = 0;
        while (i < bodyDataLayer.getRowCount()) {
            EList rows = table.getRows();
            Row row = (Row)rows.get(i);
            int actualHeight = row.getHeight();
            if (actualHeight != -1) {
                int cellHeight = DefaultSizeUtils.getCellHeight(actualHeight);
                bodyDataLayer.setRowHeightByPosition(i, cellHeight);
            }
            ++i;
        }
    }

    private void addDragAndDropSupport() {
        this.addDropSupport();
        this.addDragSupport();
    }

    private void addDropSupport() {
        int operations = 19;
        DropTarget target = new DropTarget((Control)this.natTable, operations);
        target.setTransfer(this.transfers);
        NatTableDropListener dropListener = new NatTableDropListener(this.natTable, this);
        target.addDropListener((DropTargetListener)dropListener);
    }

    private void addDragSupport() {
        DragSource source = new DragSource((Control)this.natTable, 7);
        source.setTransfer(this.transfers);
        TableDragSourceListener listener = new TableDragSourceListener(this.tableWidgetController, this.natTable);
        source.addDragListener((DragSourceListener)listener);
    }

    private void addColumnReorderLayerListener() {
        this.bodyLayerStack.getColumnReorderLayer().addLayerListener(new ILayerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleLayerEvent(ILayerEvent event) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (NatTableWidget.this.tableWidgetController.getListenReorderEvent()) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            NatTableWidget.this.listenColumn = false;
                        }
                        if (event instanceof ColumnReorderEvent) {
                            ColumnReorderEvent columnReorderEvent = (ColumnReorderEvent)event;
                            int start = -1;
                            int end = columnReorderEvent.getBeforeToColumnPosition();
                            Iterator iterator = columnReorderEvent.getBeforeFromColumnPositionRanges().iterator();
                            if (iterator.hasNext()) {
                                Range range = (Range)iterator.next();
                                start = range.start;
                            }
                            if (start != -1) {
                                Column element;
                                if (start >= 0 && start < end) {
                                    --end;
                                }
                                if ((element = (Column)NatTableWidget.this.tableWidgetController.getTable().getColumns().get(start)) != null) {
                                    NatTableWidget.this.tableWidgetController.moveColumn(element, end);
                                }
                            }
                        }
                        var3_3 = this;
                        synchronized (var3_3) {
                            NatTableWidget.this.listenColumn = true;
                        }
                    }
                }
            }
        });
    }

    private void addDataLayerListener() {
        this.bodyLayerStack.getBodyDataLayer().addLayerListener(new ILayerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleLayerEvent(ILayerEvent event) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (NatTableWidget.this.listenColumn) {
                        2 var3_3 = this;
                        synchronized (var3_3) {
                            NatTableWidget.this.listenColumn = false;
                        }
                        if (event instanceof ColumnResizeEvent) {
                            ColumnResizeEvent columnResizeEvent = (ColumnResizeEvent)event;
                            Collection rangeList = columnResizeEvent.getColumnPositionRanges();
                            for (Range r : rangeList) {
                                if (r.start == -1) continue;
                                int width = NatTableWidget.this.bodyLayerStack.getColumnReorderLayer().getColumnWidthByPosition(r.start);
                                Column column = (Column)NatTableWidget.this.tableWidgetController.getTable().getColumns().get(r.start);
                                NatTableWidget.this.tableWidgetController.setColumnWidth(column, width);
                            }
                        } else if (event instanceof RowResizeEvent) {
                            RowResizeEvent rowResizeEvent = (RowResizeEvent)event;
                            Collection rangeList = rowResizeEvent.getRowPositionRanges();
                            for (Range r : rangeList) {
                                if (r.start == -1) continue;
                                int height = NatTableWidget.this.getBodyLayer().getViewportLayer().getRowHeightByPosition(r.start);
                                Row row = (Row)NatTableWidget.this.tableWidgetController.getTable().getRows().get(r.start);
                                NatTableWidget.this.tableWidgetController.setRowHeight(row, height);
                            }
                        }
                        var3_3 = this;
                        synchronized (var3_3) {
                            NatTableWidget.this.listenColumn = true;
                        }
                    }
                }
            }
        });
    }

    private void addSelectionListener() {
        this.natTable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent || event instanceof RowSelectionEvent || event instanceof ColumnSelectionEvent) {
                    NatTableWidget.this.tableSelectionChanged();
                }
            }
        });
    }

    public void tableSelectionChanged() {
        this.computeGridSelection();
        this.tableWidgetController.tableSelectionChanged();
    }

    protected void computeGridSelection() {
        PositionCoordinate[] selectedCells;
        if (this.bodyLayerStack == null) {
            throw new IllegalStateException("body layer stack must not be null");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Table table = this.tableWidgetController.getTable();
        EList rows = table.getRows();
        EList columns = table.getColumns();
        SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
        int[] fullySelectedRows = selectionLayer.getFullySelectedRowPositions();
        int[] fullySelectedColumns = selectionLayer.getFullySelectedColumnPositions();
        int nRows = rows.size();
        int[] nArray = fullySelectedRows;
        int n = fullySelectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i < nRows) {
                Row row = (Row)rows.get(i);
                result.add(row);
            } else {
                Logger.logError((String)("Wrong row offset : " + i + " (" + nRows + " rows)"), (Plugin)Activator.getDefault());
            }
            ++n2;
        }
        int nColumns = columns.size();
        int[] nArray2 = fullySelectedColumns;
        int n3 = fullySelectedColumns.length;
        n = 0;
        while (n < n3) {
            int i = nArray2[n];
            if (i >= 0 && i < nColumns) {
                Column column = (Column)columns.get(i);
                result.add(column);
            } else {
                Logger.logError((String)("Wrong column offset : " + i + " (" + nColumns + " columns)"), (Plugin)Activator.getDefault());
            }
            ++n;
        }
        PositionCoordinate[] positionCoordinateArray = selectedCells = selectionLayer.getSelectedCells();
        int n4 = selectedCells.length;
        n3 = 0;
        while (n3 < n4) {
            Object dataValue;
            PositionCoordinate positionCoordinate = positionCoordinateArray[n3];
            LayerCell cell = selectionLayer.getCellByPosition(positionCoordinate.getColumnPosition(), positionCoordinate.getRowPosition());
            if (cell != null && (dataValue = cell.getDataValue()) instanceof IGridElement) {
                IGridElement gridElement = (IGridElement)dataValue;
                result.add(gridElement);
            }
            ++n3;
        }
        this.gridSelection = Collections.unmodifiableList(result);
    }

    public List<Object> getGridSelection() {
        return this.gridSelection;
    }

    private List<Integer> getSelectedRows() {
        ArrayList<Integer> rowsIndex = new ArrayList<Integer>();
        if (this.bodyLayerStack != null) {
            int[] selectedRows;
            SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
            int[] nArray = selectedRows = selectionLayer.getFullySelectedRowPositions();
            int n = selectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                rowsIndex.add(index);
                ++n2;
            }
        }
        return rowsIndex;
    }

    private List<LayerCell> getSelectedCells() {
        PositionCoordinate[] selectedPositions;
        ArrayList<LayerCell> selectedCells = new ArrayList<LayerCell>();
        SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
        PositionCoordinate[] positionCoordinateArray = selectedPositions = selectionLayer.getSelectedCells();
        int n = selectedPositions.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate positionCoordinate = positionCoordinateArray[n2];
            LayerCell cell = selectionLayer.getCellByPosition(positionCoordinate.getColumnPosition(), positionCoordinate.getRowPosition());
            if (cell != null) {
                selectedCells.add(cell);
            }
            ++n2;
        }
        return selectedCells;
    }

    public IPositionCoordinate[] getSelectedCells2() {
        PositionCoordinate[] pc = this.getBodyLayer().getSelectionLayer().getSelectedCells();
        IPositionCoordinate[] result = new IPositionCoordinate[pc.length];
        int i = 0;
        while (i < pc.length) {
            result[i] = new PositionCoordinateWrapper(pc[i]);
            ++i;
        }
        return result;
    }

    public List<IPositionCoordinate> getSelectedCellsPositions() {
        return Arrays.asList(this.getSelectedCells2());
    }

    public List<PositionCoordinate> getSelectedCellsPositionCoordinates() {
        return Collections.unmodifiableList(Arrays.asList(this.getBodyLayer().getSelectionLayer().getSelectedCells()));
    }

    private int convertColumnPositionDataToHideShow(int column) {
        int i = 0;
        while (i < this.fBodyDataProvider.getColumnCount()) {
            ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate((ILayer)this.bodyLayerStack.getColumnHideShowLayer(), i), (ILayer)this.bodyLayerStack.getBodyDataLayer());
            if (converted != null && converted.getColumnPosition() == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int convertColumnPositionDataToReorder(int column) {
        int i = 0;
        while (i < this.fBodyDataProvider.getColumnCount()) {
            ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate((ILayer)this.bodyLayerStack.getColumnReorderLayer(), i), (ILayer)this.bodyLayerStack.getBodyDataLayer());
            if (converted.getColumnPosition() == column) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("column index not found");
    }

    public int convertColumnPositionSelectionToData(int column) {
        ColumnPositionCoordinate columnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate((ILayer)this.getBodyLayer().getSelectionLayer(), column), (ILayer)this.getBodyLayer().getBodyDataLayer());
        return columnPositionCoordinate.getColumnPosition();
    }

    public int convertCellPositionToDataLayer(LayerCell cell) {
        ColumnPositionCoordinate columnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate(cell.getLayer(), cell.getColumnPosition()), (ILayer)this.getBodyLayer().getBodyDataLayer());
        return columnPositionCoordinate.getColumnPosition();
    }

    private void addCustomStyling() {
        DefaultNatTableStyleConfiguration natTableConfiguration = new DefaultNatTableStyleConfiguration();
        natTableConfiguration.hAlign = HorizontalAlignmentEnum.LEFT;
        natTableConfiguration.vAlign = VerticalAlignmentEnum.TOP;
        DefaultSelectionStyleConfiguration selectionStyle = new DefaultSelectionStyleConfiguration();
        selectionStyle.selectionBgColor = BG_COLOR;
        selectionStyle.selectionFgColor = GUIHelper.COLOR_BLACK;
        selectionStyle.anchorBorderStyle = new BorderStyle(1, GUIHelper.COLOR_DARK_GRAY, BorderStyle.LineStyleEnum.SOLID);
        selectionStyle.anchorBgColor = BG_COLOR;
        selectionStyle.anchorFgColor = GUIHelper.COLOR_BLACK;
        selectionStyle.selectedHeaderFgColor = GUIHelper.COLOR_BLACK;
        this.natTable.addConfiguration((IConfiguration)natTableConfiguration);
        this.natTable.addConfiguration((IConfiguration)selectionStyle);
        this.natTable.addConfiguration((IConfiguration)new StyledRowHeaderConfiguration());
        this.natTable.addConfiguration((IConfiguration)new StyledColumnHeaderConfiguration(this.bodyLayerStack, (List<Column>)this.tableWidgetController.getTable().getColumns(), this.tableWidgetController.getTableLabelProvider(), this));
    }

    private AbstractRegistryConfiguration editableGridConfiguration(final ColumnOverrideLabelAccumulator columnLabelAccumulator, IDataProvider dataProvider) {
        return new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                if (NatTableWidget.this.tableWidgetController.getEditingDomain() != null) {
                    int nColumn = 0;
                    while (nColumn < NatTableWidget.this.tableWidgetController.getTable().getColumns().size()) {
                        Column columnDescription = (Column)NatTableWidget.this.tableWidgetController.getTable().getColumns().get(nColumn);
                        if (columnDescription instanceof FeatureColumn) {
                            FeatureColumn attributeColumn = (FeatureColumn)columnDescription;
                            if (attributeColumn.getFeature().getEType() instanceof EEnum) {
                                NatTableWidget.this.registerEnumCellEditor(configRegistry, (EEnum)attributeColumn.getFeature().getEType(), columnLabelAccumulator, nColumn, columnDescription);
                            } else {
                                NatTableWidget.this.registerCellEditorForColumn(columnLabelAccumulator, nColumn, columnDescription);
                            }
                        } else {
                            NatTableWidget.this.registerCellEditorForColumn(columnLabelAccumulator, nColumn, columnDescription);
                        }
                        ++nColumn;
                    }
                    NatTableWidget.this.registerLocalCellEditors(configRegistry);
                    List allCellEditorContainers = ICellEditorsRegistry.INSTANCE.getAllCellEditors();
                    for (IModelCellEditorContainer modelCellEditorContainer : allCellEditorContainers) {
                        NatTableWidget.this.registerCellEditor((IModelCellEditorContainer<? extends AbstractModelCellEditor>)modelCellEditorContainer, configRegistry);
                    }
                }
            }
        };
    }

    private void registerLocalCellEditors(IConfigRegistry configRegistry) {
        TableConfiguration tableConfiguration = this.tableWidgetController.getTableConfiguration();
        if (tableConfiguration != null) {
            EList forcedCellEditors = tableConfiguration.getForcedCellEditors();
            for (AbstractModelCellEditor modelCellEditor : forcedCellEditors) {
                if (NatTableWidget.isInCellEditorRegistry(modelCellEditor)) continue;
                String bundleName = CellEditorsUtils.getBundleNameFor((AbstractModelCellEditor)modelCellEditor, (ResourceSet)this.tableWidgetController.getTableConfiguration().eResource().getResourceSet());
                ModelCellEditorContainer modelCellEditorContainer = null;
                if (modelCellEditor instanceof BasicCellEditor) {
                    BasicCellEditor basicCellEditor = (BasicCellEditor)modelCellEditor;
                    modelCellEditorContainer = new ModelCellEditorContainer();
                    modelCellEditorContainer.setBundleName(bundleName);
                    modelCellEditorContainer.setModelCellEditor((AbstractModelCellEditor)basicCellEditor);
                } else if (modelCellEditor instanceof UnaryReferenceCellEditor) {
                    UnaryReferenceCellEditor unaryReferenceCellEditor = (UnaryReferenceCellEditor)modelCellEditor;
                    modelCellEditorContainer = new ModelCellEditorContainer();
                    modelCellEditorContainer.setBundleName(bundleName);
                    modelCellEditorContainer.setModelCellEditor((AbstractModelCellEditor)unaryReferenceCellEditor);
                } else if (modelCellEditor instanceof NaryFeatureCellEditor) {
                    NaryFeatureCellEditor naryFeatureCellEditor = (NaryFeatureCellEditor)modelCellEditor;
                    modelCellEditorContainer = new ModelCellEditorContainer();
                    modelCellEditorContainer.setBundleName(bundleName);
                    modelCellEditorContainer.setModelCellEditor((AbstractModelCellEditor)naryFeatureCellEditor);
                } else {
                    Logger.logError((String)("Not handled: " + modelCellEditor.getClass().getSimpleName()), (Plugin)Activator.getDefault());
                }
                this.registerCellEditor((IModelCellEditorContainer<? extends AbstractModelCellEditor>)modelCellEditorContainer, configRegistry);
            }
        }
    }

    private static boolean isInCellEditorRegistry(AbstractModelCellEditor cellEditor) {
        List allCellEditorContainers = ICellEditorsRegistry.INSTANCE.getAllCellEditors();
        for (IModelCellEditorContainer currentEditorContainer : allCellEditorContainers) {
            if (!cellEditor.getCellId().equals(currentEditorContainer.getModelCellEditor().getCellId())) continue;
            return true;
        }
        return false;
    }

    private void registerCellEditorForColumn(ColumnOverrideLabelAccumulator columnLabelAccumulator, int nColumn, Column column) {
        if (column instanceof FeatureColumn) {
            ModelCellEditor selectedCellEditor;
            EStructuralFeature structuralFeature;
            FeatureColumn featureColumn = (FeatureColumn)column;
            ETypedElement feature = featureColumn.getFeature();
            if (feature instanceof EStructuralFeature && !(structuralFeature = (EStructuralFeature)feature).isChangeable()) {
                return;
            }
            TableConfiguration tableConfiguration = this.tableWidgetController.getTableConfiguration();
            EList forcedCellEditors = null;
            if (tableConfiguration != null) {
                forcedCellEditors = tableConfiguration.getForcedCellEditors();
            }
            if ((selectedCellEditor = ((CellEditorsRegistry)ICellEditorsRegistry.INSTANCE).getCellEditorWrapperFor(feature.getEType(), feature.isMany(), (List)forcedCellEditors)) != null) {
                columnLabelAccumulator.registerColumnOverrides(nColumn, new String[]{selectedCellEditor.getCellID()});
            } else {
                Logger.logWarning((String)("No cell editor defined for type: " + EcoreUtil.getURI((EObject)feature.getEType()) + " (column " + nColumn + ")"), (Plugin)Activator.getDefault());
            }
        }
    }

    private void registerEnumCellEditor(IConfigRegistry configRegistry, EEnum eType, ColumnOverrideLabelAccumulator columnLabelAccumulator, int nColumn, Column columnDescription) {
        columnLabelAccumulator.registerColumnOverrides(nColumn, new String[]{ENUM_CELLEDITOR_LABEL});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new NatTableCellEditorAdapter((IModelCellEditor)new EEnumCellEditor(), (List<Column>)this.tableWidgetController.getTable().getColumns(), this.tableWidgetController.getFacetContext()), "NORMAL", ENUM_CELLEDITOR_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", ENUM_CELLEDITOR_LABEL);
    }

    private void registerCellEditor(IModelCellEditorContainer<? extends AbstractModelCellEditor> modelCellEditorContainer, IConfigRegistry configRegistry) {
        IModelCellEditor modelCellEditorImpl;
        ModelCellEditor cellEditor = new ModelCellEditor(modelCellEditorContainer.getBundleName(), modelCellEditorContainer.getModelCellEditor());
        Object cellEditorImplementation = cellEditor.getCellEditorImplementation();
        if (cellEditorImplementation instanceof IModelCellEditor) {
            modelCellEditorImpl = (IModelCellEditor)cellEditorImplementation;
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new NatTableCellEditorAdapter(modelCellEditorImpl, (List<Column>)this.tableWidgetController.getTable().getColumns(), this.tableWidgetController.getFacetContext()), "NORMAL", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", cellEditor.getCellID());
        } else if (cellEditorImplementation instanceof INaryFeatureCellEditor) {
            modelCellEditorImpl = (INaryFeatureCellEditor)cellEditorImplementation;
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new NatTableNaryReferenceCellEditorAdapter((INaryFeatureCellEditor)modelCellEditorImpl, (List<Column>)this.tableWidgetController.getTable().getColumns(), this.tableWidgetController.getEditingDomain()), "NORMAL", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)IDataValidator.NEVER_VALID, "EDIT", cellEditor.getCellID());
        } else if (cellEditorImplementation instanceof INaryEAttributeCellEditor) {
            modelCellEditorImpl = (INaryEAttributeCellEditor)cellEditorImplementation;
            NatTableNaryEAttributeCellEditorAdapter cellEditorAdapter = new NatTableNaryEAttributeCellEditorAdapter(modelCellEditorImpl, (List<Column>)this.tableWidgetController.getTable().getColumns(), this.tableWidgetController.getFacetContext(), this.tableWidgetController.getEditingDomain());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, cellEditorAdapter, "NORMAL", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)IDataValidator.NEVER_VALID, "EDIT", cellEditor.getCellID());
        } else if (cellEditorImplementation instanceof INaryEReferenceCellEditor) {
            modelCellEditorImpl = (INaryEReferenceCellEditor)cellEditorImplementation;
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, new NatTableNaryEReferenceCellEditorAdapter(modelCellEditorImpl, (List<Column>)this.tableWidgetController.getTable().getColumns(), this.tableWidgetController.getFacetContext(), this.tableWidgetController.getEditingDomain()), "NORMAL", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", cellEditor.getCellID());
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)IDataValidator.NEVER_VALID, "EDIT", cellEditor.getCellID());
        } else {
            Logger.logError((String)("Model cell editor implementation must be an instance of " + IModelCellEditor.class.getSimpleName() + " or " + INaryFeatureCellEditor.class.getSimpleName()), (Plugin)Activator.getDefault());
            return;
        }
        if (cellEditorImplementation instanceof IModelCellEditorValidator) {
            IModelCellEditorValidator modelCellEditorValidator = (IModelCellEditorValidator)cellEditorImplementation;
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new DataValidatorAdapter(modelCellEditorValidator), "EDIT", cellEditor.getCellID());
        }
    }

    public boolean setFocus() {
        return this.natTable.setFocus();
    }

    private void updateHiddenColumns() {
        this.bodyLayerStack.getColumnHideShowLayer().showAllColumns();
        ArrayList<Integer> columnsToHide = new ArrayList<Integer>();
        TableWidgetUtils.getElements((Table)this.tableWidgetController.getTable());
        try {
            this.natTable.setRedraw(false);
            int nColumn = 0;
            for (Column column : this.tableWidgetController.getTable().getColumns()) {
                int converted;
                boolean isNonCommon;
                boolean isHidden = false;
                boolean isEmpty = this.tableWidgetController.getTable().isHideEmptyColumns() && this.tableWidgetController.isEmptyColumn(column);
                boolean bl = isNonCommon = this.tableWidgetController.getTable().isOnlyShowCommonColumns() && this.tableWidgetController.isNonCommonColumns(column);
                if (column instanceof FeatureColumn) {
                    ETypedElement columnFeature = ((FeatureColumn)column).getFeature();
                    try {
                        isHidden = (Boolean)this.tableWidgetController.getCustomizationEngine().getCustomValueOf((EObject)columnFeature, this.tableWidgetController.getCustomPropertiesHandler().getIsVisible(), Boolean.class) == false;
                    }
                    catch (CustomizationException e) {
                        Logger.logError((Throwable)e, (String)"Error getting column visibility", (Plugin)Activator.getDefault());
                    }
                } else if (column instanceof SourceColumn) {
                    SourceColumn sourceColumn = (SourceColumn)column;
                    isHidden = sourceColumn.isIsHidden();
                } else {
                    throw new IllegalStateException("Unknown column type");
                }
                if ((isHidden || isNonCommon || isEmpty) && (converted = this.convertColumnPositionDataToHideShow(nColumn)) != -1) {
                    columnsToHide.add(converted);
                }
                ++nColumn;
            }
        }
        finally {
            this.natTable.setRedraw(true);
        }
        this.bodyLayerStack.getColumnHideShowLayer().hideColumnPositions(columnsToHide);
    }

    private boolean getHiddenAttributeColumnStatus(FeatureColumn c, Set<EClass> featureOwners) throws CustomizationException {
        ETypedElement feature = c.getFeature();
        return (Boolean)this.tableWidgetController.getCustomizationEngine().getCustomValueOf((EObject)feature, this.tableWidgetController.getCustomPropertiesHandler().getIsVisible(), Boolean.class);
    }

    public boolean isCellSelected() {
        return this.bodyLayerStack.getSelectionLayer().getSelectedCells().length > 0;
    }

    public List<Column> getSelectedColumns() {
        SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
        ArrayList<Column> listColumn = new ArrayList<Column>();
        List<LayerCell> selectedCells = this.getSelectedCells();
        int[] nArray = selectionLayer.getSelectedColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int colPos = nArray[n2];
            if (this.isColumnSelected(colPos, selectedCells)) {
                int pos = this.bodyLayerStack.getSelectionLayer().getColumnIndexByPosition(colPos);
                if (this.tableWidgetController.getTable().getColumns().get(pos) != null) {
                    Column localColumn = (Column)this.tableWidgetController.getTable().getColumns().get(pos);
                    listColumn.add(localColumn);
                }
            } else {
                return null;
            }
            ++n2;
        }
        return listColumn;
    }

    private boolean isColumnSelected(int colPos, List<LayerCell> selectedCells) {
        int rowPos = 0;
        while (rowPos < this.bodyLayerStack.getRowCount()) {
            LayerCell localCell = this.bodyLayerStack.getSelectionLayer().getCellByPosition(colPos, rowPos);
            if (localCell != null && !selectedCells.contains(localCell)) {
                return false;
            }
            ++rowPos;
        }
        return true;
    }

    private void setupContextMenu() {
        if (this.tableWidgetController.getMenuManager() != null) {
            Menu menu = this.tableWidgetController.getMenuManager().createContextMenu((Control)this.natTable);
            this.natTable.setMenu(menu);
        }
    }

    public BodyLayerStack getBodyLayer() {
        return this.bodyLayerStack;
    }

    public void copySelectionToClipboard() {
        new CopyToClipboardCommandHandler(this.bodyLayerStack.getSelectionLayer(), this).doCommand(new CopyDataToClipboardCommand(new Clipboard(Display.getDefault()), "\t", "\n"));
    }

    public PositionCoordinate getCellPositionAt(int x, int y) {
        int column = this.natTable.getColumnPositionByX(x);
        int row = this.natTable.getRowPositionByY(y);
        PositionCoordinate convertedPosition = LayerCommandUtil.convertPositionToTargetContext((PositionCoordinate)new PositionCoordinate((ILayer)this.gridLayer, column, row), (ILayer)this.bodyLayerStack.getSelectionLayer());
        return convertedPosition;
    }

    public LayerCell getCellAt(int column, int row) {
        return this.bodyLayerStack.getSelectionLayer().getCellByPosition(column, row);
    }

    public void selectAll() {
        this.natTable.doCommand((ILayerCommand)new SelectAllCommand());
        this.natTable.redraw();
        this.tableSelectionChanged();
    }

    public void selectDefaultLabelCell(EObject eObject) {
        throw new UnsupportedOperationException("the default label column doesn't exist anymore");
    }

    public void selectCell(EObject eObject, EStructuralFeature eStructuralFeature) {
        int rowIndex = this.getRowIndexByEObject(eObject);
        if (rowIndex == -1) {
            return;
        }
        int columnIndex = -1;
        int i = 0;
        while (i < this.tableWidgetController.getTable().getColumns().size()) {
            FeatureColumn featureColumn;
            Column column = (Column)this.tableWidgetController.getTable().getColumns().get(i);
            if (column instanceof FeatureColumn && (featureColumn = (FeatureColumn)column).getFeature() == eStructuralFeature) {
                columnIndex = i;
                break;
            }
            ++i;
        }
        if (columnIndex == -1) {
            return;
        }
        SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
        selectionLayer.selectCell(columnIndex, rowIndex, false, false);
        this.tableSelectionChanged();
    }

    private int getRowIndexByEObject(EObject eObject) {
        int rowIndex = -1;
        EList rows = this.tableWidgetController.getTable().getRows();
        int i = 0;
        while (i < rows.size()) {
            if (((Row)rows.get(i)).getElement().equals(eObject)) {
                rowIndex = i;
                break;
            }
            ++i;
        }
        return rowIndex;
    }

    public void editSelectedCell() {
        List<LayerCell> cells = this.getSelectedCells();
        if (cells != null && !cells.isEmpty()) {
            LayerCell cell = cells.get(0);
            SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
            selectionLayer.fireLayerEvent((ILayerEvent)new InlineCellEditEvent((ILayer)selectionLayer, new PositionCoordinate((ILayer)selectionLayer, cell.getColumnPosition(), cell.getRowPosition()), (Composite)this.natTable, this.natTable.getConfigRegistry(), null));
        }
    }

    public List<Column> getVisibleColumnsUsingTheLayer() {
        ArrayList<Column> notHiddenColumns = new ArrayList<Column>();
        ColumnHideShowLayer layer = this.bodyLayerStack.getColumnHideShowLayer();
        EList allColumns = this.tableWidgetController.getTable().getColumns();
        int i = 0;
        while (i < allColumns.size()) {
            if (!layer.isColumnIndexHidden(i)) {
                notHiddenColumns.add((Column)allColumns.get(i));
            }
            ++i;
        }
        return notHiddenColumns;
    }

    public Point getCellPositionRelativeToDisplay(int columnPosition, int rowPosition) {
        Rectangle rect = this.bodyLayerStack.getSelectionLayer().getBoundsByPosition(columnPosition, rowPosition);
        return new Point(rect.x, rect.y);
    }

    public void selectRows(List<EObject> elementsToSelect, boolean clearTheSelection) {
        int columnPosition = 0;
        EList allRows = this.tableWidgetController.getTable().getRows();
        ArrayList<Integer> rowsToSelect = new ArrayList<Integer>();
        int i = 0;
        while (i < elementsToSelect.size()) {
            Row row = this.tableWidgetController.findRow(elementsToSelect.get(i));
            if (row != null) {
                rowsToSelect.add(allRows.indexOf(row));
            }
            ++i;
        }
        int[] rowPositions = new int[rowsToSelect.size()];
        int i2 = 0;
        while (i2 < rowsToSelect.size()) {
            rowPositions[i2] = (Integer)rowsToSelect.get(i2);
            ++i2;
        }
        SelectionLayer layer = this.bodyLayerStack.getSelectionLayer();
        if (clearTheSelection) {
            layer.clear();
        }
        if (rowPositions.length != 0) {
            this.natTable.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)this.bodyLayerStack.getSelectionLayer(), columnPosition, rowPositions, false, true));
        }
        this.natTable.redraw();
        this.tableSelectionChanged();
    }

    public void setRedraw(boolean redraw) {
        this.natTable.setRedraw(redraw);
    }

    public void redraw() {
        if (DEBUG) {
            DebugUtils.debug((String)"");
        }
        this.natTable.redraw();
    }

    public final String[] getColumnNames() {
        EList<Column> columns = this.getColumns();
        String[] result = new String[columns.size()];
        int i = 0;
        while (i < columns.size()) {
            Column column = (Column)columns.get(i);
            result[i] = TableWidgetInternalUtils.getLabel((Column)column, (ITableWidgetInternal)this.tableWidgetController);
            ++i;
        }
        if (DEBUG) {
            DebugUtils.debug((String)("nbColumn=" + columns.size()));
            DebugUtils.debug((String)("columnNames.length=" + result.length));
        }
        return result;
    }

    protected EList<Column> getColumns() {
        Table table = this.tableWidgetController.getTable();
        return table.getColumns();
    }

    public ITableWidgetInternal getController() {
        return this.tableWidgetController;
    }

    public Composite asComposite() {
        return this;
    }

    public void dispose() {
        if (this.natTable != null) {
            this.natTable.dispose();
        }
        super.dispose();
    }

    public class BodyLayerStack
    extends AbstractLayerTransform {
        private final SelectionLayer selectionLayer;
        private final DataLayer bodyDataLayer;
        private final ViewportLayer viewportLayer;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final ColumnReorderLayer columnReorderLayer;

        public BodyLayerStack(IDataProvider dataProvider) {
            this.bodyDataLayer = new DataLayer(dataProvider);
            this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.bodyDataLayer);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)this.viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public DataLayer getBodyDataLayer() {
            return this.bodyDataLayer;
        }

        public ViewportLayer getViewportLayer() {
            return this.viewportLayer;
        }

        public ColumnHideShowLayer getColumnHideShowLayer() {
            return this.columnHideShowLayer;
        }

        public ColumnReorderLayer getColumnReorderLayer() {
            return this.columnReorderLayer;
        }
    }

    public class ElementsDescription {
        private boolean containsEObjects;
        private boolean containsPrimitiveTypes;
        private boolean containsContexts;

        public boolean getContainsEObjects() {
            return this.containsEObjects;
        }

        public boolean getContainsPrimitiveTypes() {
            return this.containsPrimitiveTypes;
        }

        public boolean getContainsContexts() {
            return this.containsContexts;
        }

        public void setContainsContexts(boolean containsContexts) {
            this.containsContexts = containsContexts;
        }

        protected void setContainsEObjects(boolean containsEObjects) {
            this.containsEObjects = containsEObjects;
        }

        protected void setContainsPrimitiveTypes(boolean containsPrimitiveTypes) {
            this.containsPrimitiveTypes = containsPrimitiveTypes;
        }
    }
}

