/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.ConcurrentValue;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XATransactionCommitContext
extends TransactionCommitContext {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, XATransactionCommitContext.class);
    private ConcurrentValue<CommitState> state = new ConcurrentValue((Object)CommitState.STARTING);
    public static final Object PHASEAPPLYMAPPING = new Object(){

        public int hashCode() {
            return CommitState.APPLY_ID_MAPPING.hashCode();
        }

        public boolean equals(Object object) {
            if (object == CommitState.ROLLED_BACK) {
                throw new RuntimeException("RolledBack");
            }
            return CommitState.APPLY_ID_MAPPING == object;
        }
    };
    public static final Object PHASEAPPLYMAPPING_DONE = new Object(){

        public int hashCode() {
            return CommitState.APPLY_ID_MAPPING_DONE.hashCode();
        }

        public boolean equals(Object object) {
            if (object == CommitState.ROLLED_BACK) {
                throw new RuntimeException("RolledBack");
            }
            return CommitState.APPLY_ID_MAPPING_DONE == object;
        }
    };

    public XATransactionCommitContext(InternalTransaction transaction) {
        super(transaction);
    }

    public ConcurrentValue<CommitState> getState() {
        return this.state;
    }

    @Override
    public void preWrite() {
        super.preWrite();
        StoreThreadLocal.setAccessor(null);
    }

    @Override
    public void commit(OMMonitor monitor) {
        StoreThreadLocal.setAccessor(this.getAccessor());
        try {
            super.commit(monitor);
        }
        finally {
            StoreThreadLocal.setAccessor(null);
        }
    }

    @Override
    public void write(OMMonitor monitor) {
        StoreThreadLocal.setAccessor(this.getAccessor());
        try {
            super.write(monitor);
        }
        finally {
            StoreThreadLocal.setAccessor(null);
        }
    }

    @Override
    public void postCommit(boolean success) {
        StoreThreadLocal.setAccessor(this.getAccessor());
        IRepository repository = this.getTransaction().getRepository();
        repository.getCommitManager().remove(this);
        super.postCommit(success);
    }

    @Override
    public synchronized void rollback(String message) {
        super.rollback(message);
        this.state.set((Object)CommitState.ROLLED_BACK);
    }

    @Override
    public void applyIDMappings(OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Notify phase2 to fill ID mapping.", new Object[0]);
        }
        this.state.set((Object)CommitState.APPLY_ID_MAPPING);
        if (TRACER.isEnabled()) {
            TRACER.format("Waiting for phase2 to be completed before continueing.", new Object[0]);
        }
        try {
            this.state.acquire(PHASEAPPLYMAPPING_DONE);
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Received signal to continue.", new Object[0]);
        }
        super.applyIDMappings(monitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommitState {
        STARTING,
        APPLY_ID_MAPPING,
        APPLY_ID_MAPPING_DONE,
        ROLLED_BACK;

    }
}

