/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;

public class IgnoreOperation
implements IEGitOperation {
    private final Collection<IPath> paths;
    private boolean gitignoreOutsideWSChanged;
    private ISchedulingRule schedulingRule;

    public IgnoreOperation(Collection<IPath> paths) {
        this.paths = paths;
        this.gitignoreOutsideWSChanged = false;
        this.schedulingRule = this.calcSchedulingRule();
    }

    @Deprecated
    public IgnoreOperation(IResource[] resources) {
        this.paths = new ArrayList<IPath>(resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IPath location = resource.getLocation();
            if (location != null) {
                this.paths.add(location);
            }
            ++n2;
        }
        this.gitignoreOutsideWSChanged = false;
        this.schedulingRule = this.calcSchedulingRule();
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)CoreText.IgnoreOperation_taskName, (int)3);
        try {
            Map<IPath, Collection<String>> perFolder = this.getFolderMap((IProgressMonitor)progress.newChild(1));
            if (perFolder == null) {
                return;
            }
            if ((perFolder = this.pruneFolderMap(perFolder, (IProgressMonitor)progress.newChild(1))) == null) {
                return;
            }
            this.updateGitIgnores(perFolder, (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(Activator.error(CoreText.IgnoreOperation_error, e));
        }
    }

    public boolean isGitignoreOutsideWSChanged() {
        return this.gitignoreOutsideWSChanged;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    private Map<IPath, Collection<String>> getFolderMap(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.paths.size());
        HashMap<IPath, Collection<String>> result = new HashMap<IPath, Collection<String>>();
        for (IPath path : this.paths) {
            if (progress.isCanceled()) {
                return null;
            }
            IPath parent = path.removeLastSegments(1);
            LinkedHashSet<String> values = (LinkedHashSet<String>)result.get(parent);
            if (values == null) {
                values = new LinkedHashSet<String>();
                result.put(parent, values);
            }
            values.add(path.lastSegment());
            progress.worked(1);
        }
        return result;
    }

    private Map<IPath, Collection<String>> pruneFolderMap(Map<IPath, Collection<String>> perFolder, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)perFolder.size());
        for (Map.Entry<IPath, Collection<String>> entry : perFolder.entrySet()) {
            this.pruneFolder(entry.getKey(), entry.getValue(), (IProgressMonitor)progress.newChild(1));
            if (!progress.isCanceled()) continue;
            return null;
        }
        return perFolder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pruneFolder(IPath folder, Collection<String> files, IProgressMonitor monitor) throws IOException {
        if (files.isEmpty()) {
            return;
        }
        Repository repository = Activator.getDefault().getRepositoryCache().getRepository(folder);
        if (repository == null || repository.isBare()) {
            files.clear();
            return;
        }
        WorkingTreeIterator treeIterator = IteratorService.createInitialIterator(repository);
        if (treeIterator == null) {
            files.clear();
            return;
        }
        IPath repoRelativePath = folder.makeRelativeTo((IPath)new Path(repository.getWorkTree().getAbsolutePath()));
        if (repoRelativePath.equals((Object)folder)) {
            files.clear();
            return;
        }
        HashSet<String> repoRelative = new HashSet<String>(files.size());
        for (String file : files) {
            repoRelative.add(repoRelativePath.append(file).toPortableString());
        }
        files.clear();
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try {
            TreeWalk walk = new TreeWalk(repository);
            try {
                walk.addTree((AbstractTreeIterator)treeIterator);
                walk.setFilter(PathFilterGroup.createFromStrings(repoRelative));
            }
            finally {
                if (walk.next()) {
                }
                return;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void updateGitIgnores(Map<IPath, Collection<String>> perFolder, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(perFolder.size() * 2));
        for (Map.Entry<IPath, Collection<String>> entry : perFolder.entrySet()) {
            Collection<String> files;
            if (progress.isCanceled()) {
                return;
            }
            IContainer container = ResourceUtil.getContainerForLocation(entry.getKey(), false);
            if (container instanceof IWorkspaceRoot) {
                container = null;
            }
            if ((files = entry.getValue()).isEmpty()) {
                progress.worked(1);
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (String file : files) {
                IResource resource;
                builder.append('/').append(file);
                boolean isDirectory = false;
                IResource iResource = resource = container != null ? container.findMember(file) : null;
                isDirectory = resource != null ? resource.getType() != 1 : entry.getKey().append(file).toFile().isDirectory();
                if (isDirectory) {
                    builder.append('/');
                }
                builder.append('\n');
            }
            progress.worked(1);
            if (progress.isCanceled()) {
                return;
            }
            this.addToGitIgnore(container, entry.getKey(), builder.toString(), (IProgressMonitor)progress.newChild(1));
        }
    }

    private void addToGitIgnore(IContainer container, IPath parent, String entry, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (container == null) {
            Repository repository = Activator.getDefault().getRepositoryCache().getRepository(parent);
            if (repository == null || repository.isBare()) {
                String message = NLS.bind((String)CoreText.IgnoreOperation_parentOutsideRepo, (Object)parent.toOSString(), null);
                IStatus status = Activator.error(message, null);
                throw new CoreException(status);
            }
            IPath gitIgnorePath = parent.append(".gitignore");
            Path repoPath = new Path(repository.getWorkTree().getAbsolutePath());
            if (!repoPath.isPrefixOf(gitIgnorePath)) {
                String message = NLS.bind((String)CoreText.IgnoreOperation_parentOutsideRepo, (Object)parent.toOSString(), (Object)repoPath.toOSString());
                IStatus status = Activator.error(message, null);
                throw new CoreException(status);
            }
            File gitIgnore = new File(gitIgnorePath.toOSString());
            this.updateGitIgnore(gitIgnore, entry);
            this.gitignoreOutsideWSChanged = true;
        } else {
            IFile gitignore = container.getFile((IPath)new Path(".gitignore"));
            String toAdd = this.getEntry(gitignore.getLocation().toFile(), entry);
            ByteArrayInputStream entryBytes = this.asStream(toAdd);
            if (gitignore.exists()) {
                gitignore.appendContents((InputStream)entryBytes, true, true, (IProgressMonitor)progress.newChild(1));
            } else {
                gitignore.create((InputStream)entryBytes, true, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private boolean prependNewline(File file) throws IOException {
        boolean prepend = false;
        long length = file.length();
        if (length > 0L) {
            Throwable throwable = null;
            Object var6_6 = null;
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                ByteBuffer buffer = ByteBuffer.allocate(1);
                FileChannel channel = raf.getChannel();
                channel.position(length - 1L);
                if (channel.read(buffer) > 0) {
                    buffer.rewind();
                    prepend = buffer.get() != 10;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return prepend;
    }

    private String getEntry(File file, String entry) throws IOException {
        return this.prependNewline(file) ? String.valueOf('\n') + entry : entry;
    }

    private void updateGitIgnore(File gitIgnore, String entry) throws CoreException {
        try {
            String ignoreLine = entry;
            if (!gitIgnore.exists()) {
                if (!gitIgnore.createNewFile()) {
                    String error = NLS.bind((String)CoreText.IgnoreOperation_creatingFailed, (Object)gitIgnore.getAbsolutePath());
                    throw new CoreException(Activator.error(error, null));
                }
            } else {
                ignoreLine = this.getEntry(gitIgnore, ignoreLine);
            }
            try (FileOutputStream os = new FileOutputStream(gitIgnore, true);){
                os.write(ignoreLine.getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            String error = NLS.bind((String)CoreText.IgnoreOperation_updatingFailed, (Object)gitIgnore.getAbsolutePath());
            throw new CoreException(Activator.error(error, e));
        }
    }

    private ByteArrayInputStream asStream(String entry) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(entry.getBytes("UTF-8"));
    }

    private ISchedulingRule calcSchedulingRule() {
        return RuleUtil.getRuleForContainers(this.paths);
    }
}

