/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.remoteservice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.provider.generic.SSLClientSOContainer;
import org.eclipse.ecf.provider.generic.SSLServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPClientSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceContainerAdapterFactory;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceNamespace;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker logServiceTracker = null;
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.remoteservice";
    private static Activator plugin;
    private BundleContext context;
    private LogService logService;
    private List rscAdapterFactories;

    public Activator() {
        plugin = this;
    }

    private static IAdapterManager getAdapterManager(BundleContext ctx) {
        AdapterManagerTracker t = new AdapterManagerTracker(ctx);
        t.open();
        IAdapterManager am = t.getAdapterManager();
        t.close();
        return am;
    }

    public void start(final BundleContext ctxt) throws Exception {
        this.context = ctxt;
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(this.context){

            protected void runWithoutRegistry() throws Exception {
                ctxt.registerService(Namespace.class, (Object)new RemoteServiceNamespace("ecf.namespace.generic.remoteservice", "Generic remote service namespace"), null);
                IAdapterManager am = Activator.getAdapterManager(ctxt);
                if (am != null) {
                    Activator.this.rscAdapterFactories = new ArrayList();
                    RemoteServiceContainerAdapterFactory af = new RemoteServiceContainerAdapterFactory();
                    am.registerAdapters((IAdapterFactory)af, SSLServerSOContainer.class);
                    Activator.this.rscAdapterFactories.add(af);
                    af = new RemoteServiceContainerAdapterFactory();
                    am.registerAdapters((IAdapterFactory)af, TCPServerSOContainer.class);
                    Activator.this.rscAdapterFactories.add(af);
                    af = new RemoteServiceContainerAdapterFactory();
                    am.registerAdapters((IAdapterFactory)af, SSLClientSOContainer.class);
                    Activator.this.rscAdapterFactories.add(af);
                    af = new RemoteServiceContainerAdapterFactory();
                    am.registerAdapters((IAdapterFactory)af, TCPClientSOContainer.class);
                    Activator.this.rscAdapterFactories.add(af);
                }
            }
        });
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.rscAdapterFactories != null) {
            IAdapterManager am = Activator.getAdapterManager(this.context);
            if (am != null) {
                Iterator i = this.rscAdapterFactories.iterator();
                while (i.hasNext()) {
                    am.unregisterAdapters((IAdapterFactory)i.next());
                }
            }
            this.rscAdapterFactories = null;
        }
        this.context = null;
        plugin = null;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return this.context.createFilter(filter);
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        LogService ls = this.getLogService();
        if (ls != null) {
            ls.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }
}

