/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.impl;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.impl.Connection;
import org.eclipse.datatools.enablement.oda.xml.impl.ResultSetMetaData;
import org.eclipse.datatools.enablement.oda.xml.util.MappedTables;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.date.DateUtil;

public class ResultSet
implements IResultSet {
    private static final String FALSE_LITERAL = "false";
    private static final String TRUE_LITERAL = "true";
    private static final String SINGLE_SPACE = " ";
    private MappedTables mt;
    private int maxRows;
    private boolean wasNull;
    private boolean isClosed;
    private SaxParserConsumer spConsumer;
    private String tableName;
    private RelationInformation relationInfo;
    private Connection connection;
    private static ULocale JRE_DEFAULT_LOCALE = ULocale.getDefault();
    private int rowID;

    public ResultSet(Connection connection, MappedTables mt, String tableName, int maxRows) throws OdaException {
        this.mt = mt;
        this.maxRows = maxRows;
        this.relationInfo = new RelationInformation(mt, true);
        this.tableName = tableName;
        this.connection = connection;
        this.isClosed = false;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.testClosed();
        return new ResultSetMetaData(this.mt, this.tableName);
    }

    private void testClosed() throws OdaException {
        if (this.isClosed) {
            throw new OdaException(Messages.getString("ResultSet.ResultSetClosed"));
        }
    }

    public void close() throws OdaException {
        if (this.spConsumer != null) {
            this.spConsumer.close();
        }
        this.isClosed = true;
    }

    public void setMaxRows(int max) throws OdaException {
        this.testClosed();
        this.maxRows = max;
    }

    public boolean next() throws OdaException {
        boolean hasNext;
        this.testClosed();
        if (this.spConsumer == null) {
            this.spConsumer = new SaxParserConsumer(this.relationInfo, this.connection.getXMLSource(), this.tableName);
        }
        if (hasNext = this.spConsumer.next()) {
            ++this.rowID;
        }
        if (this.rowID > this.maxRows && this.maxRows != 0) {
            return false;
        }
        return hasNext;
    }

    public int getRow() throws OdaException {
        this.testClosed();
        return this.rowID;
    }

    public String getString(int index) throws OdaException {
        this.testClosed();
        String[] resultRow = this.spConsumer.getRowValue();
        String result = null;
        if (resultRow != null) {
            result = resultRow[index - 1];
        }
        this.wasNull = result == null;
        return result;
    }

    private int getColumnIndex(String columnName) throws OdaException {
        return this.mt.getColumnIndex(this.tableName, columnName);
    }

    public String getString(String name) throws OdaException {
        this.testClosed();
        return this.getString(this.getColumnIndex(name));
    }

    public int getInt(int index) throws OdaException {
        return this.stringToInt(this.getString(index));
    }

    public int getInt(String name) throws OdaException {
        return this.stringToInt(this.getString(name));
    }

    private int stringToInt(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new Integer(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse(stringValue);
                    if (number != null) {
                        return number.intValue();
                    }
                }
                catch (ParseException parseException) {}
            }
        }
        this.wasNull = true;
        return 0;
    }

    public double getDouble(int index) throws OdaException {
        return this.stringToDouble(this.getString(index));
    }

    public double getDouble(String name) throws OdaException {
        return this.stringToDouble(this.getString(name));
    }

    private double stringToDouble(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new Double(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse(stringValue);
                    if (number != null) {
                        return number.doubleValue();
                    }
                }
                catch (ParseException parseException) {}
            }
        }
        this.wasNull = true;
        return 0.0;
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        return this.stringToBigDecimal(this.getString(index));
    }

    public BigDecimal getBigDecimal(String name) throws OdaException {
        return this.stringToBigDecimal(this.getString(name));
    }

    private BigDecimal stringToBigDecimal(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new BigDecimal(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse(stringValue);
                    if (number != null) {
                        return new BigDecimal(number.toString());
                    }
                }
                catch (ParseException parseException) {}
            }
        }
        this.wasNull = true;
        return null;
    }

    public Date getDate(int index) throws OdaException {
        return this.stringToDate(this.getString(index));
    }

    public Date getDate(String columnName) throws OdaException {
        return this.stringToDate(this.getString(columnName));
    }

    private Date stringToDate(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return DateUtil.toSqlDate(stringValue);
            }
            catch (OdaException odaException) {
                this.wasNull = true;
                return null;
            }
        }
        return null;
    }

    public Time getTime(int index) throws OdaException {
        return this.stringToTime(this.getString(index));
    }

    public Time getTime(String columnName) throws OdaException {
        return this.stringToTime(this.getString(columnName));
    }

    private Time stringToTime(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return DateUtil.toSqlTime((Object)stringValue);
            }
            catch (OdaException odaException) {
                this.wasNull = true;
                return null;
            }
        }
        this.wasNull = true;
        return null;
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        return this.stringToTimestamp(this.getString(index));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.stringToTimestamp(this.getString(columnName));
    }

    private Timestamp stringToTimestamp(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                if (!stringValue.endsWith("Z")) {
                    stringValue = stringValue.replaceAll("\\QT\\E", SINGLE_SPACE).split("\\QZ\\E")[0];
                }
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    long timeMills = new Long(stringValue);
                    return new Timestamp(timeMills);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        java.util.Date date = DateUtil.toDate((Object)stringValue);
                        Timestamp timeStamp = new Timestamp(date.getTime());
                        return timeStamp;
                    }
                    catch (OdaException odaException) {
                        this.wasNull = true;
                        return null;
                    }
                }
            }
        }
        this.wasNull = true;
        return null;
    }

    public boolean wasNull() throws OdaException {
        this.testClosed();
        return this.wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        this.testClosed();
        return this.getColumnIndex(columnName);
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.stringToBoolean(this.getString(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        return this.stringToBoolean(this.getString(index));
    }

    private Boolean stringToBoolean(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            if (stringValue.equalsIgnoreCase(TRUE_LITERAL)) {
                return Boolean.TRUE;
            }
            if (stringValue.equalsIgnoreCase(FALSE_LITERAL)) {
                return Boolean.FALSE;
            }
            try {
                if (Integer.parseInt(stringValue) == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse(stringValue);
                    if (number != null) {
                        return number.intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
                catch (ParseException parseException) {}
            }
        }
        return Boolean.FALSE;
    }

    public Object getObject(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }
}

