/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.xlupc.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.managedbuilder.xlc.ui.wizards.XLCSettingsWizardRunnable;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.wizard.IWizardPage;

public class XLUpcSettingsWizardRunnable
extends XLCSettingsWizardRunnable {
    private static final String[] CONTENT_TYPE_IDS = new String[]{"org.eclipse.cdt.core.cHeader", "org.eclipse.cdt.core.cSource"};

    public XLUpcSettingsWizardRunnable() {
        this.pageId = "org.eclipse.cdt.managedbuilder.xlupc.ui.wizards.XLUpcSettingsWizardPage";
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        super.run(monitor);
        IWizardPage[] pages = MBSCustomPageManager.getPages();
        if (pages != null && pages.length > 0) {
            CDTCommonProjectWizard wizard = (CDTCommonProjectWizard)pages[0].getWizard();
            IProject project = wizard.getLastProject();
            LanguageManager langManager = LanguageManager.getInstance();
            try {
                ProjectLanguageConfiguration langConfig = langManager.getLanguageConfiguration(project);
                ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project, false);
                ICConfigurationDescription configDescription = projectDescription.getActiveConfiguration();
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                String[] stringArray = CONTENT_TYPE_IDS;
                int n = CONTENT_TYPE_IDS.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (contentTypeManager.getContentType(id) != null) {
                        langConfig.addContentTypeMapping(configDescription, id, "org.eclipse.cdt.core.parser.upc.upc");
                    }
                    ++n2;
                }
                langManager.storeLanguageMappingConfiguration(project, new IContentType[0]);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
    }
}

