/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors.xpath;

import java.util.ResourceBundle;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.providers.VariableTreeContentProvider;
import org.eclipse.bpel.ui.dialogs.ElementTreePreviewSelectionDialog;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class VariablePickerAction
extends TextEditorAction {
    private ResourceBundle fBundle;
    private String fPrefix;

    public VariablePickerAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.fBundle = bundle;
        this.fPrefix = prefix;
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        IDocumentProvider docProvider = editor.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        IDocument document = docProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return;
        }
        VariableTreeContentProvider variableContentProvider = new VariableTreeContentProvider(true, false, false);
        ElementTreePreviewSelectionDialog dialog = new ElementTreePreviewSelectionDialog(editor.getSite().getShell(), new ModelTreeLabelProvider(), variableContentProvider);
        String title = this.fBundle.getString(String.valueOf(this.fPrefix) + "dialog.title");
        dialog.setTitle(title);
        dialog.setAllowMultiple(false);
        EObject eObj = (EObject)input.getAdapter(EObject.class);
        dialog.setInput(eObj);
        if (dialog.open() == 0) {
            TextSelection sel = (TextSelection)editor.getSelectionProvider().getSelection();
            int offset = sel.getOffset();
            int length = sel.getLength();
            String result = dialog.getPreviewResult();
            try {
                document.replace(offset, length, result);
                editor.selectAndReveal(offset + result.length(), 0);
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

