/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dnd;

import java.util.HashMap;
import org.eclipse.bpel.ui.Templates;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DropPopup
extends PopupDialog
implements StatusTextListener,
MenuDetectListener,
KeyListener {
    CommandListener fTarget;
    protected HTMLTextPresenter fPresenter;
    protected TextPresentation fPresentation = new TextPresentation();
    protected StyledText fText;
    static Templates dropTemplates = new Templates();

    void setCommandListener(CommandListener listener) {
        this.fTarget = listener;
    }

    public DropPopup(Shell parentShell, int shellStyle, String title, String statusFieldText) {
        super(parentShell, shellStyle | 4, true, true, false, false, title, statusFieldText);
    }

    protected Control createDialogArea(Composite parent) {
        this.fText = new StyledText(parent, 768);
        this.fText.setEditable(false);
        this.fPresenter = new HTMLTextPresenter(false);
        this.fText.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DropPopup.this.fText.setText(DropPopup.this.fText.getText());
            }
        });
        return this.fText;
    }

    protected void setInput(String html) {
        Templates.Template template = this.getViewTemplate();
        Templates.TemplateResource resource = template.getResources().get(0);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("content", html);
        args.put("background-color", this.toCSS("background-color", this.getShell().getBackground()));
        args.put("font", this.toCSS(this.getShell().getFont()));
        this.fPresentation.clear();
        Rectangle size = this.fText.getClientArea();
        html = resource.process(args);
        System.out.println("Text: " + html);
        html = this.fPresenter.updatePresentation((Drawable)this.getShell(), html, this.fPresentation, size.width, size.height);
        this.fText.setText(html);
        TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
    }

    String toCSS(String name, Color color) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(": rgb(").append(color.getRed()).append(",");
        sb.append(color.getGreen()).append(",");
        sb.append(color.getBlue()).append(");");
        return sb.toString();
    }

    String toCSS(Font font) {
        FontData[] fd = font.getFontData();
        StringBuilder sb = new StringBuilder();
        if (fd.length < 1) {
            return sb.toString();
        }
        sb.append("font-size: ").append(fd[0].getHeight()).append("pt;");
        sb.append("font-family: ").append(fd[0].getName()).append(";");
        return sb.toString();
    }

    Templates.Template getViewTemplate() {
        Templates.Template t = dropTemplates.getTemplateByKey("dropPopupTemplate");
        dropTemplates.initializeFrom("/html/");
        t = dropTemplates.getTemplateByKey("dropPopupTemplate");
        return t;
    }

    public void changed(StatusTextEvent event) {
        String cmd = event.text;
        if (cmd == null || !cmd.startsWith("event://")) {
            return;
        }
        cmd = cmd.substring(8);
        if (this.fTarget != null) {
            this.fTarget.execute(cmd);
        }
        this.close();
    }

    public void menuDetected(MenuDetectEvent e) {
        e.doit = false;
    }

    public void keyPressed(KeyEvent e) {
        e.doit = false;
        this.close();
    }

    public void keyReleased(KeyEvent e) {
        e.doit = false;
    }

    static interface CommandListener {
        public void execute(String var1);
    }
}

