/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.fnmeta.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Optionality implements Enumerator
{
    REQUIRED(0, "Required", "!"),
    OPTIONAL(1, "Optional", "?"),
    OPTIONAL_MANY(2, "OptionalMany", "*");

    public static final int REQUIRED_VALUE = 0;
    public static final int OPTIONAL_VALUE = 1;
    public static final int OPTIONAL_MANY_VALUE = 2;
    private static final Optionality[] VALUES_ARRAY;
    public static final List<Optionality> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Optionality[]{REQUIRED, OPTIONAL, OPTIONAL_MANY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Optionality get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Optionality result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Optionality getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Optionality result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Optionality get(int value) {
        switch (value) {
            case 0: {
                return REQUIRED;
            }
            case 1: {
                return OPTIONAL;
            }
            case 2: {
                return OPTIONAL_MANY;
            }
        }
        return null;
    }

    private Optionality(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

