/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;

public class WidthResolver {
    private static final DimensionType PERCENTAGE_100 = new DimensionType(100.0, "%");
    private final int dpi;

    public WidthResolver(int dpi) {
        this.dpi = dpi;
    }

    private boolean isPercentage(DimensionType d) {
        return "%".equals(d.getUnits());
    }

    public DimensionValue resolveWidth(IContent content) {
        DimensionValue parentWidth;
        if (content instanceof ICellContent) {
            return this.resolveCellWidth((ICellContent)content);
        }
        DimensionType width = content.getWidth();
        if (width == null) {
            width = PERCENTAGE_100;
        }
        if (!this.isPercentage(width)) {
            return this.convert(width);
        }
        IContent parent = (IContent)content.getParent();
        if (parent == null) {
            parentWidth = this.getMasterPageWidth(content);
            if (parentWidth == null) {
                return null;
            }
        } else {
            parentWidth = this.resolveWidth(parent);
        }
        return new DimensionValue(parentWidth.getMeasure() * width.getMeasure() / 100.0, parentWidth.getUnits());
    }

    private DimensionValue getMasterPageWidth(IContent content) {
        if (content.getReportContent() == null || content.getReportContent().getDesign() == null || content.getReportContent().getDesign().getPageSetup() == null || content.getReportContent().getDesign().getPageSetup().getMasterPageCount() == 0) {
            return null;
        }
        MasterPageDesign page = content.getReportContent().getDesign().getPageSetup().getMasterPage(0);
        if (page == null) {
            return null;
        }
        if (page.getLeftMargin() == null || page.getRightMargin() == null) {
            return this.convert(page.getPageWidth());
        }
        DimensionValue margin = DimensionUtil.mergeDimension((DimensionValue)this.convert(page.getLeftMargin()), (DimensionValue)this.convert(page.getRightMargin()), (int)this.dpi);
        return DimensionUtil.mergeDimension((DimensionValue)this.convert(page.getPageWidth()), (DimensionValue)new DimensionValue(-margin.getMeasure(), margin.getUnits()), (int)this.dpi);
    }

    private DimensionValue resolveCellWidth(ICellContent cell) {
        ITableContent table = this.getTable(cell);
        DimensionValue tableWidth = null;
        int colId = cell.getColumn();
        int colSpan = cell.getColSpan();
        DimensionValue cellWidth = null;
        int i = 0;
        while (i < colSpan) {
            IColumn column = table.getColumn(colId + i);
            DimensionType colWidth = column.getWidth();
            if (this.isPercentage(colWidth)) {
                if (tableWidth == null) {
                    tableWidth = this.resolveWidth(table);
                }
                colWidth = new DimensionType(tableWidth.getMeasure() * colWidth.getMeasure() / 100.0, tableWidth.getUnits());
            }
            cellWidth = cellWidth == null ? this.convert(colWidth) : DimensionUtil.mergeDimension((DimensionValue)cellWidth, (DimensionValue)this.convert(colWidth), (int)this.dpi);
            ++i;
        }
        return cellWidth;
    }

    DimensionValue convert(DimensionType dim) {
        return new DimensionValue(dim.getMeasure(), dim.getUnits());
    }

    private ITableContent getTable(ICellContent cell) {
        IElement parent = cell.getParent();
        while (parent != null) {
            if (parent instanceof ITableContent) {
                return (ITableContent)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }
}

