/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;

public class DataContent
extends TextContent
implements IDataContent {
    protected Object value;
    protected String labelText;
    protected String labelKey;
    protected String helpKey;
    protected static final short FIELD_VALUE = 300;
    protected static final short FIELD_LAVELTEXT = 301;
    protected static final short FIELD_LABELKEY = 302;
    protected static final short FIELD_HELPKEY = 303;

    @Override
    public int getContentType() {
        return 3;
    }

    DataContent(ReportContent report) {
        super(report);
    }

    DataContent(IContent content) {
        super(content);
    }

    DataContent(IDataContent data) {
        super(data);
        this.value = data.getValue();
        this.labelText = data.getLabelText();
        this.labelKey = data.getLabelKey();
        this.helpKey = data.getHelpKey();
        this.helpText = data.getHelpText();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public String getLabelText() {
        return this.labelText;
    }

    @Override
    public void setLabelText(String text) {
        this.labelText = text;
    }

    @Override
    public String getLabelKey() {
        return this.labelKey;
    }

    @Override
    public void setLabelKey(String key) {
        this.labelKey = key;
    }

    @Override
    public String getHelpText() {
        if (this.helpText == null && this.generateBy instanceof DataItemDesign) {
            return ((DataItemDesign)this.generateBy).getHelpText();
        }
        return this.helpText;
    }

    @Override
    public String getHelpKey() {
        if (this.helpKey == null && this.generateBy instanceof DataItemDesign) {
            return ((DataItemDesign)this.generateBy).getHelpTextKey();
        }
        return this.helpKey;
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitData(this, value);
    }

    @Override
    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.value != null) {
            DataItemDesign design;
            boolean needSave = true;
            if (this.generateBy instanceof DataItemDesign && (design = (DataItemDesign)this.generateBy).getMap() == null) {
                needSave = false;
            }
            if (needSave) {
                IOUtil.writeShort((OutputStream)out, (short)300);
                IOUtil.writeObject((DataOutputStream)out, (Object)this.value);
            }
        }
        if (this.labelText != null) {
            IOUtil.writeShort((OutputStream)out, (short)301);
            IOUtil.writeString((DataOutputStream)out, (String)this.labelText);
        }
        if (this.labelKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)302);
            IOUtil.writeString((DataOutputStream)out, (String)this.labelKey);
        }
        if (this.helpKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)303);
            IOUtil.writeString((DataOutputStream)out, (String)this.helpKey);
        }
    }

    @Override
    public boolean needSave() {
        DataItemDesign design;
        MapDesign map;
        if (this.value != null && this.generateBy instanceof DataItemDesign && (map = (design = (DataItemDesign)this.generateBy).getMap()) != null && map.getRuleCount() != 0) {
            return true;
        }
        if (this.labelText != null || this.labelKey != null) {
            return true;
        }
        if (this.helpKey != null) {
            return true;
        }
        return super.needSave();
    }

    @Override
    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 300: {
                this.value = IOUtil.readObject((DataInputStream)in, (ClassLoader)loader);
                break;
            }
            case 301: {
                this.labelText = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 302: {
                this.labelKey = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 303: {
                this.helpKey = IOUtil.readString((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    @Override
    protected IContent cloneContent() {
        return new DataContent(this);
    }
}

