/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

public final class BoundingBox
implements Cloneable {
    private double dX;
    private double dY;
    private double dWidth;
    private double dHeight;
    private double dHotPoint;

    public BoundingBox(int _iLabelLocation, double _dX, double _dY, double _dWidth, double _dHeight, double _dHotPoint) {
        this.dX = _dX;
        this.dY = _dY;
        this.dWidth = _dWidth;
        this.dHeight = _dHeight;
        this.dHotPoint = _dHotPoint;
    }

    public BoundingBox clone() {
        return new BoundingBox(0, this.dX, this.dY, this.dWidth, this.dHeight, this.dHotPoint);
    }

    public final double getHotPoint() {
        return this.dHotPoint;
    }

    public final double getTop() {
        return this.dY;
    }

    public final double getLeft() {
        return this.dX;
    }

    public final double getWidth() {
        return this.dWidth;
    }

    public final double getHeight() {
        return this.dHeight;
    }

    public final void setLeft(double _dX) {
        this.dX = _dX;
    }

    public final void setTop(double _dY) {
        this.dY = _dY;
    }

    public final void scale(double dScale) {
        this.dX *= dScale;
        this.dY *= dScale;
        this.dWidth *= dScale;
        this.dHeight *= dScale;
        this.dHotPoint *= dScale;
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.dHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.dHotPoint);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.dWidth);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.dX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.dY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (Double.doubleToLongBits(this.dHeight) != Double.doubleToLongBits(other.dHeight)) {
            return false;
        }
        if (Double.doubleToLongBits(this.dHotPoint) != Double.doubleToLongBits(other.dHotPoint)) {
            return false;
        }
        if (Double.doubleToLongBits(this.dWidth) != Double.doubleToLongBits(other.dWidth)) {
            return false;
        }
        if (Double.doubleToLongBits(this.dX) != Double.doubleToLongBits(other.dX)) {
            return false;
        }
        return Double.doubleToLongBits(this.dY) == Double.doubleToLongBits(other.dY);
    }
}

