/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.command;

import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.coordinate.RowPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;

public abstract class AbstractRowCommand
implements ILayerCommand {
    private RowPositionCoordinate rowPositionCoordinate;

    protected AbstractRowCommand(ILayer layer, int rowPosition) {
        this.rowPositionCoordinate = new RowPositionCoordinate(layer, rowPosition);
    }

    protected AbstractRowCommand(AbstractRowCommand command) {
        this.rowPositionCoordinate = command.rowPositionCoordinate;
    }

    public boolean convertToTargetLayer(ILayer targetLayer) {
        this.rowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.rowPositionCoordinate, targetLayer);
        return this.rowPositionCoordinate != null;
    }

    public int getRowPosition() {
        return this.rowPositionCoordinate.getRowPosition();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " rowPosition=" + this.rowPositionCoordinate.getRowPosition();
    }
}

