/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.framework;

import java.util.logging.Level;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Logger {
    private ILog eclipseLog;
    private String pluginId;
    private java.util.logging.Logger backupLog;
    private StringBuilder prefix = new StringBuilder();
    private boolean debug;

    public Logger(String pluginId) {
        this.backupLog = java.util.logging.Logger.getLogger(pluginId);
    }

    Logger(ILog log, String pluginId) {
        this.eclipseLog = log;
        this.pluginId = pluginId;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void addPrefix(char c) {
        if (this.debug) {
            this.prefix.append(c);
        }
    }

    public void removePrefix(char c) {
        if (this.debug) {
            int length = this.prefix.length();
            char old = this.prefix.charAt(length - 1);
            if (old != c) {
                throw new IllegalStateException("Old prefix (" + old + ") does not match that expected (" + c + "), whole prefix is \"" + this.prefix + "\"");
            }
            this.prefix.setLength(length - 1);
        }
    }

    public void debug(Object ... message) {
        if (this.eclipseLog != null) {
            if (this.debug) {
                if (message.length > 1) {
                    StringBuilder msg = new StringBuilder();
                    Object[] objectArray = message;
                    int n = message.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object part = objectArray[n2];
                        msg.append(part);
                        ++n2;
                    }
                    System.out.println(String.valueOf(this.prefix.toString()) + " " + msg.toString());
                } else {
                    System.out.println(String.valueOf(this.prefix.toString()) + " " + message[0].toString());
                }
            }
        } else if (this.backupLog.isLoggable(Level.FINE)) {
            if (message.length > 1) {
                StringBuilder msg = new StringBuilder();
                msg.append((CharSequence)this.prefix).append(' ');
                Object[] objectArray = message;
                int n = message.length;
                int n3 = 0;
                while (n3 < n) {
                    Object part = objectArray[n3];
                    msg.append(part);
                    ++n3;
                }
                this.backupLog.fine(msg.toString());
            } else {
                this.backupLog.fine(String.valueOf(this.prefix.toString()) + " " + message[0].toString());
            }
        }
    }

    public void info(int code, String message, Throwable exception) {
        if (this.eclipseLog != null) {
            this.log(1, code, message, exception);
        } else {
            this.backupLog.log(Level.INFO, message, exception);
        }
    }

    public void warn(int code, String message, Throwable exception) {
        if (this.eclipseLog != null) {
            this.log(2, code, message, exception);
        } else {
            this.backupLog.log(Level.WARNING, message, exception);
        }
    }

    public void error(int code, String message, Throwable exception) {
        if (this.eclipseLog != null) {
            this.log(4, code, message, exception);
        } else {
            this.backupLog.log(Level.SEVERE, message, exception);
        }
    }

    private void log(int severity, int code, String message, Throwable exception) {
        if (this.eclipseLog != null) {
            Status record = new Status(severity, this.pluginId, code, message, exception);
            this.eclipseLog.log((IStatus)record);
        }
    }
}

