/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.pde.ReflectivePDE;
import org.eclipse.wb.internal.core.utils.reflect.AbstractMethodsImplementorVisitor;
import org.eclipse.wb.internal.core.utils.reflect.IByteCodeProcessor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectClassLoader
extends URLClassLoader {
    private final List<IByteCodeProcessor> m_processors = Lists.newArrayList();
    private final Set<String> m_nonAbstractClasses = Sets.newTreeSet();
    private final IJavaProject m_javaProject;
    private static CodeSource m_fakeCodeSource;

    public static ProjectClassLoader create(ClassLoader parentClassLoader, IJavaProject javaProject) throws Exception {
        URL[] urls = ProjectClassLoader.getClasspathUrls(javaProject);
        return new ProjectClassLoader(urls, parentClassLoader, javaProject);
    }

    public static URL[] getClasspathUrls(IJavaProject javaProject) throws Exception {
        ArrayList entries = Lists.newArrayList();
        ProjectClassLoader.addRuntimeClassPathEntries(entries, javaProject, Sets.newHashSet(), true);
        return ProjectClassLoader.toURLs(entries);
    }

    public static URL[] toURLs(List<String> locations) throws Exception {
        URL[] urls = new URL[locations.size()];
        int i = 0;
        while (i < locations.size()) {
            String location = locations.get(i);
            urls[i] = new File(location).toURI().toURL();
            ++i;
        }
        return urls;
    }

    public static ProjectClassLoader create(ClassLoader parentClassLoader, URL[] urls, IJavaProject javaProject) throws Exception {
        return new ProjectClassLoader(urls, parentClassLoader, javaProject);
    }

    private static void addRuntimeClassPathEntries(List<String> entries, IJavaProject javaProject, Set<IJavaProject> visitedProjects, boolean fullClassPath) throws Exception {
        IProject project = javaProject.getProject();
        if (!javaProject.exists()) {
            if (project.exists()) {
                String path = project.getLocation().toPortableString();
                entries.add(path);
            }
            return;
        }
        if (visitedProjects.contains(javaProject)) {
            return;
        }
        visitedProjects.add(javaProject);
        if (fullClassPath) {
            CollectionUtils.addAll(entries, (Object[])ProjectClassLoader.getClasspath(javaProject));
        } else {
            IPath outputLocation = javaProject.getOutputLocation();
            ProjectClassLoader.addAbsoluteLocation(entries, outputLocation);
        }
        ProjectClassLoader.addFragments(entries, project, visitedProjects);
    }

    private static void addFragments(List<String> entries, IProject project, Set<IJavaProject> visitedProjects) throws Exception {
        String[] requiredProjectNames;
        BundleDescription modelBundleDescription;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!javaProject.exists()) {
            return;
        }
        Object model = ReflectivePDE.findModel(project);
        if (model != null && (modelBundleDescription = ReflectivePDE.getPluginModelBundleDescription(model)) != null) {
            BundleDescription[] fragments;
            BundleDescription[] bundleDescriptionArray = fragments = modelBundleDescription.getFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription fragment = bundleDescriptionArray[n2];
                String fragmentProjectName = fragment.getSymbolicName();
                ProjectClassLoader.addFragment_runtimeClassPathEntries(entries, fragmentProjectName, visitedProjects);
                ++n2;
            }
        }
        String[] stringArray = requiredProjectNames = javaProject.getRequiredProjectNames();
        int n = requiredProjectNames.length;
        int n3 = 0;
        while (n3 < n) {
            String requiredProjectName = stringArray[n3];
            ProjectClassLoader.addFragment_runtimeClassPathEntries(entries, requiredProjectName, visitedProjects);
            ++n3;
        }
    }

    private static void addFragment_runtimeClassPathEntries(List<String> entries, String projectName, Set<IJavaProject> visitedProjects) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ProjectClassLoader.addRuntimeClassPathEntries(entries, javaProject, visitedProjects, false);
    }

    public static String[] getClasspath(IJavaProject javaProject) throws Exception {
        ArrayList locations = Lists.newArrayList();
        IRuntimeClasspathEntry[] unresolvedEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
        int unresolvedIndex = 0;
        while (unresolvedIndex < unresolvedEntries.length) {
            IRuntimeClasspathEntry enresolvedEntry = unresolvedEntries[unresolvedIndex];
            IRuntimeClasspathEntry[] resolvedEntries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)enresolvedEntry, (IJavaProject)javaProject);
            int resolvedIndex = 0;
            while (resolvedIndex < resolvedEntries.length) {
                IRuntimeClasspathEntry resolvedEntry = resolvedEntries[resolvedIndex];
                String location = resolvedEntry.getLocation();
                if (location != null) {
                    location = location.replace('\\', '/');
                    locations.add(location);
                }
                ++resolvedIndex;
            }
            ++unresolvedIndex;
        }
        return locations.toArray(new String[locations.size()]);
    }

    public static void addOutputLocations(Set<IProject> visitedProjects, List<String> locations, IProject project) throws Exception {
        IProject[] referencedProjects;
        int n;
        int n2;
        IProject[] iProjectArray;
        if (!project.exists()) {
            return;
        }
        if (visitedProjects.contains(project)) {
            return;
        }
        visitedProjects.add(project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            IPath outputPath = javaProject.getOutputLocation();
            ProjectClassLoader.addAbsoluteLocation(locations, outputPath);
            iProjectArray = javaProject.getResolvedClasspath(true);
            n2 = iProjectArray.length;
            n = 0;
            while (n < n2) {
                IProject entry = iProjectArray[n];
                if (entry.getEntryKind() == 3) {
                    IPath outputPath2 = entry.getOutputLocation();
                    ProjectClassLoader.addAbsoluteLocation(locations, outputPath2);
                }
                ++n;
            }
        }
        iProjectArray = referencedProjects = project.getReferencedProjects();
        n2 = referencedProjects.length;
        n = 0;
        while (n < n2) {
            IProject referencedProject = iProjectArray[n];
            ProjectClassLoader.addOutputLocations(visitedProjects, locations, referencedProject);
            ++n;
        }
    }

    public static void addSourceLocations(Set<IProject> visitedProjects, List<String> locations, IProject project) throws Exception {
        int n;
        int n2;
        IClasspathEntry[] iClasspathEntryArray;
        if (!project.exists()) {
            return;
        }
        if (visitedProjects.contains(project)) {
            return;
        }
        visitedProjects.add(project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            n2 = iClasspathEntryArray.length;
            n = 0;
            while (n < n2) {
                IClasspathEntry entry = iClasspathEntryArray[n];
                if (entry.getEntryKind() == 3) {
                    IPath entryPath = entry.getPath();
                    ProjectClassLoader.addAbsoluteLocation(locations, entryPath);
                }
                ++n;
            }
        }
        IProject[] referencedProjects = project.getReferencedProjects();
        iClasspathEntryArray = referencedProjects;
        n2 = referencedProjects.length;
        n = 0;
        while (n < n2) {
            IClasspathEntry referencedProject = iClasspathEntryArray[n];
            ProjectClassLoader.addSourceLocations(visitedProjects, locations, (IProject)referencedProject);
            ++n;
        }
    }

    private static void addAbsoluteLocation(List<String> locations, IPath outputPath) {
        if (outputPath != null) {
            IPath entryLocation;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (outputPath.segmentCount() == 1) {
                String projectName = outputPath.lastSegment();
                IProject project = workspaceRoot.getProject(projectName);
                entryLocation = project.getLocation();
            } else {
                IFolder entryFolder = workspaceRoot.getFolder(outputPath);
                entryLocation = entryFolder.getLocation();
            }
            locations.add(entryLocation.toPortableString());
        }
    }

    private static void cleanUpJIDE() {
        UIDefaults defaults = UIManager.getDefaults();
        Iterator I = defaults.keySet().iterator();
        while (I.hasNext()) {
            Object key = I.next();
            if (key.toString().toLowerCase().indexOf("jide") == -1) continue;
            I.remove();
        }
    }

    public ProjectClassLoader(URL[] urls, ClassLoader parent, IJavaProject javaProject) {
        super(urls, parent);
        this.m_javaProject = javaProject;
        ProjectClassLoader.cleanUpJIDE();
    }

    public void add(IByteCodeProcessor processor) {
        this.m_processors.add(processor);
        processor.initialize(this);
    }

    public void addNonAbstractClass(String className) {
        this.m_nonAbstractClasses.add(className);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        String classResourceName = String.valueOf(className.replace('.', '/')) + ".class";
        InputStream input = this.getResourceAsStream(classResourceName);
        if (input == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            String pkgName;
            byte[] bytes = IOUtils2.readBytes((InputStream)input);
            for (IByteCodeProcessor processor : this.m_processors) {
                bytes = processor.process(className, bytes);
            }
            if (this.m_nonAbstractClasses.contains(className)) {
                ClassReader classReader = new ClassReader(bytes);
                AbstractMethodsImplementorVisitor rewriter = new AbstractMethodsImplementorVisitor(className);
                classReader.accept((ClassVisitor)rewriter, 0);
                bytes = rewriter.toByteArray();
            }
            if (this.getPackage(pkgName = StringUtils.substringBeforeLast((String)className, (String)".")) == null) {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            ProjectClassLoader.ensureCodeSource();
            return this.defineClass(className, bytes, 0, bytes.length, m_fakeCodeSource);
        }
        catch (Throwable e) {
            throw new ClassNotFoundException("Error loading class " + className, e);
        }
    }

    private static void ensureCodeSource() {
        if (m_fakeCodeSource == null) {
            try {
                m_fakeCodeSource = new CodeSource(new URL("file:/"), null);
            }
            catch (Throwable throwable) {}
        }
    }
}

