/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.callstack;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.LttngUst20EventLayout;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.callstack.CallStackStateProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;

@NonNullByDefault
public class LttngUstCallStackProvider
extends CallStackStateProvider {
    private static final int VERSION = 3;
    private final Set<String> funcEntryEvents;
    private final Set<String> funcExitEvents;
    private final ILttngUstEventLayout fLayout;

    public LttngUstCallStackProvider(ITmfTrace trace) {
        super(trace);
        this.fLayout = trace instanceof LttngUstTrace ? ((LttngUstTrace)trace).getEventLayout() : LttngUst20EventLayout.getInstance();
        this.funcEntryEvents = ImmutableSet.of((Object)this.fLayout.eventCygProfileFuncEntry(), (Object)this.fLayout.eventCygProfileFastFuncEntry());
        this.funcExitEvents = ImmutableSet.of((Object)this.fLayout.eventCygProfileFuncExit(), (Object)this.fLayout.eventCygProfileFastFuncExit());
    }

    public LttngUstCallStackProvider getNewInstance() {
        return new LttngUstCallStackProvider(this.getTrace());
    }

    public int getVersion() {
        return 3;
    }

    protected boolean considerEvent(ITmfEvent event) {
        if (!(event instanceof CtfTmfEvent)) {
            return false;
        }
        Object tid = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        return tid instanceof Integer;
    }

    public @Nullable ITmfStateValue functionEntry(ITmfEvent event) {
        String eventName = event.getName();
        if (!this.funcEntryEvents.contains(eventName)) {
            return null;
        }
        Long address = (Long)event.getContent().getField(new String[]{this.fLayout.fieldAddr()}).getValue();
        return TmfStateValue.newValueLong((long)address);
    }

    public @Nullable ITmfStateValue functionExit(ITmfEvent event) {
        String eventName = event.getName();
        if (!this.funcExitEvents.contains(eventName)) {
            return null;
        }
        ITmfEventField field = event.getContent().getField(new String[]{this.fLayout.fieldAddr()});
        if (field == null) {
            return TmfStateValue.nullValue();
        }
        Long address = (Long)field.getValue();
        return TmfStateValue.newValueLong((long)address);
    }

    protected int getProcessId(@NonNull ITmfEvent event) {
        ITmfEventField content = event.getContent();
        ITmfEventField vpidContextField = content.getField(new String[]{this.fLayout.contextVpid()});
        if (vpidContextField == null) {
            return -1;
        }
        return ((Long)vpidContextField.getValue()).intValue();
    }

    protected long getThreadId(ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return -1L;
        }
        return tid.longValue();
    }

    public @Nullable String getThreadName(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        ITmfEventField field = content.getField(new String[]{this.fLayout.contextProcname()});
        String procName = field == null ? "" : String.valueOf(String.valueOf(field.getValue())) + '-';
        long vtid = this.getThreadId(event);
        return String.valueOf(procName) + Long.toString(vtid);
    }
}

