/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant;

import java.util.HashSet;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant.VariantBodyParser;

public final class VariantParser
extends AbstractScopedCommonTreeParser {
    public static final VariantParser INSTANCE = new VariantParser();

    private VariantParser() {
    }

    @Override
    public VariantDeclaration parse(CommonTree variant, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        List children = variant.getChildren();
        VariantDeclaration variantDeclaration = null;
        boolean hasName = false;
        String variantName = null;
        boolean hasBody = false;
        CommonTree variantBody = null;
        boolean hasTag = false;
        String variantTag = null;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 125: {
                    hasName = true;
                    CommonTree variantNameIdentifier = (CommonTree)child.getChild(0);
                    variantName = variantNameIdentifier.getText();
                    break;
                }
                case 126: {
                    hasTag = true;
                    CommonTree variantTagIdentifier = (CommonTree)child.getChild(0);
                    variantTag = variantTagIdentifier.getText();
                    break;
                }
                case 124: {
                    hasBody = true;
                    variantBody = child;
                    break;
                }
                default: {
                    throw TsdlUtils.childTypeError(child);
                }
            }
        }
        if (hasBody) {
            if (hasName && scope.lookupVariant(variantName) != null) {
                throw new ParseException("variant " + variantName + " already defined.");
            }
            variantDeclaration = new VariantDeclaration();
            CTFTrace trace = ((Param)param).fTrace;
            VariantBodyParser.INSTANCE.parse(variantBody, new VariantBodyParser.Param(variantDeclaration, trace, variantName, scope));
            if (hasName) {
                scope.registerVariant(variantName, variantDeclaration);
            }
        } else if (hasName) {
            variantDeclaration = scope.lookupVariantRecursive(variantName);
            if (variantDeclaration == null) {
                throw new ParseException("variant " + variantName + " is not defined");
            }
        } else {
            throw new ParseException("variant with no name and no body");
        }
        if (hasTag) {
            variantDeclaration.setTag(variantTag);
            IDeclaration decl = scope.lookupIdentifierRecursive(variantTag);
            if (decl == null) {
                throw new ParseException("Variant tag not found: " + variantTag);
            }
            if (!(decl instanceof EnumDeclaration)) {
                throw new ParseException("Variant tag must be an enum: " + variantTag);
            }
            EnumDeclaration tagDecl = (EnumDeclaration)decl;
            HashSet<String> intersection = new HashSet<String>(tagDecl.getLabels());
            intersection.retainAll(variantDeclaration.getFields().keySet());
            if (intersection.isEmpty()) {
                throw new ParseException("Variant contains no values of the tag, impossible to use: " + variantName);
            }
        }
        return variantDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

