/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.variant.ResourceVariant;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNParticipant;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class SynchronizeLabelDecorator
extends LabelProvider
implements ILabelDecorator {
    public static final int CONFLICTING_REPLACEMENT_MASK = 15;
    public static final int REPLACEMENT_MASK = 3;
    protected Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
    protected ISynchronizePageConfiguration configuration;

    public SynchronizeLabelDecorator(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
    }

    public Image decorateImage(Image image, Object element) {
        AbstractSVNSyncInfo info = this.getSyncInfo(element);
        if (info != null) {
            ILocalResource left = info.getLocalResource();
            ILocalResource right = info.getRemoteChangeResource();
            OverlayedImageDescriptor imgDescr = null;
            if (IStateFilter.SF_OBSTRUCTED.accept(left)) {
                imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_OBSTRUCTED, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
            } else if ((info.getKind() & 0xF) == 15) {
                if (IStateFilter.SF_PREREPLACEDREPLACED.accept(left) || IStateFilter.SF_PREREPLACEDREPLACED.accept(right)) {
                    imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_REPLACED_CONF, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                }
            } else if ((info.getKind() & 3) == 3) {
                if (IStateFilter.SF_PREREPLACEDREPLACED.accept(left)) {
                    imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_REPLACED_OUT, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                } else if (IStateFilter.SF_PREREPLACEDREPLACED.accept(right)) {
                    imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_REPLACED_IN, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                }
            }
            Image tmp = this.registerImageDescriptor(imgDescr);
            if (!(left.getResource() instanceof IContainer) && (IStateFilter.SF_HAS_PROPERTIES_CHANGES.accept(left) || IStateFilter.SF_HAS_PROPERTIES_CHANGES.accept(right))) {
                if (tmp != null) {
                    image = tmp;
                }
                imgDescr = new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_PROPCHANGE, new Point(23, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.BOTTOM);
                return this.registerImageDescriptor(imgDescr);
            }
            return tmp;
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        AbstractSVNSyncInfo info = this.getSyncInfo(element);
        if (info != null) {
            ResourceVariant variant = (ResourceVariant)info.getRemote();
            if (variant != null) {
                ILocalResource remote = variant.getResource();
                if (remote.getRevision() != -1L) {
                    return String.valueOf(text) + " " + variant.getContentIdentifier();
                }
            } else {
                ILocalResource incoming = info.getRemoteChangeResource();
                if (incoming instanceof IResourceChange && IStateFilter.SF_DELETED.accept(incoming)) {
                    String result = text;
                    result = String.valueOf(result) + " " + String.valueOf(incoming.getRevision());
                    if (incoming.getAuthor() != null) {
                        result = String.valueOf(result) + " " + BaseMessages.format((String)SVNMessages.SVNInfo_Author, (Object[])new Object[]{incoming.getAuthor()});
                    }
                    return result;
                }
            }
        }
        return null;
    }

    protected Image registerImageDescriptor(OverlayedImageDescriptor imgDescr) {
        if (imgDescr != null) {
            Image img = this.images.get((Object)imgDescr);
            if (img == null) {
                img = imgDescr.createImage();
                this.images.put((ImageDescriptor)imgDescr, img);
            }
            return img;
        }
        return null;
    }

    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
    }

    protected AbstractSVNSyncInfo getSyncInfo(Object element) {
        ModelSynchronizeParticipant msp;
        ISynchronizationContext context;
        ISynchronizeParticipant participant;
        if (element instanceof SyncInfoModelElement) {
            return (AbstractSVNSyncInfo)((SyncInfoModelElement)element).getSyncInfo();
        }
        IResource resource = this.getResource(element);
        if (resource != null && (participant = this.configuration.getParticipant()) instanceof ModelSynchronizeParticipant && (context = (msp = (ModelSynchronizeParticipant)participant).getContext()) instanceof SubscriberMergeContext) {
            SubscriberMergeContext smc = (SubscriberMergeContext)context;
            Subscriber subscriber = smc.getSubscriber();
            try {
                AbstractSVNSyncInfo syncInfo = (AbstractSVNSyncInfo)subscriber.getSyncInfo(resource);
                return syncInfo != null && SyncInfo.isInSync((int)syncInfo.getKind()) ? null : syncInfo;
            }
            catch (TeamException e) {
                LoggedOperation.reportError((String)SynchronizeLabelDecorator.class.getName(), (Throwable)e);
            }
        }
        return null;
    }

    protected IResource getResource(Object element) {
        if (element instanceof ISynchronizeModelElement) {
            return ((ISynchronizeModelElement)element).getResource();
        }
        return Utils.getResource((Object)this.internalGetElement(element));
    }

    protected Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }
}

