/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;

public class SVNRevisionGraphPreferences {
    public static final String CACHE_BASE = "preference.cache.";
    public static final String GRAPH_BASE = "preference.graph.";
    public static final String CACHE_DIRECTORY_NAME = "directory";
    public static final String GRAPH_SKIP_ERRORS = "skip.errors";
    public static final String GRAPH_SHOW_MERGE_INFO = "show.merge.info";
    public static final boolean GRAPH_SHOW_MERGE_INFO_DEFAULT = true;
    public static final String GRAPH_SHOW_ALL_REVISIONS = "show.all.revisions";
    public static final boolean GRAPH_SHOW_ALL_REVISIONS_DEFAULT = false;
    public static final boolean GRAPH_SKIP_ERRORS_DEFAULT = true;

    private SVNRevisionGraphPreferences() {
    }

    public static void setDefaultValues(IPreferenceStore store) {
        store.setDefault(SVNRevisionGraphPreferences.fullCacheName(CACHE_DIRECTORY_NAME), SVNRevisionGraphPlugin.instance().getStateLocation().toString());
        store.setDefault(SVNRevisionGraphPreferences.fullGraphName(GRAPH_SKIP_ERRORS), true);
        store.setDefault(SVNRevisionGraphPreferences.fullGraphName(GRAPH_SHOW_MERGE_INFO), true);
        store.setDefault(SVNRevisionGraphPreferences.fullGraphName(GRAPH_SHOW_ALL_REVISIONS), false);
    }

    public static String getDefaultCacheString(IPreferenceStore store, String shortName) {
        return store.getDefaultString(SVNRevisionGraphPreferences.fullCacheName(shortName));
    }

    public static String getCacheString(IPreferenceStore store, String shortName) {
        return store.getString(SVNRevisionGraphPreferences.fullCacheName(shortName));
    }

    public static void setCacheString(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNRevisionGraphPreferences.fullCacheName(shortName), value);
    }

    public static boolean getGraphBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNRevisionGraphPreferences.fullGraphName(shortName));
    }

    public static void setGraphBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNRevisionGraphPreferences.fullGraphName(shortName), value);
    }

    public static String fullCacheName(String shortName) {
        return CACHE_BASE + shortName;
    }

    public static String fullGraphName(String shortName) {
        return GRAPH_BASE + shortName;
    }
}

