/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.ExportOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.ui.IWorkbenchPart;

public class ExportAction
extends BaseRevisionGraphAction {
    public static final String ExportAction_ID = "Export";

    public ExportAction(IWorkbenchPart part) {
        super(part);
        this.setText(SVNUIMessages.ExportCommand_label);
        this.setId(ExportAction_ID);
        this.setToolTipText(SVNUIMessages.ExportCommand_label);
        this.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/export.gif"));
    }

    protected boolean calculateEnabled() {
        return this.isEnable(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER, 1);
    }

    public void run() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getWorkbenchPart().getSite().getShell());
        fileDialog.setText(SVNUIMessages.ExportPanel_ExportFolder);
        fileDialog.setMessage(SVNUIMessages.ExportPanel_ExportFolder_Msg);
        String path = fileDialog.open();
        if (path != null) {
            IRepositoryResource resource = BaseRevisionGraphAction.convertToResource(this.getSelectedEditPart());
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean((IPreferenceStore)SVNTeamUIPlugin.instance().getPreferenceStore(), (String)"externals.ignore");
            ExportOperation op = new ExportOperation(new IRepositoryResource[]{resource}, path, SVNDepth.INFINITY, ignoreExternals);
            this.runOperation((IActionOperation)op);
        }
    }
}

