/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class CreatePatchOperation
extends AbstractActionOperation {
    public static final int SELECTION = 0;
    public static final int PROJECT = 1;
    public static final int WORKSPACE = 2;
    protected IResource[] resources;
    protected IResource[] selection;
    protected String fileName;
    protected boolean recurse;
    protected boolean processUnversioned;
    protected long options;
    protected long diffOptions;
    protected int rootPoint;
    protected String lineFeed = System.getProperty("line.separator");
    protected String contentSeparatorLine = "===================================================================";
    protected String contentSeparator = String.valueOf(this.lineFeed) + this.contentSeparatorLine + this.lineFeed;
    protected String indexEntry = "Index: ";
    protected String removeSign = "--- ";
    protected String addSign = "+++ ";
    protected String revisionMark = "\t(revision 0)" + this.lineFeed;
    protected String noLF = String.valueOf(this.lineFeed) + "\\ No newline at end of file" + this.lineFeed;
    protected String rangeStart = "@@ -0,0 +1";
    protected String rangeEnd = " @@" + this.lineFeed;

    public CreatePatchOperation(IResource[] resources, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean processUnversioned) {
        this(resources, fileName, recurse, ignoreDeleted, processBinary, processUnversioned, 1);
    }

    public CreatePatchOperation(IResource[] resources, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean processUnversioned, int rootPoint) {
        this(resources, fileName, recurse, processUnversioned, 0x200L | (ignoreDeleted ? 8192L : 0L) | (processBinary ? 4L : 0L), rootPoint, 0L);
    }

    public CreatePatchOperation(IResource[] resources, String fileName, boolean recurse, boolean processUnversioned, long options, int rootPoint, long diffOptions) {
        super("Operation_CreatePatchLocal", SVNMessages.class);
        this.resources = resources;
        this.fileName = fileName;
        this.recurse = recurse;
        this.processUnversioned = processUnversioned;
        this.options = options & 0xFFFFFFFFC0002204L;
        this.rootPoint = rootPoint;
        this.diffOptions = diffOptions;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        HashMap<IProject, ArrayList<IResource>> workingCopies = new HashMap<IProject, ArrayList<IResource>>();
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            ArrayList<IResource> list = (ArrayList<IResource>)workingCopies.get(res.getProject());
            if (list == null) {
                list = new ArrayList<IResource>();
                workingCopies.put(res.getProject(), list);
            }
            list.add(res);
            ++n2;
        }
        final FileOutputStream stream = new FileOutputStream(this.fileName);
        try {
            if (workingCopies.size() > 1 || this.rootPoint == 2) {
                this.rootPoint = 2;
                stream.write("### Eclipse Workspace Patch 1.0".getBytes());
                stream.write(this.lineFeed.getBytes());
            } else if (this.rootPoint == 0) {
                this.selection = FileUtility.shrinkChildNodes(this.resources);
            }
            Iterator it = workingCopies.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IProject project = (IProject)entry.getKey();
                if (this.rootPoint == 2) {
                    stream.write("#P ".getBytes());
                    stream.write(project.getName().getBytes());
                    stream.write(this.lineFeed.getBytes());
                }
                IResource[] resources = ((List)entry.getValue()).toArray(new IResource[0]);
                FileUtility.reorder(resources, true);
                int i = 0;
                while (i < resources.length && !monitor.isCanceled()) {
                    if (resources[i] instanceof IFile) {
                        this.addFileDiff(stream, (IFile)resources[i], monitor);
                    } else if (this.recurse) {
                        FileUtility.visitNodes(resources[i], new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (monitor.isCanceled() || FileUtility.isNotSupervised(resource)) {
                                    return false;
                                }
                                if (resource instanceof IFile) {
                                    CreatePatchOperation.this.addFileDiff(stream, (IFile)resource, monitor);
                                }
                                return true;
                            }
                        }, 2, true, true);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {}
    }

    protected void addFileDiff(OutputStream stream, IFile resource, IProgressMonitor monitor) {
        block24: {
            try {
                ILocalResource local;
                String charset = null;
                if (resource instanceof IEncodedStorage) {
                    charset = resource.getCharset();
                }
                String wcPath = FileUtility.getWorkingCopyPath((IResource)resource);
                String projectPath = FileUtility.getWorkingCopyPath((IResource)resource.getProject());
                String fileName = wcPath.substring(projectPath.length() + 1);
                if (this.rootPoint == 0) {
                    IPath resourcePath = resource.getFullPath();
                    int i = 0;
                    while (i < this.selection.length) {
                        IPath selectionPath = this.selection[i].getFullPath();
                        if (selectionPath.isPrefixOf(resourcePath)) {
                            fileName = this.selection[i].getType() == 1 ? (fileName = resource.getName()) : resourcePath.toString().substring(selectionPath.toString().length() + 1);
                            break;
                        }
                        ++i;
                    }
                }
                if (IStateFilter.SF_VERSIONED.accept(local = SVNRemoteStorage.instance().asLocalResourceAccessible((IResource)resource))) {
                    File tmp = SVNTeamPlugin.instance().getTemporaryFile(null, "patch.tmp");
                    IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation((IResource)resource);
                    ISVNConnector proxy = location.acquireSVNProxy();
                    try {
                        proxy.diffTwo(new SVNEntryRevisionReference(wcPath, null, SVNRevision.BASE), new SVNEntryRevisionReference(wcPath, null, SVNRevision.WORKING), projectPath, tmp.getAbsolutePath(), SVNDepth.EMPTY, this.options, null, this.diffOptions, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
                        int len = (int)tmp.length();
                        if (len <= 0) break block24;
                        byte[] data = new byte[len];
                        FileInputStream input = new FileInputStream(tmp);
                        try {
                            ((InputStream)input).read(data);
                        }
                        catch (Throwable throwable) {
                            try {
                                ((InputStream)input).close();
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Exception exception) {}
                        int idx = CreatePatchOperation.findOffset(data, this.contentSeparatorLine.getBytes(), 0);
                        if (idx != -1) {
                            byte[] rs = this.removeSign.getBytes();
                            byte[] as = this.addSign.getBytes();
                            byte[] fn = fileName.getBytes();
                            stream.write(this.indexEntry.getBytes());
                            stream.write(fn);
                            stream.write(this.lineFeed.getBytes());
                            int idx0 = CreatePatchOperation.findOffset(data, rs, idx);
                            int idx1 = CreatePatchOperation.findOffset(data, "\t(".getBytes(), idx0);
                            if (idx0 != -1 && idx1 != -1) {
                                stream.write(data, idx, idx0 - idx + rs.length);
                                stream.write(fn);
                                idx = idx1;
                            }
                            idx0 = CreatePatchOperation.findOffset(data, as, idx);
                            idx1 = CreatePatchOperation.findOffset(data, "\t(".getBytes(), idx0);
                            if (idx0 != -1 && idx1 != -1) {
                                stream.write(data, idx, idx0 - idx + as.length);
                                stream.write(fn);
                                idx = idx1;
                            }
                            stream.write(data, idx, data.length - idx);
                        } else {
                            stream.write(data);
                        }
                        break block24;
                    }
                    finally {
                        location.releaseSVNProxy(proxy);
                        tmp.delete();
                    }
                }
                if (this.processUnversioned && !IStateFilter.SF_IGNORED.accept(local)) {
                    int type = FileUtility.getMIMEType((IResource)resource);
                    if ((this.options & 4L) != 0L || type != 2) {
                        stream.write(this.getNewFileDiff(wcPath, fileName, charset).getBytes(charset));
                    }
                }
            }
            catch (IOException ex) {
                throw new UnreportableException(ex);
            }
            catch (SVNConnectorException ex) {
                throw new UnreportableException(ex);
            }
            catch (CoreException ex) {
                throw new UnreportableException(ex);
            }
        }
    }

    protected String getNewFileDiff(String path, String fileName, String charset) throws IOException {
        String string;
        File file = new File(path);
        byte[] data = new byte[(int)file.length()];
        FileInputStream stream = new FileInputStream(file);
        try {
            ((InputStream)stream).read(data);
            string = this.getNewContentDiff(fileName, new String(data, charset));
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (Exception exception) {}
        return string;
    }

    protected String getNewContentDiff(String fileName, String content) {
        if (content.length() == 0) {
            return this.getEmptyNewContentDiff(fileName);
        }
        ArrayList<String> tLines = new ArrayList<String>();
        int i = 0;
        int lineStart = 0;
        int m = content.length();
        while (i < m) {
            if (content.charAt(i) == '\n') {
                tLines.add(content.substring(lineStart, ++i));
                lineStart = i;
                continue;
            }
            if (content.charAt(i) == '\r') {
                if (++i < m && content.charAt(i) == '\n') {
                    ++i;
                }
                tLines.add(content.substring(lineStart, i));
                lineStart = i;
                continue;
            }
            if (++i != m) continue;
            tLines.add(content.substring(lineStart, i));
        }
        String[] lines = tLines.toArray(new String[tLines.size()]);
        String retVal = this.getFilledNewContentDiff(fileName, lines);
        if (!(content.endsWith("\r\n") || content.endsWith("\r") || content.endsWith("\n"))) {
            retVal = String.valueOf(retVal) + this.noLF;
        }
        return retVal;
    }

    protected String getFilledNewContentDiff(String fileName, String[] lines) {
        String retVal = String.valueOf(this.getEmptyNewContentDiff(fileName)) + this.removeSign + fileName + this.revisionMark + this.addSign + fileName + this.revisionMark + this.rangeStart + (lines.length == 1 ? "" : "," + lines.length) + this.rangeEnd;
        int i = 0;
        while (i < lines.length) {
            retVal = String.valueOf(retVal) + "+" + lines[i];
            ++i;
        }
        return retVal;
    }

    protected String getEmptyNewContentDiff(String fileName) {
        return String.valueOf(this.indexEntry) + fileName + this.contentSeparator;
    }

    protected static int findOffset(byte[] where, byte[] what, int offset) {
        int i = offset;
        int m = where.length - what.length;
        while (i < m) {
            if (CreatePatchOperation.match(where, what, i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static boolean match(byte[] where, byte[] what, int offset) {
        if (where.length - offset < what.length) {
            return false;
        }
        int i = offset + what.length - 1;
        int j = what.length - 1;
        while (i >= offset) {
            if (where[i] != what[j]) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }
}

