/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.property;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;

public class SetPropertyOperation
extends AbstractFileOperation {
    protected SVNProperty[] propertyData;
    protected boolean isRecursive;

    public SetPropertyOperation(File[] files, String name, byte[] data, boolean isRecursive) {
        this(files, new SVNProperty[]{new SVNProperty(name, new String(data))}, isRecursive);
    }

    public SetPropertyOperation(File[] files, SVNProperty[] data, boolean isRecursive) {
        super("Operation_SetPropertiesFile", SVNMessages.class, files);
        this.propertyData = data;
        this.isRecursive = isRecursive;
    }

    public SetPropertyOperation(IFileProvider provider, String name, byte[] data, boolean isRecursive) {
        this(provider, new SVNProperty[]{new SVNProperty(name, new String(data))}, isRecursive);
    }

    public SetPropertyOperation(IFileProvider provider, SVNProperty[] data, boolean isRecursive) {
        super("Operation_SetPropertiesFile", SVNMessages.class, provider);
        this.propertyData = data;
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        if (this.isRecursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        }
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < SetPropertyOperation.this.propertyData.length && !monitor.isCanceled()) {
                        final SVNProperty property = SetPropertyOperation.this.propertyData[i];
                        SetPropertyOperation.this.protectStep(new IUnprotectedOperation(){

                            public void run(IProgressMonitor monitor) throws Exception {
                                proxy.setPropertyLocal(new String[]{current.getAbsolutePath()}, property, SVNDepth.infinityOrEmpty((this).SetPropertyOperation.this.isRecursive), 0L, null, new SVNProgressMonitor(SetPropertyOperation.this, monitor, null));
                            }
                        }, monitor, SetPropertyOperation.this.propertyData.length);
                        ++i;
                    }
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected ISchedulingRule getSchedulingRule(File file) {
        return file.isDirectory() ? new AbstractFileOperation.LockingRule(file) : super.getSchedulingRule(file);
    }
}

