/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.search;

import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.search.JavaProjectsWalker;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.InputValidator;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.search.ui.text.Match;

public class NlsFindMissingKeysJob
extends AbstractJob {
    private final Map<String, Collection<Pattern>> m_patternsByFileType;
    private final Map<IJavaProject, Set<String>> m_existingKeys = new HashMap<IJavaProject, Set<String>>();
    private final List<Match> m_matches = new ArrayList<Match>();
    private final List<Match> m_errorMatches = new ArrayList<Match>();
    private final String m_textClassName;

    public NlsFindMissingKeysJob() {
        super("Search for text keys that are used but do not exist.");
        this.m_patternsByFileType = new HashMap<String, Collection<Pattern>>();
        String nlsKeyPattern = InputValidator.REGEX_NLS_KEY_NAME.pattern();
        Pattern jsonTextKeyPat = Pattern.compile("\\$\\{textKey:(" + nlsKeyPattern + ')');
        Pattern jsTextKeyPat = Pattern.compile("session\\.text\\(('?)(" + nlsKeyPattern + ")('?)");
        this.m_patternsByFileType.put("java", Collections.singletonList(Pattern.compile("TEXTS\\.get\\((\"?)(" + nlsKeyPattern + ")(\"?)")));
        this.m_patternsByFileType.put("json", Collections.singletonList(jsonTextKeyPat));
        this.m_patternsByFileType.put("js", Arrays.asList(jsTextKeyPat, jsonTextKeyPat));
        this.m_patternsByFileType.put("html", Arrays.asList(Pattern.compile("\\<scout:message key=\"(" + nlsKeyPattern + ")\"\\s*/?\\>"), jsTextKeyPat, jsonTextKeyPat));
        this.m_textClassName = String.valueOf(Signature.getSimpleName((String)"org.eclipse.scout.rt.shared.TEXTS")) + ".java";
    }

    private static Set<String> keysVisibleFrom(IJavaProject jp) {
        if (!S2eUtils.exists((IJavaElement)jp)) {
            return Collections.emptySet();
        }
        INlsProject nlsProject = NlsCore.getNlsWorkspace().getNlsProject(jp);
        if (nlsProject == null) {
            return Collections.emptySet();
        }
        return nlsProject.getAllKeys();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        this.m_matches.clear();
        this.m_errorMatches.clear();
        new JavaProjectsWalker(this.getName()).withExtensionsAccepted(this.m_patternsByFileType.keySet()).withFilter(this::isInterestingPath).walk(this::searchInFile, monitor);
    }

    protected boolean isInterestingPath(Path p, BasicFileAttributes attrs) {
        if (attrs.isDirectory()) {
            return !p.endsWith("src/test") && !p.endsWith("archetype-resources") && !p.endsWith("generated-resources");
        }
        return !p.endsWith(this.m_textClassName);
    }

    protected void searchInFile(JavaProjectsWalker.WorkspaceFile file) {
        int lastDotPos;
        if (!file.inWorkspace().isPresent()) {
            SdkLog.warning((String)"File '{}' could not be found in the current Eclipse Workspace.", (Object[])new Object[]{file.path()});
            return;
        }
        String fileName = file.path().getFileName().toString().toLowerCase();
        String extension = fileName.substring((lastDotPos = fileName.lastIndexOf(46)) + 1);
        Collection<Pattern> patterns = this.m_patternsByFileType.get(extension);
        if (patterns == null || patterns.isEmpty()) {
            throw new SdkException("Unexpected: no pattern for file: " + file.path());
        }
        for (Pattern p : patterns) {
            Matcher matcher = p.matcher(CharBuffer.wrap(file.content()));
            while (matcher.find()) {
                int keyGroup;
                if (matcher.groupCount() > 1) {
                    boolean noLiteral;
                    keyGroup = 2;
                    boolean bl = noLiteral = StringUtils.isEmpty((CharSequence)matcher.group(1)) || StringUtils.isEmpty((CharSequence)matcher.group(3));
                    if (noLiteral) {
                        NlsFindMissingKeysJob.registerMatch(file, matcher, this.m_errorMatches, keyGroup);
                        continue;
                    }
                } else {
                    keyGroup = 1;
                }
                String key = matcher.group(keyGroup);
                if (this.keyExists(file.inWorkspace().get().getProject(), key)) continue;
                NlsFindMissingKeysJob.registerMatch(file, matcher, this.m_matches, keyGroup);
            }
        }
    }

    protected boolean keyExists(IProject context, String key) {
        return this.m_existingKeys.computeIfAbsent(JavaCore.create((IProject)context), NlsFindMissingKeysJob::keysVisibleFrom).contains(key);
    }

    protected static Match registerMatch(JavaProjectsWalker.WorkspaceFile file, MatchResult matcher, Collection<Match> targetList, int keyGroup) {
        int index = matcher.start(keyGroup);
        Match match = new Match((Object)file.inWorkspace().get(), index, matcher.end(keyGroup) - index);
        targetList.add(match);
        return match;
    }

    public List<Match> matches() {
        return Collections.unmodifiableList(this.m_matches);
    }

    public List<Match> errors() {
        return Collections.unmodifiableList(this.m_errorMatches);
    }
}

