/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import java.awt.Point;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.AbstractTreeTester;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.tester.util.NodeTraverseHelper;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class TreeViewTester
extends AbstractTreeTester {
    private EventHandler<ScrollToEvent> m_scrollConsumer = new EventHandler<ScrollToEvent>(){

        public void handle(ScrollToEvent event) {
            event.consume();
        }
    };

    public void rcVerifyTextAtMousePosition(final String txt, final String operator, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyTextAtMousePosition", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                TreeViewTester.this.checkNodeText(new Object[]{TreeViewTester.this.getNodeAtMousePosition()}, txt, operator);
            }
        });
    }

    public void rcDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treeTextPath, String operator) {
        Node tree = (Node)this.getRealComponent();
        tree.addEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
        super.rcDragByTextPath(mouseButton, modifier, pathType, preAscend, treeTextPath, operator);
    }

    public void rcDropByTextPath(String pathType, int preAscend, String treeTextPath, String operator, int delayBeforeDrop) {
        super.rcDropByTextPath(pathType, preAscend, treeTextPath, operator, delayBeforeDrop);
        Node tree = (Node)this.getRealComponent();
        tree.removeEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
    }

    public void rcDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String treeIndexPath) {
        Node tree = (Node)this.getRealComponent();
        tree.addEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
        super.rcDragByIndexPath(mouseButton, modifier, pathType, preAscend, treeIndexPath);
    }

    public void rcDropByIndexPath(String pathType, int preAscend, String treeIndexPath, int delayBeforeDrop) {
        super.rcDropByIndexPath(pathType, preAscend, treeIndexPath, delayBeforeDrop);
        Node tree = (Node)this.getRealComponent();
        tree.removeEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        Point awtPoint = this.getRobot().getCurrentMousePosition();
        final Point2D point = new Point2D((double)awtPoint.x, (double)awtPoint.y);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeBounds", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TreeView tree = (TreeView)TreeViewTester.this.getRealComponent();
                tree.layout();
                List<TreeCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)tree, TreeCell.class);
                for (TreeCell cell : tCells) {
                    if (!NodeBounds.checkIfContains(point, (Node)cell) || !NodeTraverseHelper.isVisible((Node)cell)) continue;
                    return cell.getTreeItem();
                }
                throw new StepExecutionException("No tree node found at mouse position: X: " + point.getX() + "Y: " + point.getY(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
        return result;
    }
}

