/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.CleanupComponentNamesDialog;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.DeleteTreeItemHandlerOMEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.objectmapping.OMEditorTreeContentProvider;
import org.eclipse.jubula.client.ui.rcp.search.query.ShowResponsibleNodeForComponentName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMEDeleteUnusedComponentNamesHandler
extends AbstractHandler {
    static final Logger LOG = LoggerFactory.getLogger(OMEDeleteUnusedComponentNamesHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return null;
        }
        ArrayList<Object> allTreeElements = new ArrayList<Object>();
        TreeViewer[] treeViewerArray = editor.getTreeViewers();
        int n = treeViewerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeViewer tv = treeViewerArray[n2];
            OMEditorTreeContentProvider ometcp = (OMEditorTreeContentProvider)tv.getContentProvider();
            Object[] objectArray = ometcp.getElements(tv.getInput());
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object o = objectArray[n4];
                allTreeElements.addAll(this.getAllElements(o, ometcp));
                ++n4;
            }
            ++n2;
        }
        final Object[] aObjects = allTreeElements.toArray();
        final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event).getShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(activeShell);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.Searching, aObjects.length);
                    OMEUsedComponentNameSearch vf = new OMEUsedComponentNameSearch(editor.getAut());
                    vf.performSearch(aObjects, monitor);
                    ArrayList<IComponentNamePO> unusedNames = new ArrayList<IComponentNamePO>();
                    for (Object o : vf.getResult().keySet()) {
                        if (!(o instanceof IComponentNamePO) || !vf.getResult().get(o).booleanValue()) continue;
                        unusedNames.add((IComponentNamePO)o);
                    }
                    if (unusedNames.size() > 0) {
                        if (!monitor.isCanceled()) {
                            OMEDeleteUnusedComponentNamesHandler.this.openDialog(unusedNames, editor);
                        }
                    } else {
                        Plugin.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)activeShell, (String)Messages.CleanCompNamesNoResultDialogTitle, (String)Messages.CleanCompNamesNoResultDialogMsg);
                            }
                        });
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    protected void openDialog(final List<IComponentNamePO> unusedNames, final ObjectMappingMultiPageEditor ome) {
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CleanupComponentNamesDialog dialog = new CleanupComponentNamesDialog(Plugin.getActiveWorkbenchWindowShell(), unusedNames);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    DeleteTreeItemHandlerOMEditor.deleteMultipleElements(dialog.getCheckedElements(), ome);
                }
            }
        });
    }

    private List<Object> getAllElements(Object o, OMEditorTreeContentProvider ometcp) {
        ArrayList<Object> treeElements = new ArrayList<Object>();
        treeElements.add(o);
        if (ometcp.hasChildren(o)) {
            Object[] objectArray = ometcp.getChildren(o);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                treeElements.addAll(this.getAllElements(child, ometcp));
                ++n2;
            }
        }
        return treeElements;
    }

    public class OMEUsedComponentNameSearch {
        private IAUTMainPO m_aut = null;
        private Map<Object, Boolean> m_result = new HashMap<Object, Boolean>();

        public OMEUsedComponentNameSearch(IAUTMainPO aut) {
            this.m_aut = aut;
        }

        public void performSearch(Object[] elements, IProgressMonitor monitor) {
            int noOfUnused = 0;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (monitor.isCanceled()) {
                    return;
                }
                if (!this.getResult().containsKey(o) && this.isUsed(o, monitor) && o instanceof IComponentNamePO) {
                    monitor.subTask(NLS.bind((String)Messages.SearchingUnusedComponentNames, (Object)(++noOfUnused)));
                }
                monitor.worked(1);
                ++n2;
            }
        }

        private boolean isUsed(Object element, IProgressMonitor monitor) {
            if (this.getResult().containsKey(element)) {
                return this.getResult().get(element);
            }
            boolean select = true;
            if (element instanceof IComponentNamePO) {
                IComponentNamePO compName = (IComponentNamePO)element;
                ShowResponsibleNodeForComponentName query = new ShowResponsibleNodeForComponentName(compName, this.m_aut);
                query.run(monitor);
                select = query.isEmpty();
            }
            this.getResult().put(element, select);
            return select;
        }

        public Map<Object, Boolean> getResult() {
            return this.m_result;
        }
    }
}

