/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compiler;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.LocationValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceType;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ResourceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.fx.ide.fxml.compiler.ReflectionHelper;
import org.eclipse.fx.ide.fxml.compiler.ValueType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FXGraphJavaGenerator {
    private int varIndex = 0;
    private Set<String> extraImports = new HashSet<String>();
    private Model model;
    private boolean fieldReflection;
    private boolean resourceUrl;

    public FXGraphJavaGenerator(Model model) {
        this.model = model;
        this.registerImport("java.net.URL");
        this.registerImport("org.eclipse.fx.core.fxml.FXMLDocument");
        this.registerImport("org.eclipse.fx.core.fxml.FXMLDocument.LoadData");
        this.registerImport("java.util.Map");
        this.registerImport("java.util.HashMap");
        this.registerImport("java.util.ResourceBundle");
        this.registerImport("javafx.util.Callback");
    }

    public int getVarIndex() {
        ++this.varIndex;
        return this.varIndex;
    }

    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = this.model.getPackage().getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence content = this.generateElementDef("root", this.model.getComponentDef().getRootNode(), this.model.getComponentDef().isDynamicRoot());
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _imports = this.model.getImports();
        for (Object i : _imports) {
            _builder.append("import ");
            String _importedNamespace = i.getImportedNamespace();
            _builder.append(_importedNamespace);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        for (String i_1 : this.extraImports) {
            _builder.append("import ");
            _builder.append(i_1);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("@SuppressWarnings(\"all\")");
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = this.model.getComponentDef().getName();
        _builder.append(_name_1);
        _builder.append(" extends FXMLDocument<");
        String _simpleName = this.model.getComponentDef().getRootNode().getType().getSimpleName();
        _builder.append(_simpleName);
        _builder.append("> {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private Map<String,Object> namespaceMap = new HashMap<>();");
        _builder.newLine();
        boolean _hasController = this.hasController();
        if (_hasController) {
            _builder.append("\t");
            String _qualifiedName = this.model.getComponentDef().getController().getQualifiedName();
            _builder.append(_qualifiedName, "\t");
            _builder.append(" _c;");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public \t");
            String _qualifiedName_1 = this.model.getComponentDef().getController().getQualifiedName();
            _builder.append(_qualifiedName_1, "\t");
            _builder.append(" getController() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return _c;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("public Object getController() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return null;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _simpleName_1 = this.model.getComponentDef().getRootNode().getType().getSimpleName();
        _builder.append(_simpleName_1, "\t");
        _builder.append(" load(LoadData<");
        String _simpleName_2 = this.model.getComponentDef().getRootNode().getType().getSimpleName();
        _builder.append(_simpleName_2, "\t");
        _builder.append("> loadData) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("final URL location = loadData.location;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("final ResourceBundle resourceBundle = loadData.bundle;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("final Callback<Class<?>, Object> controllerFactory = loadData.controllerFactory;");
        _builder.newLine();
        _builder.newLine();
        boolean _hasController_1 = this.hasController();
        if (_hasController_1) {
            _builder.append("\t\t");
            _builder.append("if( controllerFactory != null ) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("_c = (");
            String _qualifiedName_2 = this.model.getComponentDef().getController().getQualifiedName();
            _builder.append(_qualifiedName_2, "\t\t\t");
            _builder.append(")controllerFactory.call(");
            String _qualifiedName_3 = this.model.getComponentDef().getController().getQualifiedName();
            _builder.append(_qualifiedName_3, "\t\t\t");
            _builder.append(".class);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("} else {");
            _builder.newLine();
            boolean _hasNoArgConstructor = ReflectionHelper.hasNoArgConstructor(this.model.getComponentDef().getController());
            if (_hasNoArgConstructor) {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("_c = new ");
                String _qualifiedName_4 = this.model.getComponentDef().getController().getQualifiedName();
                _builder.append(_qualifiedName_4, "\t\t\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("// ");
                String _qualifiedName_5 = this.model.getComponentDef().getController().getQualifiedName();
                _builder.append(_qualifiedName_5, "\t\t\t");
                _builder.append(" cannot be instantiated by reflection");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        if (this.resourceUrl) {
            _builder.append("\t\t");
            _builder.append("final String baseURL = createBaseURL(location);");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append((Object)content, "\t\t");
        _builder.newLineIfNotEmpty();
        if (this.hasController() && ReflectionHelper.hasMethod(this.model.getComponentDef().getController(), "initialize", URL.class, ResourceBundle.class)) {
            _builder.append("\t\t");
            _builder.append("_c.initialize(location,resourceBundle);");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("return root;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        if (this.resourceUrl) {
            _builder.append("\t");
            _builder.append("private static String createBaseURL(URL url) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("String externalForm = url.toExternalForm();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return externalForm.substring(0,externalForm.lastIndexOf('/'));");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        if (this.fieldReflection) {
            _builder.append("\t");
            _builder.append("private static void setFieldReflective(Class<?> owner, String n, Object c, Object v) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("try {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("Field f = owner.getDeclaredField(n);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("f.setAccessible(true);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("f.set(c, v);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("} catch(Throwable e) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("e.printStackTrace();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public boolean hasController() {
        JvmTypeReference _controller = this.model.getComponentDef().getController();
        return !Objects.equal((Object)_controller, null);
    }

    public void enableFieldReflection(String name) {
        this.fieldReflection = true;
        this.registerImport("java.lang.reflect.*");
    }

    public void registerImport(String name) {
        this.extraImports.add(name);
    }

    public void enableResourceUrl() {
        this.resourceUrl = true;
    }

    public CharSequence controllerFieldAccess(String name, Element element) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasField = ReflectionHelper.hasField(this.model.getComponentDef().getController(), this.model.getPackage().getName(), element.getName());
        if (_hasField) {
            boolean _hasAccessibleField = ReflectionHelper.hasAccessibleField(this.model.getComponentDef().getController(), this.model.getPackage().getName(), element.getName());
            if (_hasAccessibleField) {
                _builder.append("_c.");
                String _name = element.getName();
                _builder.append(_name);
                _builder.append(" = ");
                _builder.append(name);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            } else {
                this.enableFieldReflection(element.getName());
                _builder.newLineIfNotEmpty();
                _builder.append("// resort to reflection");
                _builder.newLine();
                _builder.append("setFieldReflective(");
                String _fieldOwner = ReflectionHelper.getFieldOwner(this.model.getComponentDef().getController(), element.getName());
                _builder.append(_fieldOwner);
                _builder.append(".class, \"");
                String _name_1 = element.getName();
                _builder.append(_name_1);
                _builder.append("\", _c, ");
                _builder.append(name);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence eventBindingAccess(String name, String propertyName, String methodName, Element element) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        this.registerImport("javafx.event.EventHandler");
        _builder.newLineIfNotEmpty();
        _builder.append(name);
        _builder.append(".set");
        String _firstUpper = StringExtensions.toFirstUpper((String)propertyName);
        _builder.append(_firstUpper);
        _builder.append("(new EventHandler<");
        String _eventType = ReflectionHelper.eventType(element.getType(), propertyName);
        _builder.append(_eventType);
        _builder.append(">() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public void handle(");
        String _eventType_1 = ReflectionHelper.eventType(element.getType(), propertyName);
        _builder.append(_eventType_1, "\t");
        _builder.append(" event) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("_c.");
        _builder.append(methodName, "\t\t");
        _builder.append("(");
        boolean _hasMethod = ReflectionHelper.hasMethod(this.model.getComponentDef().getController(), methodName, new Class[0]);
        boolean bl = _not = !_hasMethod;
        if (_not) {
            _builder.append("event");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("});");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateElementDef(String name, Element element) {
        return this.generateElementDef(name, element, false);
    }

    public CharSequence generateElementDef(String name, Element element, boolean dynRoot) {
        String _name_6;
        boolean _notEquals_12;
        StringConcatenation _builder = new StringConcatenation();
        if (!dynRoot && ReflectionHelper.needsBuilder(element.getType())) {
            String _qualifiedName = element.getType().getQualifiedName();
            boolean _equals = Objects.equal((Object)"javafx.scene.image.Image", (Object)_qualifiedName);
            if (_equals) {
                _builder.append("Image ");
                _builder.append(name);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("ImageBuilder ");
                _builder.append(name);
                _builder.append("Builder = ImageBuilder.create();");
                _builder.newLineIfNotEmpty();
                this.registerImport("org.eclipse.fx.core.fxml.ImageBuilder");
                _builder.newLineIfNotEmpty();
            } else {
                String _qualifiedName_1 = element.getType().getQualifiedName();
                boolean _equals_1 = Objects.equal((Object)"java.net.URL", (Object)_qualifiedName_1);
                if (_equals_1) {
                    _builder.append("URL ");
                    _builder.append(name);
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("URLBuilder ");
                    _builder.append(name);
                    _builder.append("Builder = URLBuilder.create();");
                    _builder.newLineIfNotEmpty();
                    this.registerImport("org.eclipse.fx.core.fxml.URLBuilder");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _simpleName = element.getType().getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append(" ");
                    _builder.append(name);
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    String _simpleName_1 = element.getType().getSimpleName();
                    _builder.append(_simpleName_1);
                    _builder.append("Builder ");
                    _builder.append(name);
                    _builder.append("Builder = ");
                    String _simpleName_2 = element.getType().getSimpleName();
                    _builder.append(_simpleName_2);
                    _builder.append("Builder.create();");
                    _builder.newLineIfNotEmpty();
                    String _qualifiedName_2 = element.getType().getQualifiedName();
                    String _plus = String.valueOf(_qualifiedName_2) + "Builder";
                    this.registerImport(_plus);
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _properties = element.getProperties();
            for (Property p : _properties) {
                ValueProperty _value = p.getValue();
                if (_value instanceof SimpleValueProperty) {
                    boolean _notEquals;
                    ValueProperty _value_1 = p.getValue();
                    String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                    boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
                    if (_notEquals) {
                        boolean _notEquals_1;
                        String enumType = ReflectionHelper.getEnumType(element.getType(), p.getName(), false);
                        _builder.newLineIfNotEmpty();
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)enumType, null);
                        if (_notEquals_1) {
                            _builder.append(name);
                            _builder.append("Builder.");
                            String _name = p.getName();
                            _builder.append(_name);
                            _builder.append("(");
                            _builder.append(enumType);
                            _builder.append(".");
                            ValueProperty _value_2 = p.getValue();
                            String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                            _builder.append(_stringValue_1);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        ValueType type = ReflectionHelper.getValueType(element.getType().getType(), p.getName());
                        _builder.newLineIfNotEmpty();
                        boolean _equals_2 = Objects.equal((Object)((Object)type), (Object)((Object)ValueType.CLASS));
                        if (_equals_2) {
                            _builder.append(name);
                            _builder.append("Builder.");
                            String _name_1 = p.getName();
                            _builder.append(_name_1);
                            _builder.append("(");
                            String _type = ReflectionHelper.getType(element.getType().getType(), p.getName());
                            _builder.append(_type);
                            _builder.append(".valueOf(\"");
                            ValueProperty _value_3 = p.getValue();
                            String _stringValue_2 = ((SimpleValueProperty)_value_3).getStringValue();
                            _builder.append(_stringValue_2);
                            _builder.append("\"));");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append(name);
                        _builder.append("Builder.");
                        String _name_2 = p.getName();
                        _builder.append(_name_2);
                        _builder.append("(");
                        ValueProperty _value_4 = p.getValue();
                        String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_4);
                        _builder.append(_simpleAttributeValue);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append(name);
                    _builder.append("Builder.");
                    String _name_3 = p.getName();
                    _builder.append(_name_3);
                    _builder.append("(");
                    ValueProperty _value_5 = p.getValue();
                    String _simpleAttributeValue_1 = this.simpleAttributeValue((SimpleValueProperty)_value_5);
                    _builder.append(_simpleAttributeValue_1);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                ValueProperty _value_6 = p.getValue();
                if (!(_value_6 instanceof LocationValueProperty)) continue;
                _builder.append(name);
                _builder.append("Builder.");
                String _name_4 = p.getName();
                _builder.append(_name_4);
                _builder.append("(baseURL + \"/");
                ValueProperty _value_7 = p.getValue();
                String _value_8 = ((LocationValueProperty)_value_7).getValue();
                _builder.append(_value_8);
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                this.enableResourceUrl();
                _builder.newLineIfNotEmpty();
            }
            _builder.append(name);
            _builder.append(" = ");
            _builder.append(name);
            _builder.append("Builder.build();");
            _builder.newLineIfNotEmpty();
            if (!Objects.equal((Object)element.getName(), null) && this.hasController()) {
                CharSequence _controllerFieldAccess = this.controllerFieldAccess(name, element);
                _builder.append((Object)_controllerFieldAccess);
                _builder.newLineIfNotEmpty();
            }
        } else {
            if (dynRoot) {
                String _simpleName_3 = element.getType().getSimpleName();
                _builder.append(_simpleName_3);
                _builder.append(" ");
                _builder.append(name);
                _builder.append(" = loadData.rootNode;");
                _builder.newLineIfNotEmpty();
            } else {
                String _qualifiedName_3 = element.getType().getQualifiedName();
                boolean _equals_3 = Objects.equal((Object)_qualifiedName_3, (Object)"java.lang.String");
                if (_equals_3) {
                    String _simpleName_4 = element.getType().getSimpleName();
                    _builder.append(_simpleName_4);
                    _builder.append(" ");
                    _builder.append(name);
                    _builder.append(" = ");
                    String _simpleName_5 = element.getType().getSimpleName();
                    _builder.append(_simpleName_5);
                    _builder.append(".valueOf(\"");
                    _builder.append((Object)element);
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _simpleName_6 = element.getType().getSimpleName();
                    _builder.append(_simpleName_6);
                    _builder.append(" ");
                    _builder.append(name);
                    _builder.append(" = new ");
                    String _simpleName_7 = element.getType().getSimpleName();
                    _builder.append(_simpleName_7);
                    _builder.append("();");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _properties_1 = element.getProperties();
            for (Property p_1 : _properties_1) {
                ValueProperty _value_9 = p_1.getValue();
                if (_value_9 instanceof SimpleValueProperty) {
                    boolean _notEquals_2;
                    ValueProperty _value_10 = p_1.getValue();
                    String _stringValue_3 = ((SimpleValueProperty)_value_10).getStringValue();
                    boolean bl = _notEquals_2 = !Objects.equal((Object)_stringValue_3, null);
                    if (_notEquals_2) {
                        boolean _notEquals_3;
                        String enumType_1 = ReflectionHelper.getEnumType(element.getType(), p_1.getName(), false);
                        _builder.newLineIfNotEmpty();
                        boolean bl3 = _notEquals_3 = !Objects.equal((Object)enumType_1, null);
                        if (_notEquals_3) {
                            _builder.append(name);
                            _builder.append(".set");
                            String _firstUpper = StringExtensions.toFirstUpper((String)p_1.getName());
                            _builder.append(_firstUpper);
                            _builder.append("(");
                            _builder.append(enumType_1);
                            _builder.append(".");
                            ValueProperty _value_11 = p_1.getValue();
                            String _stringValue_4 = ((SimpleValueProperty)_value_11).getStringValue();
                            _builder.append(_stringValue_4);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        ValueType type_1 = ReflectionHelper.getValueType(element.getType().getType(), p_1.getName());
                        _builder.newLineIfNotEmpty();
                        boolean _equals_4 = Objects.equal((Object)((Object)type_1), (Object)((Object)ValueType.CLASS));
                        if (_equals_4) {
                            _builder.append(name);
                            _builder.append(".set");
                            String _firstUpper_1 = StringExtensions.toFirstUpper((String)p_1.getName());
                            _builder.append(_firstUpper_1);
                            _builder.append("(");
                            String _type_1 = ReflectionHelper.getType(element.getType().getType(), p_1.getName());
                            _builder.append(_type_1);
                            _builder.append(".valueOf(\"");
                            ValueProperty _value_12 = p_1.getValue();
                            String _stringValue_5 = ((SimpleValueProperty)_value_12).getStringValue();
                            _builder.append(_stringValue_5);
                            _builder.append("\"));");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append(name);
                        _builder.append(".set");
                        String _firstUpper_2 = StringExtensions.toFirstUpper((String)p_1.getName());
                        _builder.append(_firstUpper_2);
                        _builder.append("(");
                        ValueProperty _value_13 = p_1.getValue();
                        String _simpleAttributeValue_2 = this.simpleAttributeValue((SimpleValueProperty)_value_13);
                        _builder.append(_simpleAttributeValue_2);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append(name);
                    _builder.append(".set");
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)p_1.getName());
                    _builder.append(_firstUpper_3);
                    _builder.append("(");
                    ValueProperty _value_14 = p_1.getValue();
                    String _simpleAttributeValue_3 = this.simpleAttributeValue((SimpleValueProperty)_value_14);
                    _builder.append(_simpleAttributeValue_3);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                if (p_1.getValue() instanceof ControllerHandledValueProperty && this.hasController()) {
                    ValueProperty _value_15 = p_1.getValue();
                    CharSequence _eventBindingAccess = this.eventBindingAccess(name, p_1.getName(), ((ControllerHandledValueProperty)_value_15).getMethodname(), element);
                    _builder.append((Object)_eventBindingAccess);
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                ValueProperty _value_16 = p_1.getValue();
                if (_value_16 instanceof ReferenceValueProperty) {
                    _builder.append(name);
                    _builder.append(".set");
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)p_1.getName());
                    _builder.append(_firstUpper_4);
                    _builder.append("((");
                    ValueProperty _value_17 = p_1.getValue();
                    ReferenceType _reference = ((ReferenceValueProperty)_value_17).getReference();
                    String _qualifiedName_4 = ((Element)_reference).getType().getQualifiedName();
                    _builder.append(_qualifiedName_4);
                    _builder.append(")namespaceMap.get(\"");
                    ValueProperty _value_18 = p_1.getValue();
                    ReferenceType _reference_1 = ((ReferenceValueProperty)_value_18).getReference();
                    String _name_5 = ((Element)_reference_1).getName();
                    _builder.append(_name_5);
                    _builder.append("\"));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                ValueProperty _value_19 = p_1.getValue();
                if (_value_19 instanceof Element) {
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    int _varIndex = this.getVarIndex();
                    String varName = "e_" + Integer.valueOf(_varIndex);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    ValueProperty _value_20 = p_1.getValue();
                    CharSequence _generateElementDef = this.generateElementDef(varName, (Element)_value_20);
                    _builder.append((Object)_generateElementDef, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(name, "\t");
                    _builder.append(".set");
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)p_1.getName());
                    _builder.append(_firstUpper_5, "\t");
                    _builder.append("(");
                    _builder.append(varName, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    ValueProperty _value_21 = p_1.getValue();
                    CharSequence _staticProperties = this.staticProperties(varName, (Element)_value_21);
                    _builder.append((Object)_staticProperties, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    ValueProperty _value_22 = p_1.getValue();
                    CharSequence _staticCallProperties = this.staticCallProperties(varName, (Element)_value_22);
                    _builder.append((Object)_staticCallProperties, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                ValueProperty _value_23 = p_1.getValue();
                if (_value_23 instanceof ListValueProperty) {
                    ValueProperty _value_24 = p_1.getValue();
                    boolean _onlyPrimitive = this.onlyPrimitive((List<ListValueElement>)((ListValueProperty)_value_24).getValue());
                    if (_onlyPrimitive) {
                        String lt = ReflectionHelper.listType(element.getType(), p_1.getName());
                        _builder.newLineIfNotEmpty();
                        _builder.append(name);
                        _builder.append(".get");
                        String _firstUpper_6 = StringExtensions.toFirstUpper((String)p_1.getName());
                        _builder.append(_firstUpper_6);
                        _builder.append("().setAll(");
                        _builder.newLineIfNotEmpty();
                        ValueProperty _value_25 = p_1.getValue();
                        EList _value_26 = ((ListValueProperty)_value_25).getValue();
                        for (ListValueElement l : _value_26) {
                            boolean _notEquals_10;
                            boolean _notEquals_4;
                            _builder.append("\t");
                            SimpleValueProperty sl = (SimpleValueProperty)l;
                            _builder.newLineIfNotEmpty();
                            String _stringValue_6 = sl.getStringValue();
                            boolean bl = _notEquals_4 = !Objects.equal((Object)_stringValue_6, null);
                            if (_notEquals_4) {
                                boolean _notEquals_9;
                                boolean _equals_5 = Objects.equal((Object)"java.lang.String", (Object)lt);
                                if (_equals_5) {
                                    boolean _notEquals_5;
                                    _builder.append("\t");
                                    ValueProperty _value_27 = p_1.getValue();
                                    ListValueElement _head = (ListValueElement)IterableExtensions.head((Iterable)((ListValueProperty)_value_27).getValue());
                                    boolean bl4 = _notEquals_5 = !Objects.equal((Object)_head, (Object)sl);
                                    if (_notEquals_5) {
                                        _builder.append(", ");
                                    }
                                    String _simpleAttributeValue_4 = this.simpleAttributeValue(sl);
                                    _builder.append(_simpleAttributeValue_4, "\t");
                                    _builder.newLineIfNotEmpty();
                                    continue;
                                }
                                if (Objects.equal((Object)"java.lang.Double", (Object)lt) || Objects.equal((Object)"java.lang.Integer", (Object)lt) || Objects.equal((Object)"java.lang.Long", (Object)lt) || Objects.equal((Object)"java.lang.Float", (Object)lt)) {
                                    boolean _notEquals_8;
                                    boolean _equals_6 = Objects.equal((Object)"java.lang.Double", (Object)lt);
                                    if (_equals_6) {
                                        boolean _notEquals_6;
                                        _builder.append("\t");
                                        ValueProperty _value_28 = p_1.getValue();
                                        ListValueElement _head_1 = (ListValueElement)IterableExtensions.head((Iterable)((ListValueProperty)_value_28).getValue());
                                        boolean bl5 = _notEquals_6 = !Objects.equal((Object)_head_1, (Object)sl);
                                        if (_notEquals_6) {
                                            _builder.append(", ");
                                        }
                                        String _stringValue_7 = sl.getStringValue();
                                        _builder.append(_stringValue_7, "\t");
                                        _builder.append("d");
                                        _builder.newLineIfNotEmpty();
                                        continue;
                                    }
                                    boolean _equals_7 = Objects.equal((Object)"java.lang.Float", (Object)lt);
                                    if (_equals_7) {
                                        boolean _notEquals_7;
                                        _builder.append("\t");
                                        ValueProperty _value_29 = p_1.getValue();
                                        ListValueElement _head_2 = (ListValueElement)IterableExtensions.head((Iterable)((ListValueProperty)_value_29).getValue());
                                        boolean bl6 = _notEquals_7 = !Objects.equal((Object)_head_2, (Object)sl);
                                        if (_notEquals_7) {
                                            _builder.append(", ");
                                        }
                                        String _stringValue_8 = sl.getStringValue();
                                        _builder.append(_stringValue_8, "\t");
                                        _builder.append("f");
                                        _builder.newLineIfNotEmpty();
                                        continue;
                                    }
                                    _builder.append("\t");
                                    ValueProperty _value_30 = p_1.getValue();
                                    ListValueElement _head_3 = (ListValueElement)IterableExtensions.head((Iterable)((ListValueProperty)_value_30).getValue());
                                    boolean bl7 = _notEquals_8 = !Objects.equal((Object)_head_3, (Object)sl);
                                    if (_notEquals_8) {
                                        _builder.append(", ");
                                    }
                                    String _stringValue_9 = sl.getStringValue();
                                    _builder.append(_stringValue_9, "\t");
                                    _builder.newLineIfNotEmpty();
                                    continue;
                                }
                                _builder.append("\t");
                                ValueProperty _value_31 = p_1.getValue();
                                ListValueElement _head_4 = (ListValueElement)IterableExtensions.head((Iterable)((ListValueProperty)_value_31).getValue());
                                boolean bl8 = _notEquals_9 = !Objects.equal((Object)_head_4, (Object)sl);
                                if (_notEquals_9) {
                                    _builder.append(", ");
                                }
                                _builder.append(lt, "\t");
                                _builder.append(".valueOf(");
                                String _simpleAttributeValue_5 = this.simpleAttributeValue(sl);
                                _builder.append(_simpleAttributeValue_5, "\t");
                                _builder.append(")");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            _builder.append("\t");
                            ValueProperty _value_32 = p_1.getValue();
                            ListValueElement _head_5 = (ListValueElement)IterableExtensions.head((Iterable)((ListValueProperty)_value_32).getValue());
                            boolean bl9 = _notEquals_10 = !Objects.equal((Object)_head_5, (Object)sl);
                            if (_notEquals_10) {
                                _builder.append(", ");
                            }
                            String _simpleAttributeValue_6 = this.simpleAttributeValue(sl);
                            _builder.append(_simpleAttributeValue_6, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append(");");
                        _builder.newLine();
                        continue;
                    }
                    ValueProperty _value_33 = p_1.getValue();
                    EList _value_34 = ((ListValueProperty)_value_33).getValue();
                    for (ListValueElement l_1 : _value_34) {
                        _builder.append("{");
                        _builder.newLine();
                        int i = this.getVarIndex();
                        _builder.newLineIfNotEmpty();
                        String varName_1 = "e_" + Integer.valueOf(i);
                        _builder.newLineIfNotEmpty();
                        if (l_1 instanceof Element) {
                            _builder.append("\t");
                            CharSequence _generateElementDef_1 = this.generateElementDef(varName_1, (Element)l_1);
                            _builder.append((Object)_generateElementDef_1, "\t");
                            _builder.newLineIfNotEmpty();
                            String _qualifiedName_5 = ((Element)l_1).getType().getQualifiedName();
                            boolean _equals_8 = Objects.equal((Object)"java.net.URL", (Object)_qualifiedName_5);
                            if (_equals_8) {
                                _builder.append("\t");
                                _builder.append(name, "\t");
                                _builder.append(".get");
                                String _firstUpper_7 = StringExtensions.toFirstUpper((String)p_1.getName());
                                _builder.append(_firstUpper_7, "\t");
                                _builder.append("().add(");
                                _builder.append(varName_1, "\t");
                                _builder.append(".toExternalForm());");
                                _builder.newLineIfNotEmpty();
                            } else {
                                _builder.append("\t");
                                _builder.append(name, "\t");
                                _builder.append(".get");
                                String _firstUpper_8 = StringExtensions.toFirstUpper((String)p_1.getName());
                                _builder.append(_firstUpper_8, "\t");
                                _builder.append("().add(");
                                _builder.append(varName_1, "\t");
                                _builder.append(");");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append("\t");
                            CharSequence _staticProperties_1 = this.staticProperties(varName_1, (Element)l_1);
                            _builder.append((Object)_staticProperties_1, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            CharSequence _staticCallProperties_1 = this.staticCallProperties(varName_1, (Element)l_1);
                            _builder.append((Object)_staticCallProperties_1, "\t");
                            _builder.newLineIfNotEmpty();
                        } else if (l_1 instanceof SimpleValueProperty) {
                            boolean _notEquals_11;
                            String _stringValue_10 = ((SimpleValueProperty)l_1).getStringValue();
                            boolean bl = _notEquals_11 = !Objects.equal((Object)_stringValue_10, null);
                            if (_notEquals_11) {
                                _builder.append("\t");
                                String lt_1 = ReflectionHelper.listType(element.getType(), p_1.getName());
                                _builder.newLineIfNotEmpty();
                                boolean _equals_9 = Objects.equal((Object)"java.lang.String", (Object)lt_1);
                                if (_equals_9) {
                                    _builder.append("\t");
                                    _builder.append(name, "\t");
                                    _builder.append(".get");
                                    String _firstUpper_9 = StringExtensions.toFirstUpper((String)p_1.getName());
                                    _builder.append(_firstUpper_9, "\t");
                                    _builder.append("().add(");
                                    String _simpleAttributeValue_7 = this.simpleAttributeValue((SimpleValueProperty)l_1);
                                    _builder.append(_simpleAttributeValue_7, "\t");
                                    _builder.append(");");
                                    _builder.newLineIfNotEmpty();
                                } else if (Objects.equal((Object)"java.lang.Double", (Object)lt_1) || Objects.equal((Object)"java.lang.Integer", (Object)lt_1) || Objects.equal((Object)"java.lang.Long", (Object)lt_1) || Objects.equal((Object)"java.lang.Float", (Object)lt_1)) {
                                    boolean _equals_10 = Objects.equal((Object)"java.lang.Double", (Object)lt_1);
                                    if (_equals_10) {
                                        _builder.append("\t");
                                        _builder.append(name, "\t");
                                        _builder.append(".get");
                                        String _firstUpper_10 = StringExtensions.toFirstUpper((String)p_1.getName());
                                        _builder.append(_firstUpper_10, "\t");
                                        _builder.append("().add(");
                                        String _stringValue_11 = ((SimpleValueProperty)l_1).getStringValue();
                                        _builder.append(_stringValue_11, "\t");
                                        _builder.append("d);");
                                        _builder.newLineIfNotEmpty();
                                    } else {
                                        boolean _equals_11 = Objects.equal((Object)"java.lang.Float", (Object)lt_1);
                                        if (_equals_11) {
                                            _builder.append("\t");
                                            _builder.append(name, "\t");
                                            _builder.append(".get");
                                            String _firstUpper_11 = StringExtensions.toFirstUpper((String)p_1.getName());
                                            _builder.append(_firstUpper_11, "\t");
                                            _builder.append("().add(");
                                            String _stringValue_12 = ((SimpleValueProperty)l_1).getStringValue();
                                            _builder.append(_stringValue_12, "\t");
                                            _builder.append("f);");
                                            _builder.newLineIfNotEmpty();
                                        } else {
                                            _builder.append("\t");
                                            _builder.append(name, "\t");
                                            _builder.append(".get");
                                            String _firstUpper_12 = StringExtensions.toFirstUpper((String)p_1.getName());
                                            _builder.append(_firstUpper_12, "\t");
                                            _builder.append("().add(");
                                            String _stringValue_13 = ((SimpleValueProperty)l_1).getStringValue();
                                            _builder.append(_stringValue_13, "\t");
                                            _builder.append(");");
                                            _builder.newLineIfNotEmpty();
                                        }
                                    }
                                } else {
                                    _builder.append("\t");
                                    _builder.append(name, "\t");
                                    _builder.append(".get");
                                    String _firstUpper_13 = StringExtensions.toFirstUpper((String)p_1.getName());
                                    _builder.append(_firstUpper_13, "\t");
                                    _builder.append("().add(");
                                    _builder.append(lt_1, "\t");
                                    _builder.append(".valueOf(");
                                    String _simpleAttributeValue_8 = this.simpleAttributeValue((SimpleValueProperty)l_1);
                                    _builder.append(_simpleAttributeValue_8, "\t");
                                    _builder.append("));");
                                    _builder.newLineIfNotEmpty();
                                }
                            } else {
                                _builder.append("\t");
                                _builder.append(name, "\t");
                                _builder.append(".get");
                                String _firstUpper_14 = StringExtensions.toFirstUpper((String)p_1.getName());
                                _builder.append(_firstUpper_14, "\t");
                                _builder.append("().add(");
                                String _simpleAttributeValue_9 = this.simpleAttributeValue((SimpleValueProperty)l_1);
                                _builder.append(_simpleAttributeValue_9, "\t");
                                _builder.append(");");
                                _builder.newLineIfNotEmpty();
                            }
                        } else if (l_1 instanceof ResourceValueProperty) {
                            _builder.append("\t");
                            _builder.append(name, "\t");
                            _builder.append(".get");
                            String _firstUpper_15 = StringExtensions.toFirstUpper((String)p_1.getName());
                            _builder.append(_firstUpper_15, "\t");
                            _builder.append("().add(resourceBundle.getString(\"");
                            String _value_35 = ((ResourceValueProperty)l_1).getValue().getValue();
                            _builder.append(_value_35, "\t");
                            _builder.append("\"));");
                            _builder.newLineIfNotEmpty();
                        } else if (l_1 instanceof LocationValueProperty) {
                            _builder.append("\t");
                            _builder.append(name, "\t");
                            _builder.append(".get");
                            String _firstUpper_16 = StringExtensions.toFirstUpper((String)p_1.getName());
                            _builder.append(_firstUpper_16, "\t");
                            _builder.append("().add(baseURL + \"/");
                            String _value_36 = ((LocationValueProperty)l_1).getValue();
                            _builder.append(_value_36, "\t");
                            _builder.append("\");");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("}");
                        _builder.newLine();
                    }
                    continue;
                }
                ValueProperty _value_37 = p_1.getValue();
                if (_value_37 instanceof LocationValueProperty) {
                    _builder.append(name);
                    _builder.append(".set");
                    String _firstUpper_17 = StringExtensions.toFirstUpper((String)p_1.getName());
                    _builder.append(_firstUpper_17);
                    _builder.append("(baseURL + \"/");
                    ValueProperty _value_38 = p_1.getValue();
                    String _value_39 = ((LocationValueProperty)_value_38).getValue();
                    _builder.append(_value_39);
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                    this.enableResourceUrl();
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                ValueProperty _value_40 = p_1.getValue();
                if (!(_value_40 instanceof ResourceValueProperty)) continue;
                _builder.append(name);
                _builder.append(".set");
                String _firstUpper_18 = StringExtensions.toFirstUpper((String)p_1.getName());
                _builder.append(_firstUpper_18);
                _builder.append("(resourceBundle.getString(\"");
                ValueProperty _value_41 = p_1.getValue();
                String _value_42 = ((ResourceValueProperty)_value_41).getValue().getValue();
                _builder.append(_value_42);
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
                this.enableResourceUrl();
                _builder.newLineIfNotEmpty();
            }
            EList _defaultChildren = element.getDefaultChildren();
            for (Element p_2 : _defaultChildren) {
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                int i_1 = this.getVarIndex();
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String varName_2 = "e_" + Integer.valueOf(i_1);
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _generateElementDef_2 = this.generateElementDef(varName_2, p_2);
                _builder.append((Object)_generateElementDef_2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _staticProperties_2 = this.staticProperties(varName_2, p_2);
                _builder.append((Object)_staticProperties_2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _staticCallProperties_2 = this.staticCallProperties(varName_2, p_2);
                _builder.append((Object)_staticCallProperties_2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                String _qualifiedName_6 = p_2.getType().getQualifiedName();
                boolean _equals_12 = Objects.equal((Object)"java.net.URL", (Object)_qualifiedName_6);
                if (_equals_12) {
                    _builder.append("\t");
                    _builder.append(name, "\t");
                    _builder.append(".get");
                    String _firstUpper_19 = StringExtensions.toFirstUpper((String)ReflectionHelper.defaultAttribute(element.getType()));
                    _builder.append(_firstUpper_19, "\t");
                    _builder.append("().add(");
                    _builder.append(varName_2, "\t");
                    _builder.append(".toExternalForm());");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append(name, "\t");
                    _builder.append(".get");
                    String _firstUpper_20 = StringExtensions.toFirstUpper((String)ReflectionHelper.defaultAttribute(element.getType()));
                    _builder.append(_firstUpper_20, "\t");
                    _builder.append("().add(");
                    _builder.append(varName_2, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("}");
                _builder.newLine();
            }
            if (!Objects.equal((Object)element.getName(), null) && this.hasController()) {
                CharSequence _controllerFieldAccess_1 = this.controllerFieldAccess(name, element);
                _builder.append((Object)_controllerFieldAccess_1);
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl = _notEquals_12 = !Objects.equal((Object)(_name_6 = element.getName()), null);
        if (_notEquals_12) {
            _builder.append("namespaceMap.put(\"");
            String _name_7 = element.getName();
            _builder.append(_name_7);
            _builder.append("\",");
            _builder.append(name);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence staticCallProperties(String name, Element element) {
        StringConcatenation _builder = new StringConcatenation();
        EList _staticCallProperties = element.getStaticCallProperties();
        for (StaticCallValueProperty prop : _staticCallProperties) {
            JvmTypeReference type = prop.getType();
            _builder.newLineIfNotEmpty();
            ValueProperty _value = prop.getValue();
            if (_value instanceof SimpleValueProperty) {
                boolean _notEquals;
                ValueProperty _value_1 = prop.getValue();
                String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    String enumType = ReflectionHelper.getEnumType(type, prop.getName(), true);
                    _builder.newLineIfNotEmpty();
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)enumType, null);
                    if (_notEquals_1) {
                        _builder.append("// an enum type");
                        _builder.newLine();
                        String _simpleName = type.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(".set");
                        String _firstUpper = StringExtensions.toFirstUpper((String)prop.getName());
                        _builder.append(_firstUpper);
                        _builder.append("(");
                        _builder.append(name);
                        _builder.append(",");
                        _builder.append(enumType);
                        _builder.append(".");
                        ValueProperty _value_2 = prop.getValue();
                        String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                        _builder.append(_stringValue_1);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("// a simple value");
                    _builder.newLine();
                    String _simpleName_1 = type.getSimpleName();
                    _builder.append(_simpleName_1);
                    _builder.append(".set");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)prop.getName());
                    _builder.append(_firstUpper_1);
                    _builder.append("(");
                    _builder.append(name);
                    _builder.append(",");
                    ValueProperty _value_3 = prop.getValue();
                    String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                    _builder.append(_simpleAttributeValue);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                String _simpleName_2 = type.getSimpleName();
                _builder.append(_simpleName_2);
                _builder.append(".set");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)prop.getName());
                _builder.append(_firstUpper_2);
                _builder.append("(");
                _builder.append(name);
                _builder.append(",");
                ValueProperty _value_4 = prop.getValue();
                String _simpleAttributeValue_1 = this.simpleAttributeValue((SimpleValueProperty)_value_4);
                _builder.append(_simpleAttributeValue_1);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_5 = prop.getValue();
            if (_value_5 instanceof ReferenceValueProperty) {
                String _simpleName_3 = type.getSimpleName();
                _builder.append(_simpleName_3);
                _builder.append(".set");
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)prop.getName());
                _builder.append(_firstUpper_3);
                _builder.append("(");
                _builder.append(name);
                _builder.append(",(");
                ValueProperty _value_6 = prop.getValue();
                ReferenceType _reference = ((ReferenceValueProperty)_value_6).getReference();
                String _qualifiedName = ((Element)_reference).getType().getQualifiedName();
                _builder.append(_qualifiedName);
                _builder.append(")namespaceMap.get(\"");
                ValueProperty _value_7 = prop.getValue();
                ReferenceType _reference_1 = ((ReferenceValueProperty)_value_7).getReference();
                String _name = ((Element)_reference_1).getName();
                _builder.append(_name);
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_8 = prop.getValue();
            if (!(_value_8 instanceof Element)) continue;
            int _varIndex = this.getVarIndex();
            String varname = "e_" + Integer.valueOf(_varIndex);
            _builder.newLineIfNotEmpty();
            ValueProperty _value_9 = prop.getValue();
            CharSequence _generateElementDef = this.generateElementDef(varname, (Element)_value_9);
            _builder.append((Object)_generateElementDef);
            _builder.newLineIfNotEmpty();
            String _simpleName_4 = type.getSimpleName();
            _builder.append(_simpleName_4);
            _builder.append(".set");
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)prop.getName());
            _builder.append(_firstUpper_4);
            _builder.append("(");
            _builder.append(name);
            _builder.append(",");
            _builder.append(varname);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence staticProperties(String name, Element element) {
        StringConcatenation _builder = new StringConcatenation();
        EList _staticProperties = element.getStaticProperties();
        for (StaticValueProperty prop : _staticProperties) {
            JvmTypeReference type = this.type(prop);
            _builder.newLineIfNotEmpty();
            ValueProperty _value = prop.getValue();
            if (_value instanceof SimpleValueProperty) {
                boolean _notEquals;
                ValueProperty _value_1 = prop.getValue();
                String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    String enumType = ReflectionHelper.getEnumType(type, prop.getName(), true);
                    _builder.newLineIfNotEmpty();
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)enumType, null);
                    if (_notEquals_1) {
                        String _simpleName = type.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(".set");
                        String _firstUpper = StringExtensions.toFirstUpper((String)prop.getName());
                        _builder.append(_firstUpper);
                        _builder.append("(");
                        _builder.append(name);
                        _builder.append(",");
                        _builder.append(enumType);
                        _builder.append(".");
                        ValueProperty _value_2 = prop.getValue();
                        String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                        _builder.append(_stringValue_1);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    String _simpleName_1 = type.getSimpleName();
                    _builder.append(_simpleName_1);
                    _builder.append(".set");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)prop.getName());
                    _builder.append(_firstUpper_1);
                    _builder.append("(");
                    _builder.append(name);
                    _builder.append(",");
                    ValueProperty _value_3 = prop.getValue();
                    String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                    _builder.append(_simpleAttributeValue);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                String _simpleName_2 = type.getSimpleName();
                _builder.append(_simpleName_2);
                _builder.append(".set");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)prop.getName());
                _builder.append(_firstUpper_2);
                _builder.append("(");
                _builder.append(name);
                _builder.append(",");
                ValueProperty _value_4 = prop.getValue();
                String _simpleAttributeValue_1 = this.simpleAttributeValue((SimpleValueProperty)_value_4);
                _builder.append(_simpleAttributeValue_1);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_5 = prop.getValue();
            if (_value_5 instanceof ReferenceValueProperty) {
                String _simpleName_3 = type.getSimpleName();
                _builder.append(_simpleName_3);
                _builder.append(".set");
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)prop.getName());
                _builder.append(_firstUpper_3);
                _builder.append("(");
                _builder.append(name);
                _builder.append(",((");
                ValueProperty _value_6 = prop.getValue();
                ReferenceType _reference = ((ReferenceValueProperty)_value_6).getReference();
                String _qualifiedName = ((Element)_reference).getType().getQualifiedName();
                _builder.append(_qualifiedName);
                _builder.append(")namespaceMap.get(\"");
                ValueProperty _value_7 = prop.getValue();
                ReferenceType _reference_1 = ((ReferenceValueProperty)_value_7).getReference();
                String _name = ((Element)_reference_1).getName();
                _builder.append(_name);
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_8 = prop.getValue();
            if (!(_value_8 instanceof Element)) continue;
            int _varIndex = this.getVarIndex();
            String varname = "e_" + Integer.valueOf(_varIndex);
            _builder.newLineIfNotEmpty();
            ValueProperty _value_9 = prop.getValue();
            CharSequence _generateElementDef = this.generateElementDef(varname, (Element)_value_9);
            _builder.append((Object)_generateElementDef);
            _builder.newLineIfNotEmpty();
            String _simpleName_4 = type.getSimpleName();
            _builder.append(_simpleName_4);
            _builder.append(".set");
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)prop.getName());
            _builder.append(_firstUpper_4);
            _builder.append("(");
            _builder.append(name);
            _builder.append(",");
            _builder.append(varname);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String simpleAttributeValue(SimpleValueProperty value) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        String _stringValue = value.getStringValue();
        boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
        if (_notEquals) {
            String _stringValue_1 = value.getStringValue();
            String _plus = "\"" + _stringValue_1;
            return String.valueOf(_plus) + "\"";
        }
        String _booleanValue = value.getBooleanValue();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_booleanValue, null);
        if (_notEquals_1) {
            return value.getBooleanValue();
        }
        String _number = value.getNumber();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_number, null);
        if (_notEquals_2) {
            boolean _isNegative = value.isNegative();
            if (_isNegative) {
                String _number_1 = value.getNumber();
                boolean _equals = Objects.equal((Object)_number_1, (Object)"-Infinity");
                if (_equals) {
                    return "Double.NEGATIVE_INFINITY";
                }
                String _number_2 = value.getNumber();
                return "-" + _number_2;
            }
            String _number_3 = value.getNumber();
            boolean _equals_1 = Objects.equal((Object)_number_3, (Object)"-Infinity");
            if (_equals_1) {
                return "Double.NEGATIVE_INFINITY";
            }
            String _number_4 = value.getNumber();
            boolean _equals_2 = Objects.equal((Object)_number_4, (Object)"Infinity");
            if (_equals_2) {
                return "Double.POSITIVE_INFINITY";
            }
            return value.getNumber();
        }
        return null;
    }

    public JvmTypeReference type(StaticValueProperty prop) {
        EObject el = prop.eContainer();
        while (!Objects.equal((Object)el.eContainer(), null)) {
            EObject _eContainer = el.eContainer();
            if (_eContainer instanceof Element) {
                EObject _eContainer_1 = el.eContainer();
                Element e = (Element)_eContainer_1;
                return e.getType();
            }
            el = el.eContainer();
        }
        return null;
    }

    public boolean onlyPrimitive(List<ListValueElement> list) {
        Functions.Function1<ListValueElement, Boolean> _function = new Functions.Function1<ListValueElement, Boolean>(){

            public Boolean apply(ListValueElement e) {
                return !(e instanceof SimpleValueProperty);
            }
        };
        ListValueElement _findFirst = (ListValueElement)IterableExtensions.findFirst(list, (Functions.Function1)_function);
        return Objects.equal((Object)_findFirst, null);
    }
}

