/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.util.emf.core.catalog.ICatalogManager;
import org.eclipse.emf.facet.util.emf.core.catalog.ICatalogManagerConfiguration;
import org.eclipse.emf.facet.util.emf.core.catalog.ICatalogManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationCatalogManager
implements ICustomizationCatalogManager {
    private final ICatalogManager catalogMgr;

    public CustomizationCatalogManager(ResourceSet resourceSet) {
        CatalogManagerConfiguration catalogMgrConfig = new CatalogManagerConfiguration();
        this.catalogMgr = ICatalogManagerFactory.DEFAULT.getOrCreateCatalogManager((ICatalogManagerConfiguration)catalogMgrConfig, resourceSet, this.getClass().getName());
    }

    public List<Customization> getCustomizationsByName(String name) {
        ArrayList<Customization> result = new ArrayList<Customization>();
        for (EObject eObject : this.catalogMgr.getInstalledEntries(EObject.class)) {
            if (eObject instanceof Customization) {
                Customization customization = (Customization)eObject;
                if (!name.equals(customization.getName())) continue;
                result.add(customization);
                continue;
            }
            throw new RuntimeException("Only customizations (and aggregates) must be stored in the customization catalog");
        }
        return result;
    }

    @Override
    public void registerCustomization(Customization customization) {
        this.catalogMgr.addWsEntry((EObject)customization);
    }

    @Override
    public List<Customization> getCustomizationsApplicableOn(Collection<EObject> eObjects) {
        return null;
    }

    @Override
    public List<Customization> getRegisteredCustomizations() {
        ArrayList<Customization> result = new ArrayList<Customization>();
        List installedEntries = this.catalogMgr.getInstalledEntries(EObject.class);
        for (EObject eObject : installedEntries) {
            if (eObject instanceof Customization) {
                Customization customization = (Customization)eObject;
                result.add(customization);
                continue;
            }
            throw new RuntimeException("Only customizations (and aggregates) must be stored in the customization catalog");
        }
        return Collections.unmodifiableList(result);
    }

    public class CatalogManagerConfiguration
    implements ICatalogManagerConfiguration {
        public boolean canBeManaged(EObject root) {
            return root instanceof Customization;
        }

        public boolean isValid(EObject root) {
            return true;
        }
    }
}

