/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ICompletionRequestorExtension;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.ui.text.completion.ScriptCompletionProposalFactoryRegistry;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProviderRegistry;
import org.eclipse.dltk.ui.text.completion.FieldProposalInfo;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalLabelProviderExtension;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalLabelProviderExtension2;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalFactory;
import org.eclipse.dltk.ui.text.completion.MethodProposalInfo;
import org.eclipse.dltk.ui.text.completion.ProposalContextInformation;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptMethodCompletionProposal;
import org.eclipse.dltk.ui.text.completion.TypeProposalInfo;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public abstract class ScriptCompletionProposalCollector
extends CompletionRequestor
implements ICompletionRequestorExtension {
    public static final String ATTR_PARAM_LIMIT = "org.eclipse.dltk.uiCompletionProposal#ParameterLimit";
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.dltk.ui/debug/ResultCollector"));
    private CompletionProposalLabelProvider fLabelProvider;
    private final ImageDescriptorRegistry fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();
    private final List<IScriptCompletionProposal> fScriptProposals = new ArrayList<IScriptCompletionProposal>();
    private final List<CompletionProposal> fUnprocessedCompletionProposals = new ArrayList<CompletionProposal>();
    private final List<IScriptCompletionProposal> fKeywords = new ArrayList<IScriptCompletionProposal>();
    private final Set<String> fSuggestedMethodNames = new HashSet<String>();
    private final ISourceModule fSourceModule;
    private final IScriptProject fScriptProject;
    private int fUserReplacementLength;
    private CompletionContext fContext;
    private IProblem fLastProblem;
    private long fStartTime;
    private ScriptContentAssistInvocationContext fInvocationContext;
    protected static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};
    private Map<Object, Object> attributes = null;

    public ScriptCompletionProposalCollector(ISourceModule cu) {
        this(cu.getScriptProject(), cu);
    }

    public ScriptCompletionProposalCollector(IScriptProject project) {
        this(project, null);
    }

    protected ScriptCompletionProposalCollector(IScriptProject project, ISourceModule cu) {
        this.fScriptProject = project;
        this.fSourceModule = cu;
        this.fUserReplacementLength = -1;
    }

    public void setInvocationContext(ScriptContentAssistInvocationContext context) {
        this.fInvocationContext = context;
        context.setCollector(this);
    }

    public final ScriptContentAssistInvocationContext getInvocationContext() {
        if (this.fInvocationContext == null) {
            this.setInvocationContext(this.createScriptContentAssistInvocationContext(this.getSourceModule()));
        }
        return this.fInvocationContext;
    }

    protected ScriptContentAssistInvocationContext createScriptContentAssistInvocationContext(ISourceModule sourceModule) {
        return new ScriptContentAssistInvocationContext(sourceModule, this.getNatureId());
    }

    public void accept(CompletionProposal proposal) {
        if (this.isFiltered(proposal)) {
            return;
        }
        this.doAccept(proposal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAccept(CompletionProposal proposal) {
        List<CompletionProposal> list = this.fUnprocessedCompletionProposals;
        synchronized (list) {
            this.fUnprocessedCompletionProposals.add(proposal);
        }
    }

    public void acceptContext(CompletionContext context) {
        this.fContext = context;
        this.getLabelProvider().setContext(context);
    }

    protected final CompletionProposalLabelProvider createLabelProvider() {
        return CompletionProposalLabelProviderRegistry.create(this.getNatureId());
    }

    public CompletionProposalLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = this.createLabelProvider();
        }
        return this.fLabelProvider;
    }

    public void completionFailure(IProblem problem) {
        this.fLastProblem = problem;
    }

    public String getErrorMessage() {
        if (this.fLastProblem != null) {
            return this.fLastProblem.getMessage();
        }
        return "";
    }

    public final IScriptCompletionProposal[] getScriptCompletionProposals() {
        this.processUnprocessedProposals();
        return this.fScriptProposals.toArray(new IScriptCompletionProposal[this.fScriptProposals.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnprocessedProposals() {
        CompletionProposal[] copy;
        long start = DEBUG ? System.currentTimeMillis() : 0L;
        List<CompletionProposal> list = this.fUnprocessedCompletionProposals;
        synchronized (list) {
            int size = this.fUnprocessedCompletionProposals.size();
            if (size == 0) {
                return;
            }
            copy = this.fUnprocessedCompletionProposals.toArray(new CompletionProposal[size]);
            this.fUnprocessedCompletionProposals.clear();
        }
        CompletionProposal[] completionProposalArray = copy;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            CompletionProposal proposal = completionProposalArray[n2];
            try {
                this.processUnprocessedProposal(proposal);
            }
            catch (IllegalArgumentException e) {
                DLTKUIPlugin.log((IStatus)new Status(4, DLTKUIPlugin.getPluginId(), 0, "Exception when processing proposal for: " + String.valueOf(proposal.getCompletion()), (Throwable)e));
            }
            ++n2;
        }
        if (DEBUG) {
            long UITime = System.currentTimeMillis() - start;
            System.err.println("Core Collector (ui):\t" + UITime);
        }
    }

    protected void processUnprocessedProposal(CompletionProposal proposal) {
        if (proposal.getKind() == 9) {
            this.acceptPotentialMethodDeclaration(proposal);
        } else {
            IScriptCompletionProposal scriptProposal;
            if (proposal.getKind() == 5 && !this.isContextInformationMode()) {
                String[] params = proposal.findParameterNames(null);
                Integer requiredParamCount = (Integer)proposal.getAttribute("org.eclipse.dltk.core.MethodCompletionProposal#ParameterLimit");
                if (params != null && requiredParamCount != null && params.length > requiredParamCount) {
                    int i = requiredParamCount;
                    while (i <= params.length) {
                        CompletionProposal copy = proposal.clone();
                        copy.setAttribute(ATTR_PARAM_LIMIT, (Object)i);
                        IScriptCompletionProposal scriptProposal2 = this.createScriptCompletionProposal(copy);
                        if (scriptProposal2 != null) {
                            this.addProposal(scriptProposal2, copy);
                        }
                        ++i;
                    }
                    return;
                }
            }
            if ((scriptProposal = this.createScriptCompletionProposal(proposal)) != null) {
                this.addProposal(scriptProposal, proposal);
            }
        }
    }

    protected void addProposal(IScriptCompletionProposal scriptProposal, CompletionProposal proposal) {
        this.fScriptProposals.add(scriptProposal);
        if (proposal.getKind() == 2) {
            this.fKeywords.add(scriptProposal);
        }
    }

    public final IScriptCompletionProposal[] getKeywordCompletionProposals() {
        this.processUnprocessedProposals();
        return this.fKeywords.toArray(new IScriptCompletionProposal[this.fKeywords.size()]);
    }

    public final void setReplacementLength(int length) {
        this.fUserReplacementLength = length;
    }

    public int computeRelevance(CompletionProposal proposal) {
        int baseRelevance = proposal.getRelevance() * 16;
        switch (proposal.getKind()) {
            case 3: {
                return baseRelevance + 0;
            }
            case 2: {
                return baseRelevance + 1;
            }
            case 11: {
                return baseRelevance + 2;
            }
            case 7: {
                return baseRelevance + 2;
            }
            case 5: 
            case 6: 
            case 10: {
                return baseRelevance + 3;
            }
            case 9: {
                return baseRelevance + 3;
            }
            case 1: {
                return baseRelevance + 4;
            }
            case 4: 
            case 8: {
                return baseRelevance + 5;
            }
        }
        return baseRelevance;
    }

    protected IScriptCompletionProposal createScriptCompletionProposal(CompletionProposal proposal) {
        IScriptCompletionProposalFactory[] factories = ScriptCompletionProposalFactoryRegistry.getFactories(this.getNatureId());
        if (factories != null) {
            IScriptCompletionProposalFactory[] iScriptCompletionProposalFactoryArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                IScriptCompletionProposalFactory factory = iScriptCompletionProposalFactoryArray[n2];
                IScriptCompletionProposal scriptProposal = factory.create(this, proposal);
                if (scriptProposal != null) {
                    return scriptProposal;
                }
                ++n2;
            }
        }
        switch (proposal.getKind()) {
            case 2: {
                return this.createKeywordProposal(proposal);
            }
            case 11: {
                return this.createPackageProposal(proposal);
            }
            case 7: {
                return this.createTypeProposal(proposal);
            }
            case 1: {
                return this.createFieldProposal(proposal);
            }
            case 5: 
            case 10: {
                return this.createMethodReferenceProposal0(proposal);
            }
            case 6: {
                return this.createMethodDeclarationProposal(proposal);
            }
            case 3: {
                return this.createLabelProposal(proposal);
            }
            case 4: 
            case 8: {
                return this.createLocalVariableProposal(proposal);
            }
        }
        return new ScriptCompletionProposal(proposal.getCompletion(), proposal.getReplaceStart(), proposal.getReplaceEnd() - proposal.getReplaceStart(), null, proposal.getName(), proposal.getRelevance());
    }

    protected final IContextInformation createMethodContextInformation(CompletionProposal methodProposal) {
        Assert.isTrue((methodProposal.getKind() == 5 ? 1 : 0) != 0);
        return new ProposalContextInformation(methodProposal);
    }

    public final ISourceModule getSourceModule() {
        return this.fSourceModule;
    }

    protected final CompletionContext getContext() {
        return this.fContext;
    }

    public final Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : this.fRegistry.get(descriptor);
    }

    protected final int getLength(CompletionProposal proposal) {
        int length;
        int start = proposal.getReplaceStart();
        int end = proposal.getReplaceEnd();
        if (this.fUserReplacementLength == -1) {
            length = end - start;
        } else {
            length = this.fUserReplacementLength;
            int behindCompletion = proposal.getCompletionLocation();
            if (start < behindCompletion) {
                length += behindCompletion - start;
            }
        }
        return length;
    }

    protected boolean isFiltered(CompletionProposal proposal) {
        if (this.isIgnored(proposal.getKind())) {
            return true;
        }
        int value = this.evaluateFilters(proposal);
        if (value == -1000) {
            return true;
        }
        if (value == -50) {
            return true;
        }
        if (value != 0) {
            proposal.setRelevance(proposal.getRelevance() + value);
        }
        return false;
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal proposal) {
        if (this.fSourceModule == null) {
            return;
        }
        try {
            IType type;
            IModelElement element = this.fSourceModule.getElementAt(proposal.getCompletionLocation());
            if (element != null && (type = (IType)element.getAncestor(7)) != null && DLTKCore.DEBUG) {
                System.out.println("TODO: Add method completion proposal support here...");
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
        }
    }

    protected abstract String getNatureId();

    @Deprecated
    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int relevance) {
        return this.createScriptCompletionProposal(completion, replaceStart, length, image, displayString, relevance, false);
    }

    @Deprecated
    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int relevance, boolean isInDoc) {
        return new ScriptCompletionProposal(completion, replaceStart, length, image, displayString, relevance, isInDoc);
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, StyledString displayString, int relevance, boolean isInDoc) {
        return new ScriptCompletionProposal(completion, replaceStart, length, image, displayString, relevance, isInDoc);
    }

    @Deprecated
    protected ScriptCompletionProposal createOverrideCompletionProposal(IScriptProject scriptProject, ISourceModule compilationUnit, String name, String[] paramTypes, int start, int length, String label, String string) {
        return null;
    }

    protected ScriptCompletionProposal createOverrideCompletionProposal(IScriptProject scriptProject, ISourceModule compilationUnit, String name, String[] paramTypes, int start, int length, StyledString label, String string) {
        return null;
    }

    protected IScriptCompletionProposal createFieldProposal(CompletionProposal proposal) {
        ScriptCompletionProposal scriptProposal;
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        int relevance = this.computeRelevance(proposal);
        CompletionProposalLabelProvider labelProvider = this.getLabelProvider();
        Image image = this.getImage(this.getLabelProvider().createFieldImageDescriptor(proposal));
        if (labelProvider instanceof ICompletionProposalLabelProviderExtension) {
            StyledString label = ((ICompletionProposalLabelProviderExtension)((Object)this.getLabelProvider())).createStyledFieldProposalLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        } else {
            String label = this.getLabelProvider().createFieldProposalLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        }
        if (this.fScriptProject != null) {
            scriptProposal.setProposalInfo(new FieldProposalInfo(this.fScriptProject, proposal));
        }
        scriptProposal.setTriggerCharacters(this.getVarTrigger());
        return scriptProposal;
    }

    protected IScriptCompletionProposal createKeywordProposal(CompletionProposal proposal) {
        ScriptCompletionProposal scriptProposal;
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        int relevance = this.computeRelevance(proposal);
        CompletionProposalLabelProvider labelProvider = this.getLabelProvider();
        Image image = this.getImage(this.getLabelProvider().createImageDescriptor(proposal));
        if (labelProvider instanceof ICompletionProposalLabelProviderExtension) {
            StyledString label = ((ICompletionProposalLabelProviderExtension)((Object)this.getLabelProvider())).createStyledKeywordLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        } else {
            String label = this.getLabelProvider().createKeywordLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        }
        if (this.fScriptProject != null) {
            scriptProposal.setProposalInfo(new ProposalInfo(this.fScriptProject, proposal.getName()));
        }
        return scriptProposal;
    }

    protected IScriptCompletionProposal createPackageProposal(CompletionProposal proposal) {
        ScriptCompletionProposal scriptProposal;
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        int relevance = this.computeRelevance(proposal);
        CompletionProposalLabelProvider labelProvider = this.getLabelProvider();
        Image image = this.getImage(this.getLabelProvider().createImageDescriptor(proposal));
        if (labelProvider instanceof ICompletionProposalLabelProviderExtension) {
            StyledString label = ((ICompletionProposalLabelProviderExtension)((Object)this.getLabelProvider())).createStyledSimpleLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        } else {
            String label = this.getLabelProvider().createSimpleLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        }
        return scriptProposal;
    }

    private IScriptCompletionProposal createLabelProposal(CompletionProposal proposal) {
        ScriptCompletionProposal scriptProposal;
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        int relevance = this.computeRelevance(proposal);
        CompletionProposalLabelProvider labelProvider = this.getLabelProvider();
        if (labelProvider instanceof ICompletionProposalLabelProviderExtension) {
            StyledString label = ((ICompletionProposalLabelProviderExtension)((Object)this.getLabelProvider())).createStyledSimpleLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, null, label, relevance, false);
        } else {
            String label = this.getLabelProvider().createSimpleLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, null, label, relevance, false);
        }
        return scriptProposal;
    }

    private IScriptCompletionProposal createLocalVariableProposal(CompletionProposal proposal) {
        ScriptCompletionProposal scriptProposal;
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        int relevance = this.computeRelevance(proposal);
        CompletionProposalLabelProvider labelProvider = this.getLabelProvider();
        Image image = this.getImage(this.getLabelProvider().createLocalImageDescriptor(proposal));
        if (labelProvider instanceof ICompletionProposalLabelProviderExtension) {
            StyledString label = ((ICompletionProposalLabelProviderExtension)((Object)this.getLabelProvider())).createStyledSimpleLabelWithType(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        } else {
            String label = this.getLabelProvider().createSimpleLabelWithType(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        }
        scriptProposal.setTriggerCharacters(this.getVarTrigger());
        return scriptProposal;
    }

    protected char[] getVarTrigger() {
        return VAR_TRIGGER;
    }

    private IScriptCompletionProposal createMethodDeclarationProposal(CompletionProposal proposal) {
        ScriptCompletionProposal scriptProposal;
        String label;
        if (this.fSourceModule == null || this.fScriptProject == null) {
            return null;
        }
        String name = proposal.getName();
        String[] paramTypes = CharOperation.NO_STRINGS;
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        CompletionProposalLabelProvider labelProvider = this.getLabelProvider();
        if (labelProvider instanceof ICompletionProposalLabelProviderExtension2) {
            label = ((ICompletionProposalLabelProviderExtension2)((Object)labelProvider)).createStyledOverrideMethodProposalLabel(proposal);
            scriptProposal = this.createOverrideCompletionProposal(this.fScriptProject, this.fSourceModule, name, paramTypes, start, length, (StyledString)label, String.valueOf(proposal.getCompletion()));
        } else {
            label = labelProvider.createOverrideMethodProposalLabel(proposal);
            scriptProposal = this.createOverrideCompletionProposal(this.fScriptProject, this.fSourceModule, name, paramTypes, start, length, label, String.valueOf(proposal.getCompletion()));
        }
        if (scriptProposal == null) {
            return null;
        }
        scriptProposal.setImage(this.getImage(this.getLabelProvider().createMethodImageDescriptor(proposal)));
        MethodProposalInfo info = new MethodProposalInfo(this.fScriptProject, proposal);
        scriptProposal.setProposalInfo(info);
        scriptProposal.setRelevance(this.computeRelevance(proposal));
        this.fSuggestedMethodNames.add(name);
        return scriptProposal;
    }

    private IScriptCompletionProposal createMethodReferenceProposal0(CompletionProposal methodProposal) {
        IScriptCompletionProposal proposal = this.createMethodReferenceProposal(methodProposal);
        if (proposal instanceof AbstractScriptCompletionProposal) {
            this.adaptLength((AbstractScriptCompletionProposal)proposal, methodProposal);
        }
        return proposal;
    }

    protected IScriptCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        return new ScriptMethodCompletionProposal(methodProposal, this.getInvocationContext());
    }

    private void adaptLength(AbstractScriptCompletionProposal proposal, CompletionProposal coreProposal) {
        if (this.fUserReplacementLength != -1) {
            proposal.setReplacementLength(this.getLength(coreProposal));
        }
    }

    protected IScriptCompletionProposal createTypeProposal(CompletionProposal proposal) {
        ScriptCompletionProposal scriptProposal;
        String completion = proposal.getCompletion();
        int start = proposal.getReplaceStart();
        int length = proposal.getReplaceEnd() - proposal.getReplaceStart();
        int relevance = this.computeRelevance(proposal);
        CompletionProposalLabelProvider labelProvider = this.getLabelProvider();
        Image image = this.getImage(this.getLabelProvider().createTypeImageDescriptor(proposal));
        if (labelProvider instanceof ICompletionProposalLabelProviderExtension) {
            StyledString label = ((ICompletionProposalLabelProviderExtension)((Object)this.getLabelProvider())).createStyledTypeProposalLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        } else {
            String label = this.getLabelProvider().createTypeProposalLabel(proposal);
            scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        }
        scriptProposal.setProposalInfo(new TypeProposalInfo(this.fScriptProject, proposal));
        return scriptProposal;
    }

    public boolean isContextInformationMode() {
        return this.fInvocationContext != null && this.fInvocationContext.isContextInformationMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<CompletionProposal> list = this.fUnprocessedCompletionProposals;
        synchronized (list) {
            this.fUnprocessedCompletionProposals.clear();
        }
        this.fScriptProposals.clear();
        this.fKeywords.clear();
        this.fSuggestedMethodNames.clear();
    }

    public IScriptProject getScriptProject() {
        return this.fScriptProject;
    }

    public Object getAttribute(Object key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public void setAttribute(Object key, Object value) {
        if (value == null) {
            if (this.attributes != null) {
                this.attributes.remove(value);
            }
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<Object, Object>();
            }
            this.attributes.put(key, value);
        }
    }

    void startCompletion() {
        if (DEBUG) {
            this.fStartTime = System.currentTimeMillis();
        }
    }

    void endCompletion() {
        if (DEBUG) {
            long total = System.currentTimeMillis() - this.fStartTime;
            System.err.println("Core Collector (core):\t" + total);
        }
    }
}

