/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.debug.application;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.cdt.internal.debug.application.BuildOptionsParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugAttachedExecutable {
    private static final String GCC_BUILTIN_PROVIDER_ID = "org.eclipse.cdt.managedbuilder.core.GCCBuiltinSpecsDetector";
    private static final String GCC_COMPILE_OPTIONS_PROVIDER_ID = "org.eclipse.cdt.debug.application.DwarfLanguageSettingsProvider";
    private static final String GCC_BUILD_OPTIONS_PROVIDER_ID = "org.eclipse.cdt.managedbuilder.core.GCCBuildCommandParser";
    private static final String DEBUG_PROJECT_ID = "org.eclipse.cdt.debug";

    public static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private static IProject createCProjectForExecutable(String projectName) throws OperationCanceledException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject newProjectHandle = workspace.getRoot().getProject(projectName);
        int projectSuffix = 2;
        while (newProjectHandle.exists()) {
            newProjectHandle = workspace.getRoot().getProject(String.valueOf(projectName) + projectSuffix);
            ++projectSuffix;
        }
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(null);
        IProject newProject = CCorePlugin.getDefault().createCProject(description, newProjectHandle, null, DEBUG_PROJECT_ID);
        return newProject;
    }

    public static ILaunchConfiguration createLaunchConfig(IProgressMonitor monitor, String buildLog) throws CoreException, InterruptedException {
        return DebugAttachedExecutable.createLaunchConfig(monitor, buildLog, null);
    }

    public static ILaunchConfiguration createLaunchConfig(IProgressMonitor monitor, String buildLog, String pid) throws CoreException, InterruptedException {
        IWorkbenchPage activePage;
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench;
        File f;
        ILaunchConfiguration config = null;
        String defaultProjectName = "Executables";
        IProject project = DebugAttachedExecutable.createCProjectForExecutable(defaultProjectName);
        monitor.worked(3);
        File buildLogFile = null;
        ICProjectDescriptionManager projDescManager = CCorePlugin.getDefault().getProjectDescriptionManager();
        ICProjectDescription projectDescription = projDescManager.getProjectDescription(project, 4);
        monitor.subTask(Messages.SetLanguageProviders);
        ICConfigurationDescription ccd = projectDescription.getActiveConfiguration();
        String[] langProviderIds = ((ILanguageSettingsProvidersKeeper)ccd).getDefaultLanguageSettingsProvidersIds();
        boolean found = false;
        int i = 0;
        while (i < langProviderIds.length) {
            if (langProviderIds[i].equals(GCC_BUILTIN_PROVIDER_ID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            langProviderIds = Arrays.copyOf(langProviderIds, langProviderIds.length + 1);
            langProviderIds[langProviderIds.length - 1] = GCC_BUILTIN_PROVIDER_ID;
        }
        found = false;
        i = 0;
        while (i < langProviderIds.length) {
            if (langProviderIds[i].equals(GCC_COMPILE_OPTIONS_PROVIDER_ID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            langProviderIds = Arrays.copyOf(langProviderIds, langProviderIds.length + 1);
            langProviderIds[langProviderIds.length - 1] = GCC_COMPILE_OPTIONS_PROVIDER_ID;
        }
        if (buildLog != null && (f = new File(buildLog)).exists()) {
            buildLogFile = f;
            found = false;
            int i2 = 0;
            while (i2 < langProviderIds.length) {
                if (langProviderIds[i2].equals(GCC_BUILD_OPTIONS_PROVIDER_ID)) {
                    found = true;
                    break;
                }
                ++i2;
            }
            if (!found) {
                langProviderIds = Arrays.copyOf(langProviderIds, langProviderIds.length + 1);
                langProviderIds[langProviderIds.length - 1] = GCC_BUILD_OPTIONS_PROVIDER_ID;
            }
        }
        List providers = LanguageSettingsManager.createLanguageSettingsProviders((String[])langProviderIds);
        ((ILanguageSettingsProvidersKeeper)ccd).setLanguageSettingProviders(providers);
        monitor.worked(1);
        projDescManager.setProjectDescription(project, projectDescription);
        ICProjectDescription projDescReadOnly = projDescManager.getProjectDescription(project, false);
        LanguageSettingsManager.serializeLanguageSettings((ICProjectDescription)projDescReadOnly);
        monitor.worked(1);
        if (buildLogFile != null) {
            project.getWorkspace().run((IWorkspaceRunnable)new BuildOptionsParser(project, buildLogFile), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        if ((workbench = PlatformUI.getWorkbench()) != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null) {
            activePage.closeAllEditors(false);
        }
        config = DebugAttachedExecutable.createConfiguration(pid, true);
        monitor.worked(1);
        return config;
    }

    protected static ILaunchConfigurationType getLaunchConfigType() {
        return DebugAttachedExecutable.getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.attachLaunchType");
    }

    protected static ILaunchConfiguration createConfiguration(boolean save) {
        return DebugAttachedExecutable.createConfiguration(null, save);
    }

    protected static ILaunchConfiguration createConfiguration(String pid, boolean save) {
        Object config = null;
        try {
            ILaunchConfigurationType configType = DebugAttachedExecutable.getLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugAttachedExecutable.getLaunchManager().generateLaunchConfigurationName("CDT_DBG_ATTACH"));
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "Executables");
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            if (pid != null) {
                wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", Integer.valueOf(pid).intValue());
            }
            config = save ? wc.doSave() : wc;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }
}

