/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.selection;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.events.IAncestorListener;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineSelectionEditPolicy
extends SelectionEditPolicy {
    private final Color m_lineColor;
    private Figure m_selectionFigure;
    private IAncestorListener m_ancestorListener;

    public LineSelectionEditPolicy() {
        this(IColorConstants.orange);
    }

    public LineSelectionEditPolicy(Color lineColor) {
        this.m_lineColor = lineColor;
    }

    @Override
    protected List<Handle> createSelectionHandles() {
        return Collections.emptyList();
    }

    @Override
    protected void showSelection() {
        this.hideSelection();
        this.m_selectionFigure = new Figure();
        this.m_selectionFigure.setBorder(new LineBorder(this.m_lineColor));
        this.updateFeedbackBounds();
        this.m_ancestorListener = new IAncestorListener(){

            public void ancestorMoved(Figure ancestor) {
                LineSelectionEditPolicy.this.updateFeedbackBounds();
            }
        };
        this.getHostFigure().addAncestorListener(this.m_ancestorListener);
        this.addFeedback(this.m_selectionFigure);
    }

    @Override
    protected void hideSelection() {
        if (this.m_selectionFigure != null) {
            this.getHostFigure().removeAncestorListener(this.m_ancestorListener);
            this.removeFeedback(this.m_selectionFigure);
            this.m_selectionFigure = null;
        }
    }

    private void updateFeedbackBounds() {
        Rectangle selectionBounds = this.getHostBounds().getExpanded(1, 1);
        FigureUtils.translateFigureToFigure(this.getHostFigure(), this.m_selectionFigure, selectionBounds);
        this.m_selectionFigure.setBounds(selectionBounds);
    }

    protected Rectangle getHostBounds() {
        return this.getHostFigure().getBounds();
    }
}

