/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.Pair;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryAddCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryEditCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryMoveCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryRemoveCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.Command;
import org.eclipse.wb.internal.core.xml.editor.palette.command.ComponentAddCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.ComponentEditCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.ElementVisibilityCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.EntryMoveCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.EntryRemoveCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.model.AttributesProvider;
import org.eclipse.wb.internal.core.xml.editor.palette.model.AttributesProviders;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.ComponentEntryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.EntryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PaletteManager {
    private final XmlObjectInfo m_rootObject;
    private final EditorContext m_context;
    private final ClassLoader m_classLoader;
    private final IJavaProject m_javaProject;
    private final IProject m_project;
    private final String m_toolkitId;
    private PaletteInfo m_paletteInfo;
    private static final List<Class<? extends Command>> m_commandClasses = Lists.newArrayList();
    private static final Map<String, Class<? extends Command>> m_idToCommandClass;
    private List<Command> m_commands;
    private final Set<Pair<String, String>> m_categoryReorderRequests = Sets.newHashSet();

    static {
        m_commandClasses.add(ElementVisibilityCommand.class);
        m_commandClasses.add(CategoryAddCommand.class);
        m_commandClasses.add(CategoryEditCommand.class);
        m_commandClasses.add(CategoryMoveCommand.class);
        m_commandClasses.add(CategoryRemoveCommand.class);
        m_commandClasses.add(EntryMoveCommand.class);
        m_commandClasses.add(EntryRemoveCommand.class);
        m_commandClasses.add(ComponentAddCommand.class);
        m_commandClasses.add(ComponentEditCommand.class);
        m_idToCommandClass = Maps.newTreeMap();
    }

    public PaletteManager(XmlObjectInfo rootObject, String toolkitId) {
        this.m_rootObject = rootObject;
        this.m_context = rootObject.getContext();
        this.m_classLoader = this.m_context.getClassLoader();
        this.m_javaProject = this.m_context.getJavaProject();
        this.m_project = this.m_javaProject.getProject();
        this.m_toolkitId = toolkitId;
    }

    public String getToolkitId() {
        return this.m_toolkitId;
    }

    public PaletteInfo getPalette() {
        return this.m_paletteInfo;
    }

    public PaletteInfo getPaletteCopy() {
        PaletteManager manager = new PaletteManager(this.m_rootObject, this.m_toolkitId);
        manager.reloadPalette();
        return manager.getPalette();
    }

    public void reloadPalette() {
        this.m_paletteInfo = new PaletteInfo();
        if (this.m_toolkitId != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    PaletteManager.this.parseExtensionPalette();
                    PaletteManager.this.parseCustomPalette();
                    PaletteManager.this.processReorderRequests();
                    PaletteManager.this.commands_apply();
                }
            });
        }
    }

    public void exportTo(String path) throws Exception {
        File commandsFile = this.commands_getFile();
        FileUtils.copyFile((File)commandsFile, (File)new File(path));
    }

    public void importFrom(String path) throws Exception {
        File commandsFile = this.commands_getFile();
        FileUtils.copyFile((File)new File(path), (File)commandsFile);
    }

    private void commands_apply() throws Exception {
        if (m_idToCommandClass.isEmpty()) {
            for (Class<? extends Command> commandClass : m_commandClasses) {
                String id = (String)commandClass.getField("ID").get(null);
                m_idToCommandClass.put(id, commandClass);
            }
        }
        this.commandsRead();
    }

    private void commandsRead() throws Exception {
        this.m_commands = Lists.newArrayList();
        String commandsPath = "wbp-meta/" + this.m_toolkitId + ".wbp-palette-commands.xml";
        Enumeration<URL> resources = this.m_classLoader.getResources(commandsPath);
        while (resources.hasMoreElements()) {
            InputStream inputStream = resources.nextElement().openStream();
            this.commandsRead_fromStream(inputStream);
        }
        File commandsFile = this.commands_getFile();
        if (commandsFile.exists()) {
            FileInputStream inputStream = new FileInputStream(commandsFile);
            this.commandsRead_fromStream(inputStream);
        }
    }

    private void commandsRead_fromStream(final InputStream inputStream) throws Exception {
        try {
            ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    PaletteManager.this.commandsRead_fromStream0(inputStream);
                }
            });
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void commandsRead_fromStream0(InputStream inputStream) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(inputStream, new DefaultHandler(){

            public void startElement(String uri, String localName, final String name, final Attributes attributes) {
                ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        PaletteManager.this.commandsRead_singleCommand(name, attributes);
                    }
                });
            }
        });
    }

    private void commandsRead_singleCommand(String name, Attributes attributes) throws Exception {
        Class<? extends Command> commandClass = m_idToCommandClass.get(name);
        if (commandClass == null) {
            return;
        }
        Constructor<? extends Command> constructor = commandClass.getConstructor(Attributes.class);
        Command command = constructor.newInstance(attributes);
        this.commands_add(command);
    }

    public void commands_clear() {
        this.m_commands.clear();
    }

    public void commands_add(final Command command) {
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                command.execute(PaletteManager.this.m_paletteInfo);
                command.addToCommandList(PaletteManager.this.m_commands);
            }
        });
    }

    public void commands_write() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                File commandsFile = PaletteManager.this.commands_getFile();
                PrintWriter writer = new PrintWriter(new FileOutputStream(commandsFile));
                try {
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    writer.println("<commands>");
                    for (Command command : PaletteManager.this.m_commands) {
                        writer.println(command.toString());
                    }
                    writer.println("</commands>");
                }
                finally {
                    writer.close();
                }
                PaletteManager.this.m_project.getFolder("wbp-meta").refreshLocal(2, null);
            }
        });
    }

    private File commands_getFile() throws Exception {
        Path commandsFilePath = new Path("wbp-meta/" + this.m_toolkitId + ".wbp-palette-commands.xml");
        IFile commandsFile = this.m_project.getFile((IPath)commandsFilePath);
        if (commandsFile.exists()) {
            return commandsFile.getLocation().toFile();
        }
        File stateDirectory = DesignerPlugin.getDefault().getStateLocation().toFile();
        File palettesDirectory = new File(stateDirectory, "palettes");
        FileUtils.forceMkdir((File)palettesDirectory);
        return new File(palettesDirectory, String.valueOf(this.m_toolkitId) + ".commands");
    }

    private void parseExtensionPalette() {
        int n;
        ArrayList paletteElements = Lists.newArrayList();
        for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements((String)this.m_toolkitId)) {
            IConfigurationElement[] iConfigurationElementArray = toolkitElement.getChildren("palette");
            n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement paletteElement = iConfigurationElementArray[n2];
                if (this.isConditionTrue(paletteElement)) {
                    paletteElements.add(paletteElement);
                }
                ++n2;
            }
        }
        for (IConfigurationElement paletteElement : paletteElements) {
            IConfigurationElement[] categoryElements;
            IConfigurationElement[] iConfigurationElementArray = categoryElements = paletteElement.getChildren("category");
            int n3 = categoryElements.length;
            n = 0;
            while (n < n3) {
                IConfigurationElement categoryElement = iConfigurationElementArray[n];
                if (this.isConditionTrue(categoryElement)) {
                    this.processCategory(categoryElement);
                }
                ++n;
            }
        }
        for (IConfigurationElement paletteElement : paletteElements) {
            this.processPaletteChildren(this.m_paletteInfo, null, paletteElement);
        }
    }

    private void processCategory(IConfigurationElement categoryElement) {
        AttributesProvider attributesProvider = AttributesProviders.get(categoryElement);
        CategoryInfo categoryInfo = new CategoryInfo(attributesProvider);
        this.m_paletteInfo.addCategory(categoryInfo);
        this.addReorderRequest(categoryInfo, attributesProvider);
        this.processPaletteChildren(this.m_paletteInfo, categoryInfo, categoryElement);
    }

    private void addReorderRequest(CategoryInfo categoryInfo, AttributesProvider attributesProvider) {
        String nextCategoryId = attributesProvider.getAttribute("next");
        if (nextCategoryId != null) {
            this.m_categoryReorderRequests.add((Pair<String, String>)Pair.create((Object)categoryInfo.getId(), (Object)nextCategoryId));
        }
    }

    private void processReorderRequests() {
        for (Pair<String, String> reorder : this.m_categoryReorderRequests) {
            this.m_paletteInfo.moveCategory((String)reorder.getLeft(), (String)reorder.getRight());
        }
    }

    private void processPaletteChildren(PaletteInfo paletteInfo, CategoryInfo categoryInfo, IConfigurationElement parentElement) {
        IConfigurationElement[] iConfigurationElementArray = parentElement.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (!element.getName().equals("category")) {
                this.processCategoryChild(paletteInfo, categoryInfo, element);
            }
            ++n2;
        }
    }

    private void processCategoryChild(final PaletteInfo paletteInfo, final CategoryInfo _categoryInfo, final IConfigurationElement element) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                EntryInfo entryInfo;
                CategoryInfo categoryInfo = _categoryInfo;
                if (categoryInfo == null) {
                    String categoryId = element.getAttribute("category");
                    Assert.isNotNull((Object)categoryId, (String)"Element defined outside of category, so requires 'category' attribute.");
                    categoryInfo = paletteInfo.getCategory(categoryId);
                    Assert.isNotNull((Object)categoryInfo, (String)("No category with id '" + categoryId + "' found."));
                }
                if ("x-entry".equals(element.getName())) {
                    String name;
                    entryInfo = (EntryInfo)element.createExecutableExtension("class");
                    String id = element.getAttribute("id");
                    if (id != null) {
                        entryInfo.setId(id);
                    }
                    if ((name = element.getAttribute("name")) != null) {
                        entryInfo.setName(name);
                    }
                    categoryInfo.addEntry(entryInfo);
                }
                if ("component".equals(element.getName()) && PaletteManager.this.isConditionTrue(element)) {
                    entryInfo = new ComponentEntryInfo(categoryInfo, element);
                    categoryInfo.addEntry(entryInfo);
                }
            }
        });
    }

    private boolean isConditionTrue(IConfigurationElement element) {
        String condition = element.getAttribute("condition");
        if (condition == null) {
            return true;
        }
        HashMap variables = Maps.newHashMap();
        variables.put("rootModel", this.m_rootObject);
        variables.putAll(this.m_context.getVersions());
        Object result = ScriptUtils.evaluate((String)condition, (Map)variables);
        return result instanceof Boolean ? (Boolean)result : false;
    }

    private void parseCustomPalette() throws Exception {
        String palettePath = "wbp-meta/" + this.m_toolkitId + ".wbp-palette.xml";
        Enumeration<URL> resources = this.m_classLoader.getResources(palettePath);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            this.parseCustomPalette(url.openStream(), url.toString());
        }
        List files = ProjectUtils.findFiles((IJavaProject)this.m_javaProject, (String)palettePath);
        for (IFile file : files) {
            String sourceDescription = file.toString();
            try {
                this.parseCustomPalette(file.getContents(true), sourceDescription);
            }
            catch (Throwable e) {
                this.m_context.addWarning(new EditorWarning("Can not parse " + sourceDescription, e));
            }
        }
    }

    private void parseCustomPalette(InputStream inputStream, String sourceDescription) throws Exception {
        try {
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(inputStream, new DefaultHandler(){
                    private CategoryInfo m_category;

                    public void startElement(String uri, String localTag, String tag, Attributes attributes) throws SAXException {
                        if ("category".equals(tag)) {
                            AttributesProvider attributesProvider = AttributesProviders.get(attributes);
                            this.m_category = new CategoryInfo(attributesProvider);
                            PaletteManager.this.m_paletteInfo.addCategory(this.m_category);
                            PaletteManager.this.addReorderRequest(this.m_category, attributesProvider);
                        } else if ("component".equals(tag)) {
                            CategoryInfo category = this.getTargetCategory(attributes);
                            AttributesProvider attributesProvider = AttributesProviders.get(attributes);
                            ComponentEntryInfo component = new ComponentEntryInfo(category, attributesProvider);
                            category.addEntry(component);
                        }
                    }

                    private CategoryInfo getTargetCategory(Attributes attributes) {
                        CategoryInfo category = this.m_category;
                        if (category == null) {
                            String categoryId = attributes.getValue("category");
                            Assert.isNotNull((Object)categoryId, (String)"Element defined outside of category, so requires 'category' attribute.");
                            category = PaletteManager.this.m_paletteInfo.getCategory(categoryId);
                            Assert.isNotNull((Object)category, (String)("No category with id '" + categoryId + "' found."));
                        }
                        return category;
                    }

                    public void endElement(String uri, String localName, String tag) throws SAXException {
                        if ("category".equals(tag)) {
                            this.m_category = null;
                        }
                    }
                });
            }
            catch (Throwable e) {
                DesignerPlugin.log((String)("Exception during loading project palette: " + sourceDescription), (Throwable)e);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

