/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer;

import com.google.common.collect.Iterables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.viatra.query.tooling.ui.registry.QueryBackendRegistry;

public abstract class AbstractBackendSelectionControl
extends WorkbenchWindowControlContribution {
    private static Iterable<IQueryBackendFactory> getRegisteredQueryBackendImplementations() {
        return QueryBackendRegistry.getInstance().getAllKnownFactories();
    }

    public AbstractBackendSelectionControl() {
    }

    public AbstractBackendSelectionControl(String id) {
        super(id);
    }

    protected abstract QueryEvaluationHint getHints();

    protected abstract void setHints(QueryEvaluationHint var1);

    private void applyBackendSelection(IQueryBackendFactory backend) {
        QueryEvaluationHint oldHint = this.getHints();
        QueryEvaluationHint newHint = oldHint.overrideBy(new QueryEvaluationHint(null, backend));
        this.setHints(newHint);
    }

    protected Control createControl(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 2056);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IQueryBackendFactory) {
                    return DisplayUtil.getQueryBackendName((IQueryBackendFactory)element);
                }
                return super.getText(element);
            }
        });
        viewer.setInput((Object)Iterables.toArray(AbstractBackendSelectionControl.getRegisteredQueryBackendImplementations(), IQueryBackendFactory.class));
        IQueryBackendFactory queryBackendFactory = this.getHints().getQueryBackendFactory();
        viewer.setSelection((ISelection)(queryBackendFactory != null ? new StructuredSelection((Object)queryBackendFactory) : new StructuredSelection()));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                Object o;
                ISelection select = event.getSelection();
                if (select instanceof IStructuredSelection && (o = (selection = (IStructuredSelection)select).getFirstElement()) instanceof IQueryBackendFactory) {
                    AbstractBackendSelectionControl.this.applyBackendSelection((IQueryBackendFactory)o);
                }
            }
        });
        viewer.getControl().setToolTipText("Select query backend engine to be used on subsequent loads.");
        return viewer.getControl();
    }
}

