/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.base.api.IQueryResultSetter;
import org.eclipse.viatra.query.runtime.base.api.IQueryResultUpdateListener;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;

public abstract class QueryResultAssociativeStore<KeyType, ValueType> {
    protected static final String NOT_ALLOW_MODIFICATIONS = "Query result associative store does not allow modifications";
    private Logger logger;
    private Collection<IQueryResultUpdateListener<KeyType, ValueType>> listeners;
    private IQueryResultSetter<KeyType, ValueType> setter;

    protected Collection<IQueryResultUpdateListener<KeyType, ValueType>> getListeners() {
        return this.listeners;
    }

    protected void setListeners(Collection<IQueryResultUpdateListener<KeyType, ValueType>> listeners) {
        this.listeners = listeners;
    }

    protected IQueryResultSetter<KeyType, ValueType> getSetter() {
        return this.setter;
    }

    protected void setSetter(IQueryResultSetter<KeyType, ValueType> setter) {
        this.setter = setter;
    }

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected abstract Collection<Map.Entry<KeyType, ValueType>> getCacheEntries();

    public void addCallbackOnQueryResultUpdate(IQueryResultUpdateListener<KeyType, ValueType> listener, boolean fireNow) {
        if (this.listeners == null) {
            this.listeners = new HashSet<IQueryResultUpdateListener<KeyType, ValueType>>();
        }
        this.listeners.add(listener);
        if (fireNow) {
            for (Map.Entry<KeyType, ValueType> entry : this.getCacheEntries()) {
                this.sendNotificationToListener(Direction.INSERT, entry.getKey(), entry.getValue(), listener);
            }
        }
    }

    public void removeCallbackOnQueryResultUpdate(IQueryResultUpdateListener<KeyType, ValueType> listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void notifyListeners(Direction direction, KeyType key, ValueType value) {
        if (this.listeners != null) {
            for (IQueryResultUpdateListener<KeyType, ValueType> listener : this.listeners) {
                this.sendNotificationToListener(direction, key, value, listener);
            }
        }
    }

    private void sendNotificationToListener(Direction direction, KeyType key, ValueType value, IQueryResultUpdateListener<KeyType, ValueType> listener) {
        try {
            if (direction == Direction.INSERT) {
                listener.notifyPut(key, value);
            } else {
                listener.notifyRemove(key, value);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)String.format("The query result associative store encountered an error during executing a callback on %s of key %s and value %s. Error message: %s. (Developer note: %s in %s called from QueryResultMultimap)", direction == Direction.INSERT ? "insertion" : "removal", key, value, e.getMessage(), e.getClass().getSimpleName(), listener), (Throwable)e);
            throw new IllegalStateException("The query result associative store encountered an error during invoking setter", e);
        }
    }

    protected boolean internalPut(KeyType key, ValueType value) {
        boolean putResult = this.internalCachePut(key, value);
        if (putResult) {
            this.notifyListeners(Direction.INSERT, key, value);
        }
        return putResult;
    }

    protected boolean internalRemove(KeyType key, ValueType value) {
        boolean removeResult = this.internalCacheRemove(key, value);
        if (removeResult) {
            this.notifyListeners(Direction.DELETE, key, value);
        }
        return removeResult;
    }

    protected abstract boolean internalCachePut(KeyType var1, ValueType var2);

    protected abstract boolean internalCacheRemove(KeyType var1, ValueType var2);

    protected abstract int internalCacheSize();

    protected abstract boolean internalCacheContainsEntry(KeyType var1, ValueType var2);

    public void setQueryResultSetter(IQueryResultSetter<KeyType, ValueType> setter) {
        this.setter = setter;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected void internalClear() {
        if (this.setter == null) {
            throw new UnsupportedOperationException(NOT_ALLOW_MODIFICATIONS);
        }
        ArrayList entries = Lists.newArrayList(this.getCacheEntries());
        for (Map.Entry entry : entries) {
            this.modifyThroughQueryResultSetter(entry.getKey(), entry.getValue(), Direction.DELETE);
        }
        if (this.internalCacheSize() != 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<KeyType, ValueType> entry : this.getCacheEntries()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(entry.toString());
            }
            this.logger.warn((Object)String.format("The query result associative store is not empty after clear, remaining entries: %s. (Developer note: %s called from QueryResultMultimap)", sb.toString(), this.setter));
        }
    }

    protected boolean modifyThroughQueryResultSetter(KeyType key, ValueType value, Direction direction) {
        try {
            if (this.setter.validate(key, value)) {
                int size = this.internalCacheSize();
                int expectedChange = direction == Direction.INSERT ? 1 : -1;
                boolean changed = false;
                changed = direction == Direction.INSERT ? this.setter.put(key, value) : this.setter.remove(key, value);
                if (changed) {
                    return this.checkModificationThroughQueryResultSetter(key, value, direction, expectedChange, size);
                }
                this.logger.warn((Object)String.format("The query result associative store %s of key %s and value %s resulted in %s. (Developer note: %s called from QueryResultMultimap)", direction == Direction.INSERT ? "insertion" : "removal", key, value, Math.abs(this.internalCacheSize() - size) > 1 ? "more than one changed result" : "no changed results", this.setter));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)String.format("The query result associative store encountered an error during invoking setter on %s of key %s and value %s. Error message: %s. (Developer note: %s in %s called from QueryResultMultimap)", direction == Direction.INSERT ? "insertion" : "removal", key, value, e.getMessage(), e.getClass().getSimpleName(), this.setter), (Throwable)e);
            throw new IllegalStateException("The query result associative store encountered an error during invoking setter", e);
        }
        return false;
    }

    protected boolean checkModificationThroughQueryResultSetter(KeyType key, ValueType value, Direction direction, int expectedChange, int size) {
        boolean isInsertion;
        boolean bl = isInsertion = direction == Direction.INSERT;
        return isInsertion == this.internalCacheContainsEntry(key, value) && this.internalCacheSize() - expectedChange == size;
    }
}

