/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.NewExperimentOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.SelectTracesOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceFileSystemElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceValidateAndImportOperation;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.ide.dialogs.IElementFilter;
import org.eclipse.ui.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class ImportTraceWizardPage
extends WizardResourceImportPage {
    private static final String IMPORT_WIZARD_PAGE_NAME = "ImportTraceWizardPage";
    private static final String IMPORT_WIZARD_ROOT_DIRECTORY_ID = ".import_root_directory_id";
    private static final String IMPORT_WIZARD_ARCHIVE_FILE_NAME_ID = ".import_archive_file_name_id";
    private static final String IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID = ".import_unrecognized_traces_id";
    private static final String IMPORT_WIZARD_PRESERVE_FOLDERS_ID = ".import_preserve_folders_id";
    private static final String IMPORT_WIZARD_IMPORT_FROM_DIRECTORY_ID = ".import_from_directory";
    private static final String IMPORT_WIZARD_CREATE_EXPERIMENT_ID = ".create_experiment";
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz;*.gz", "*.*"};
    public static final String TRACE_TYPE_AUTO_DETECT = Messages.ImportTraceWizard_AutoDetection;
    public static final int OPTION_PRESERVE_FOLDER_STRUCTURE = 2;
    public static final int OPTION_CREATE_LINKS_IN_WORKSPACE = 4;
    public static final int OPTION_IMPORT_UNRECOGNIZED_TRACES = 8;
    public static final int OPTION_OVERWRITE_EXISTING_RESOURCES = 16;
    public static final int OPTION_CREATE_EXPERIMENT = 32;
    private TmfTraceFolder fTraceFolderElement;
    private TmfExperimentFolder fExperimentFolderElement;
    private String fPreviousSource;
    private Combo fTraceTypes;
    private Button fImportUnrecognizedButton;
    private Button fOverwriteExistingResourcesCheckbox;
    private Button fCreateLinksInWorkspaceButton;
    private Button fPreserveFolderStructureButton;
    private Button fCreateExperimentCheckbox;
    private Text fExperimentNameText;
    private boolean entryChanged = false;
    private Button fImportFromDirectoryRadio;
    private Button fImportFromArchiveRadio;
    private Boolean fPreviousCreateLinksValue = true;
    protected Combo fArchiveNameField;
    protected Button fArchiveBrowseButton;
    protected Combo directoryNameField;
    protected Button directoryBrowseButton;
    private ResourceTreeAndListGroup fSelectionGroup;
    private TraceFileSystemElement fSelectionGroupRoot;

    protected ImportTraceWizardPage(String name, IStructuredSelection selection) {
        super(name, selection);
        TmfProjectElement projectElement2;
        Object project;
        this.setTitle(Messages.ImportTraceWizard_FileSystemTitle);
        this.setDescription(Messages.ImportTraceWizard_ImportTrace);
        IFolder traceFolder = null;
        Object element = selection.getFirstElement();
        if (element instanceof TmfTraceFolder) {
            this.fTraceFolderElement = (TmfTraceFolder)element;
            traceFolder = this.fTraceFolderElement.getResource();
        } else if (element instanceof IProject) {
            project = (IProject)element;
            try {
                if (project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                    projectElement2 = TmfProjectRegistry.getProject((IProject)project, true);
                    this.fTraceFolderElement = projectElement2.getTracesFolder();
                    traceFolder = project.getFolder("Traces");
                }
            }
            catch (CoreException projectElement2) {
                // empty catch block
            }
        }
        if (traceFolder == null) {
            project = TmfProjectRegistry.createProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, (IProgressMonitor)new NullProgressMonitor());
            projectElement2 = TmfProjectRegistry.getProject((IProject)project, true);
            this.fTraceFolderElement = projectElement2.getTracesFolder();
            traceFolder = project.getFolder("Traces");
        }
        if (traceFolder != null) {
            String path = traceFolder.getFullPath().toString();
            this.setContainerFieldValue(path);
        }
        project = this.fTraceFolderElement.getProject();
        this.fExperimentFolderElement = ((TmfProjectElement)project).getExperimentsFolder();
    }

    public ImportTraceWizardPage(IStructuredSelection selection) {
        this(IMPORT_WIZARD_PAGE_NAME, selection);
    }

    protected void createFileSelectionGroup(Composite parent) {
        this.fSelectionGroup = new ResourceTreeAndListGroup(parent, (Object)new FileSystemElement("Dummy", null, true), this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode((Composite)parent));
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        };
        WorkbenchViewerComparator comparator = new WorkbenchViewerComparator();
        this.fSelectionGroup.setTreeComparator((ViewerComparator)comparator);
        this.fSelectionGroup.setListComparator((ViewerComparator)comparator);
        this.fSelectionGroup.addCheckStateListener(listener);
    }

    protected void createSourceGroup(Composite parent) {
        this.createSourceSelectionGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createTraceTypeGroup(parent);
        this.validateSourceGroup();
    }

    protected void createDestinationGroup(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        containerComposite.setLayout((Layout)new GridLayout(2, false));
        containerComposite.setLayoutData((Object)new GridData(768));
        Label destinationLabel = new Label(containerComposite, 0);
        destinationLabel.setText(IDEWorkbenchMessages.WizardImportPage_folder);
        Text containerText = new Text(containerComposite, 4);
        containerText.setLayoutData((Object)new GridData(768));
        containerText.setEnabled(false);
        containerText.setText(this.getContainerFullPath().toString());
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)object);
                    return element.getFiles().getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)o);
                    return element.getFolders().getChildren();
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected void createSourceSelectionGroup(Composite parent) {
        Composite sourceGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        sourceGroup.setLayout((Layout)layout);
        sourceGroup.setLayoutData((Object)new GridData(768));
        this.fImportFromDirectoryRadio = new Button(sourceGroup, 16);
        this.fImportFromDirectoryRadio.setText(Messages.ImportTraceWizard_DirectoryLocation);
        this.directoryNameField = this.createPathSelectionCombo(sourceGroup);
        this.createDirectoryBrowseButton(sourceGroup);
        this.fImportFromArchiveRadio = new Button(sourceGroup, 16);
        this.fImportFromArchiveRadio.setText(Messages.ImportTraceWizard_ArchiveLocation);
        this.fArchiveNameField = this.createPathSelectionCombo(sourceGroup);
        this.createArchiveBrowseButton(sourceGroup);
        this.fImportFromDirectoryRadio.setSelection(true);
        this.fArchiveNameField.setEnabled(false);
        this.fArchiveBrowseButton.setEnabled(false);
        this.fImportFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.directoryRadioSelected();
            }
        });
        this.fImportFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.archiveRadioSelected();
            }
        });
    }

    protected void setFileSelectionGroupChecked(boolean checked) {
        if (this.fSelectionGroup != null) {
            this.fSelectionGroup.setAllSelections(checked);
        }
    }

    protected Combo createPathSelectionCombo(Composite parent) {
        Combo pathSelectionCombo = new Combo(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = new PixelConverter((Control)pathSelectionCombo).convertWidthInCharsToPixels(25);
        pathSelectionCombo.setLayoutData((Object)layoutData);
        TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ImportTraceWizardPage.this.entryChanged = false;
                    ImportTraceWizardPage.this.updateFromSourceField();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ImportTraceWizardPage.this.entryChanged) {
                    ImportTraceWizardPage.this.entryChanged = false;
                    ImportTraceWizardPage.this.updateFromSourceField();
                }
            }
        };
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.entryChanged = false;
                ImportTraceWizardPage.this.updateFromSourceField();
            }
        };
        ModifyListener modifyListner = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportTraceWizardPage.this.entryChanged = true;
            }
        };
        pathSelectionCombo.addModifyListener(modifyListner);
        pathSelectionCombo.addTraverseListener(traverseListener);
        pathSelectionCombo.addFocusListener((FocusListener)focusAdapter);
        pathSelectionCombo.addSelectionListener((SelectionListener)selectionAdapter);
        return pathSelectionCombo;
    }

    protected void createDirectoryBrowseButton(Composite parent) {
        this.directoryBrowseButton = this.createPathSelectionBrowseButton(parent);
        this.directoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.handleSourceDirectoryBrowseButtonPressed();
            }
        });
    }

    protected void createArchiveBrowseButton(Composite parent) {
        this.fArchiveBrowseButton = this.createPathSelectionBrowseButton(parent);
        this.fArchiveBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.handleArchiveBrowseButtonPressed(FILE_IMPORT_MASK);
            }
        });
    }

    protected Button createPathSelectionBrowseButton(Composite parent) {
        Button pathSelectionBrowseButton = new Button(parent, 8);
        pathSelectionBrowseButton.setText(Messages.ImportTraceWizard_BrowseButton);
        this.setButtonLayoutData(pathSelectionBrowseButton);
        return pathSelectionBrowseButton;
    }

    private void archiveRadioSelected() {
        if (!this.isImportFromDirectory()) {
            this.directoryNameField.setEnabled(false);
            this.directoryBrowseButton.setEnabled(false);
            this.fArchiveNameField.setEnabled(true);
            this.fArchiveBrowseButton.setEnabled(true);
            this.updateFromSourceField();
            this.fArchiveNameField.setFocus();
            if (this.fCreateLinksInWorkspaceButton != null) {
                this.fPreviousCreateLinksValue = this.fCreateLinksInWorkspaceButton.getSelection();
                this.fCreateLinksInWorkspaceButton.setSelection(false);
                this.fCreateLinksInWorkspaceButton.setEnabled(false);
            }
        }
    }

    private void directoryRadioSelected() {
        if (this.isImportFromDirectory()) {
            this.directoryNameField.setEnabled(true);
            this.directoryBrowseButton.setEnabled(true);
            this.fArchiveNameField.setEnabled(false);
            this.fArchiveBrowseButton.setEnabled(false);
            this.updateFromSourceField();
            this.directoryNameField.setFocus();
            if (this.fCreateLinksInWorkspaceButton != null) {
                this.fCreateLinksInWorkspaceButton.setSelection(this.fPreviousCreateLinksValue.booleanValue());
                this.fCreateLinksInWorkspaceButton.setEnabled(true);
            }
        }
    }

    protected void handleSourceDirectoryBrowseButtonPressed() {
        String currentSource = this.directoryNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.directoryNameField.getShell(), 0x10002000);
        dialog.setText(Messages.ImportTraceWizard_SelectTraceDirectoryTitle);
        dialog.setMessage(Messages.ImportTraceWizard_SelectTraceDirectoryMessage);
        dialog.setFilterPath(ImportTraceWizardPage.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (ImportTraceWizardPage.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourcePath(selectedDirectory);
        }
    }

    protected void handleArchiveBrowseButtonPressed(String[] extensions) {
        String selectedArchive;
        File path;
        FileDialog dialog = TmfFileDialogFactory.create(this.fArchiveNameField.getShell(), 0x10000000);
        dialog.setFilterExtensions(extensions);
        dialog.setText(Messages.ImportTraceWizard_SelectTraceArchiveTitle);
        String fileName = this.fArchiveNameField.getText().trim();
        if (!fileName.isEmpty() && (path = new File(fileName).getParentFile()) != null && path.exists()) {
            dialog.setFilterPath(path.toString());
        }
        if ((selectedArchive = dialog.open()) != null) {
            this.setErrorMessage(null);
            this.setSourcePath(selectedArchive);
            this.updateWidgetEnablements();
        }
    }

    private File getSourceDirectory() {
        if (this.directoryNameField == null) {
            return null;
        }
        return ImportTraceWizardPage.getSourceDirectory(this.directoryNameField.getText());
    }

    private File getSourceArchiveFile() {
        if (this.fArchiveNameField == null) {
            return null;
        }
        return ImportTraceWizardPage.getSourceArchiveFile(this.fArchiveNameField.getText());
    }

    private String getSourceContainerPath() {
        File sourceDirectory;
        if (this.isImportFromDirectory() && (sourceDirectory = this.getSourceDirectory()) != null) {
            return sourceDirectory.getAbsolutePath();
        }
        File sourceArchiveFile = this.getSourceArchiveFile();
        if (sourceArchiveFile != null) {
            return sourceArchiveFile.getParent();
        }
        return null;
    }

    private static File getSourceDirectory(String path) {
        File sourceDirectory = new File(ImportTraceWizardPage.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private static File getSourceArchiveFile(String path) {
        File sourceArchiveFile = new File(path);
        if (!sourceArchiveFile.exists() || sourceArchiveFile.isDirectory()) {
            return null;
        }
        return sourceArchiveFile;
    }

    private static String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    private void updateFromSourceField() {
        this.setSourcePath(this.getSourceField().getText());
        this.updateWidgetEnablements();
    }

    private Combo getSourceField() {
        if (this.directoryNameField == null) {
            return this.fArchiveNameField;
        }
        return this.directoryNameField.isEnabled() ? this.directoryNameField : this.fArchiveNameField;
    }

    protected void setSourcePath(String path) {
        Combo sourceField = this.getSourceField();
        if (sourceField == null) {
            return;
        }
        if (path.length() > 0) {
            String[] currentItems = sourceField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                sourceField.setItems(newItems);
                selectionIndex = oldLength;
            }
            sourceField.select(selectionIndex);
        }
        this.resetSelection();
    }

    private void resetSelection() {
        File file;
        if (this.fSelectionGroupRoot != null) {
            this.disposeSelectionGroupRoot();
        }
        this.fSelectionGroupRoot = this.getFileSystemTree();
        this.fSelectionGroup.setRoot((Object)this.fSelectionGroupRoot);
        if (this.fCreateExperimentCheckbox != null && (file = this.getSourceFile()) != null) {
            String previousName = this.fExperimentNameText.getText().trim();
            if (this.fPreviousSource != null && previousName.equals(this.fPreviousSource) || previousName.isEmpty()) {
                this.fExperimentNameText.setText(file.getName());
            }
            this.fPreviousSource = file.getName();
        }
    }

    private void disposeSelectionGroupRoot() {
        if (this.fSelectionGroupRoot != null && this.fSelectionGroupRoot.getProvider() != null) {
            FileSystemObjectImportStructureProvider provider = this.fSelectionGroupRoot.getProvider();
            provider.dispose();
            this.fSelectionGroupRoot = null;
        }
    }

    private TraceFileSystemElement getFileSystemTree() {
        Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> rootObjectAndProvider = ArchiveUtil.getRootObjectAndProvider(this.getSourceFile(), this.getContainer().getShell());
        if (rootObjectAndProvider == null) {
            return null;
        }
        return this.selectFiles((IFileSystemObject)rootObjectAndProvider.getFirst(), (FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond());
    }

    private TraceFileSystemElement selectFiles(final IFileSystemObject rootFileSystemObject, final FileSystemObjectImportStructureProvider structureProvider) {
        final TraceFileSystemElement[] results = new TraceFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                results[0] = TraceFileSystemElement.createRootTraceFileElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    private final void createTraceTypeGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData buttonData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)buttonData);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(Messages.ImportTraceWizard_TraceType);
        typeLabel.setFont(parent.getFont());
        this.fTraceTypes = new Combo(composite, 2056);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.fTraceTypes.setLayoutData((Object)data);
        this.fTraceTypes.setFont(parent.getFont());
        String[] availableTraceTypes = TmfTraceType.getAvailableTraceTypes();
        String[] traceTypeList = new String[availableTraceTypes.length + 1];
        traceTypeList[0] = TRACE_TYPE_AUTO_DETECT;
        System.arraycopy(availableTraceTypes, 0, traceTypeList, 1, availableTraceTypes.length);
        this.fTraceTypes.setItems(traceTypeList);
        this.fTraceTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
                boolean enabled = ImportTraceWizardPage.this.fTraceTypes.getText().equals(TRACE_TYPE_AUTO_DETECT);
                ImportTraceWizardPage.this.fImportUnrecognizedButton.setEnabled(enabled);
            }
        });
        this.fTraceTypes.select(0);
        this.fImportUnrecognizedButton = new Button(composite, 32);
        this.fImportUnrecognizedButton.setSelection(true);
        this.fImportUnrecognizedButton.setText(Messages.ImportTraceWizard_ImportUnrecognized);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.fOverwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.fOverwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.fOverwriteExistingResourcesCheckbox.setText(Messages.ImportTraceWizard_OverwriteExistingTrace);
        this.fOverwriteExistingResourcesCheckbox.setSelection(false);
        this.fCreateLinksInWorkspaceButton = new Button((Composite)optionsGroup, 32);
        this.fCreateLinksInWorkspaceButton.setFont(optionsGroup.getFont());
        this.fCreateLinksInWorkspaceButton.setText(Messages.ImportTraceWizard_CreateLinksInWorkspace);
        this.fCreateLinksInWorkspaceButton.setSelection(true);
        this.fCreateLinksInWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        });
        this.fPreserveFolderStructureButton = new Button((Composite)optionsGroup, 32);
        this.fPreserveFolderStructureButton.setFont(optionsGroup.getFont());
        this.fPreserveFolderStructureButton.setText(Messages.ImportTraceWizard_PreserveFolderStructure);
        this.fPreserveFolderStructureButton.setSelection(true);
        Composite comp = new Composite((Composite)optionsGroup, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData data = new GridData(4, 2, true, false);
        comp.setLayoutData((Object)data);
        this.fCreateExperimentCheckbox = new Button(comp, 32);
        this.fCreateExperimentCheckbox.setFont(comp.getFont());
        this.fCreateExperimentCheckbox.setText(Messages.ImportTraceWizard_CreateExperiment);
        this.fCreateExperimentCheckbox.setSelection(false);
        data = new GridData(1, 2, false, false);
        this.fCreateExperimentCheckbox.setLayoutData((Object)data);
        this.fExperimentNameText = new Text(comp, 2048);
        data = new GridData(4, 2, true, false);
        this.fExperimentNameText.setLayoutData((Object)data);
        this.fExperimentNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        });
        this.fCreateExperimentCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.fExperimentNameText.setEnabled(ImportTraceWizardPage.this.fCreateExperimentCheckbox.getSelection());
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        });
        this.updateWidgetEnablements();
    }

    public boolean validateSourceGroup() {
        File source = this.getSourceFile();
        if (source == null) {
            this.setMessage(Messages.ImportTraceWizard_SelectTraceSourceEmpty);
            this.setErrorMessage(null);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(source.getPath()))) {
            this.setMessage(null);
            this.setErrorMessage(this.getSourceConflictMessage());
            return false;
        }
        if (!(this.isImportFromDirectory() || ArchiveUtil.ensureTarSourceIsValid(source.getAbsolutePath()) || ArchiveUtil.ensureZipSourceIsValid(source.getAbsolutePath()) || ArchiveUtil.ensureGzipSourceIsValid(source.getAbsolutePath()))) {
            this.setMessage(null);
            this.setErrorMessage(Messages.ImportTraceWizard_BadArchiveFormat);
            return false;
        }
        if (this.fSelectionGroup.getCheckedElementCount() == 0) {
            this.setMessage(null);
            this.setErrorMessage(Messages.ImportTraceWizard_SelectTraceNoneSelected);
            return false;
        }
        IContainer container = this.getSpecifiedContainer();
        if (container != null && container.isVirtual()) {
            if (Platform.getPreferencesService().getBoolean("org.eclipse.tracecompass.tmf.ui", "description.disableLinking", false, null)) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_CannotImportFilesUnderAVirtualFolder);
                return false;
            }
            if (this.fCreateLinksInWorkspaceButton == null || !this.fCreateLinksInWorkspaceButton.getSelection()) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_HaveToCreateLinksUnderAVirtualFolder);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean validateOptionsGroup() {
        if (this.fCreateExperimentCheckbox != null && this.fCreateExperimentCheckbox.getSelection()) {
            String name = this.fExperimentNameText.getText().trim();
            if (name.isEmpty()) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_ErrorEmptyExperimentName);
                return false;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace != null && !workspace.validateName(name, 1).isOK()) {
                this.setMessage(null);
                this.setErrorMessage(NLS.bind((String)Messages.ImportTraceWizard_ErrorExperimentNameInvalid, (Object)name));
                return false;
            }
            if (this.fExperimentFolderElement != null) {
                TmfExperimentElement element = this.fExperimentFolderElement.getExperiment(name);
                if (element != null) {
                    this.setMessage(null);
                    this.setErrorMessage(NLS.bind((String)Messages.ImportTraceWizard_ErrorExperimentAlreadyExists, (Object)name));
                    return false;
                }
                IFolder expResource = this.fExperimentFolderElement.getResource();
                IResource res = expResource.findMember(name);
                if (res != null) {
                    this.setMessage(null);
                    this.setErrorMessage(NLS.bind((String)Messages.ImportTraceWizard_ErrorResourceAlreadyExists, (Object)name));
                    return false;
                }
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private File getSourceFile() {
        return this.isImportFromDirectory() ? this.getSourceDirectory() : this.getSourceArchiveFile();
    }

    private boolean isImportFromDirectory() {
        return this.fImportFromDirectoryRadio != null && this.fImportFromDirectoryRadio.getSelection();
    }

    protected void restoreWidgetValues() {
        boolean value;
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (this.fImportUnrecognizedButton != null) {
            value = settings.get(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID)) == null ? true : settings.getBoolean(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID));
            this.fImportUnrecognizedButton.setSelection(value);
        }
        if (this.fPreserveFolderStructureButton != null) {
            value = settings.get(this.getPageStoreKey(IMPORT_WIZARD_PRESERVE_FOLDERS_ID)) == null ? true : settings.getBoolean(this.getPageStoreKey(IMPORT_WIZARD_PRESERVE_FOLDERS_ID));
            this.fPreserveFolderStructureButton.setSelection(value);
        }
        if (this.fCreateExperimentCheckbox != null) {
            value = settings.get(this.getPageStoreKey(IMPORT_WIZARD_CREATE_EXPERIMENT_ID)) == null ? false : settings.getBoolean(this.getPageStoreKey(IMPORT_WIZARD_CREATE_EXPERIMENT_ID));
            this.fCreateExperimentCheckbox.setSelection(value);
            this.fExperimentNameText.setEnabled(this.fCreateExperimentCheckbox.getSelection());
        }
        value = settings.get(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_FROM_DIRECTORY_ID)) == null ? true : settings.getBoolean(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_FROM_DIRECTORY_ID));
        if (this.directoryNameField != null) {
            ImportTraceWizardPage.restoreComboValues(this.directoryNameField, settings, this.getPageStoreKey(IMPORT_WIZARD_ROOT_DIRECTORY_ID));
        }
        if (this.fArchiveNameField != null) {
            ImportTraceWizardPage.restoreComboValues(this.fArchiveNameField, settings, this.getPageStoreKey(IMPORT_WIZARD_ARCHIVE_FILE_NAME_ID));
        }
        if (this.fImportFromDirectoryRadio != null) {
            this.fImportFromDirectoryRadio.setSelection(value);
            if (value) {
                this.directoryRadioSelected();
            }
        }
        if (this.fImportFromArchiveRadio != null) {
            this.fImportFromArchiveRadio.setSelection(!value);
            if (!value) {
                this.archiveRadioSelected();
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.fImportUnrecognizedButton != null) {
            settings.put(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID), this.fImportUnrecognizedButton.getSelection());
        }
        if (this.fPreserveFolderStructureButton != null) {
            settings.put(this.getPageStoreKey(IMPORT_WIZARD_PRESERVE_FOLDERS_ID), this.fPreserveFolderStructureButton.getSelection());
        }
        if (this.fCreateExperimentCheckbox != null) {
            settings.put(this.getPageStoreKey(IMPORT_WIZARD_CREATE_EXPERIMENT_ID), this.fCreateExperimentCheckbox.getSelection());
        }
        settings.put(this.getPageStoreKey(IMPORT_WIZARD_IMPORT_FROM_DIRECTORY_ID), this.isImportFromDirectory());
        if (this.directoryNameField != null) {
            this.saveComboValues(this.directoryNameField, settings, this.getPageStoreKey(IMPORT_WIZARD_ROOT_DIRECTORY_ID));
        }
        if (this.fArchiveNameField != null) {
            this.saveComboValues(this.fArchiveNameField, settings, this.getPageStoreKey(IMPORT_WIZARD_ARCHIVE_FILE_NAME_ID));
        }
    }

    private String getPageStoreKey(String key) {
        return String.valueOf(this.getName()) + key;
    }

    private static void restoreComboValues(Combo combo, IDialogSettings settings, String key) {
        String[] directoryNames = settings.getArray(key);
        if (directoryNames != null && directoryNames.length != 0) {
            int i = 0;
            while (i < directoryNames.length) {
                combo.add(directoryNames[i]);
                ++i;
            }
        }
    }

    private void saveComboValues(Combo combo, IDialogSettings settings, String key) {
        String[] directoryNames = settings.getArray(key);
        if (directoryNames == null) {
            directoryNames = new String[]{};
        }
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            directoryNames = this.addToHistory(directoryNames, items[i]);
            ++i;
        }
        settings.put(key, directoryNames);
    }

    public boolean finish() {
        IStatus[] operationStatus;
        block10: {
            TmfTraceFolder parentTraceFolder;
            IFolder expFolder;
            TmfExperimentFolder root;
            ArrayList traceResources;
            block12: {
                String experimentName;
                IFolder[] experimentFolders;
                block11: {
                    String traceTypeLabel = this.getImportTraceTypeId();
                    final String traceId = !TRACE_TYPE_AUTO_DETECT.equals(traceTypeLabel) ? TmfTraceType.getTraceTypeId((String)traceTypeLabel) : null;
                    this.saveWidgetValues();
                    Path baseSourceContainerPath = new Path(this.getSourceContainerPath());
                    boolean importFromArchive = this.getSourceArchiveFile() != null;
                    int importOptionFlags = this.getImportOptionFlags();
                    IPath destinationContainerPath = this.getContainerFullPath();
                    operationStatus = new IStatus[]{Status.OK_STATUS};
                    traceResources = new ArrayList();
                    this.getContainer().run(true, true, new IRunnableWithProgress((IPath)baseSourceContainerPath, destinationContainerPath, importFromArchive, importOptionFlags, operationStatus, traceResources){
                        private final /* synthetic */ IPath val$baseSourceContainerPath;
                        private final /* synthetic */ IPath val$destinationContainerPath;
                        private final /* synthetic */ boolean val$importFromArchive;
                        private final /* synthetic */ int val$importOptionFlags;
                        private final /* synthetic */ IStatus[] val$operationStatus;
                        private final /* synthetic */ List val$traceResources;
                        {
                            this.val$baseSourceContainerPath = iPath;
                            this.val$destinationContainerPath = iPath2;
                            this.val$importFromArchive = bl;
                            this.val$importOptionFlags = n;
                            this.val$operationStatus = iStatusArray;
                            this.val$traceResources = list;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            final LinkedList<TraceFileSystemElement> selectedFileSystemElements = new LinkedList<TraceFileSystemElement>();
                            IElementFilter passThroughFilter = new IElementFilter(){

                                public void filterElements(Collection elements, IProgressMonitor m) {
                                    selectedFileSystemElements.addAll(elements);
                                }

                                public void filterElements(Object[] elements, IProgressMonitor m) {
                                    int i = 0;
                                    while (i < elements.length) {
                                        selectedFileSystemElements.add((TraceFileSystemElement)((Object)elements[i]));
                                        ++i;
                                    }
                                }
                            };
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                            ImportTraceWizardPage.this.fSelectionGroup.getAllCheckedListItems(passThroughFilter, (IProgressMonitor)subMonitor);
                            TraceValidateAndImportOperation operation = new TraceValidateAndImportOperation(ImportTraceWizardPage.this.getContainer().getShell(), selectedFileSystemElements, traceId, this.val$baseSourceContainerPath, this.val$destinationContainerPath, this.val$importFromArchive, this.val$importOptionFlags, ImportTraceWizardPage.this.fTraceFolderElement);
                            operation.run(monitor);
                            monitor.done();
                            this.val$operationStatus[0] = operation.getStatus();
                            this.val$traceResources.addAll(operation.getImportedResources());
                        }
                    });
                    if ((importOptionFlags & 0x20) == 0 || traceResources.size() <= 0) break block10;
                    experimentFolders = new IFolder[1];
                    root = this.fExperimentFolderElement;
                    experimentName = this.fExperimentNameText.getText().trim();
                    if (root != null && experimentName != null) break block11;
                    return true;
                }
                if (operationStatus[0] == null || !operationStatus[0].isOK()) break block10;
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        operationStatus[0] = null;
                        NewExperimentOperation operation = new NewExperimentOperation(root, experimentName);
                        operation.run(monitor);
                        monitor.done();
                        operationStatus[0] = operation.getStatus();
                        experimentFolders[0] = operation.getExperimentFolder();
                    }
                });
                expFolder = experimentFolders[0];
                parentTraceFolder = this.fTraceFolderElement;
                if (expFolder != null && parentTraceFolder != null) break block12;
                return true;
            }
            try {
                if (operationStatus[0] != null && operationStatus[0].isOK()) {
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            operationStatus[0] = null;
                            SelectTracesOperation operation = new SelectTracesOperation(root, expFolder, parentTraceFolder, traceResources);
                            operation.run(monitor);
                            monitor.done();
                            operationStatus[0] = operation.getStatus();
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                operationStatus[0] = new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.ImportTraceWizard_ImportProblem, e.getTargetException());
            }
            catch (InterruptedException e) {
                operationStatus[0] = Status.CANCEL_STATUS;
            }
        }
        if (!operationStatus[0].isOK()) {
            if (operationStatus[0].getSeverity() == 8) {
                this.setMessage(Messages.ImportTraceWizard_ImportOperationCancelled);
                this.setErrorMessage(null);
            } else {
                Throwable exception = operationStatus[0].getException();
                if (exception != null) {
                    Activator.getDefault().logError(exception.getMessage(), exception);
                    this.displayErrorDialog(String.valueOf(operationStatus[0].getMessage()) + ": " + exception);
                }
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_ImportProblem);
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected String getImportTraceTypeId() {
        return this.fTraceTypes.getText();
    }

    protected int getImportOptionFlags() {
        int flags = 0;
        if (this.fCreateLinksInWorkspaceButton != null && this.fCreateLinksInWorkspaceButton.getSelection()) {
            flags |= 4;
        }
        if (this.fImportUnrecognizedButton != null && this.fImportUnrecognizedButton.getSelection()) {
            flags |= 8;
        }
        if (this.fOverwriteExistingResourcesCheckbox != null && this.fOverwriteExistingResourcesCheckbox.getSelection()) {
            flags |= 0x10;
        }
        if (this.fPreserveFolderStructureButton != null && this.fPreserveFolderStructureButton.getSelection()) {
            flags |= 2;
        }
        if (this.fCreateExperimentCheckbox != null && this.fCreateExperimentCheckbox.getSelection()) {
            flags |= 0x20;
        }
        return flags;
    }

    public void dispose() {
        super.dispose();
        this.disposeSelectionGroupRoot();
    }
}

