/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.filter;

import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.utility.StringMatcher;
import org.eclipse.team.svn.ui.history.filter.ILogEntryFilter;

public class ChangeNameLogEntryFilter
implements ILogEntryFilter {
    protected String changedPathToAccept;

    public ChangeNameLogEntryFilter() {
        this(null);
    }

    public ChangeNameLogEntryFilter(String changedPathToAccept) {
        this.changedPathToAccept = changedPathToAccept;
    }

    public boolean accept(SVNLogEntry logEntry) {
        if (this.changedPathToAccept == null) {
            return true;
        }
        StringMatcher matcher = new StringMatcher(this.changedPathToAccept);
        SVNLogPath[] paths = logEntry.changedPaths == null ? new SVNLogPath[]{} : logEntry.changedPaths;
        int i = 0;
        while (i < paths.length) {
            if (matcher.match(paths[i].path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setGangedPathToAccept(String changedPathToAccept) {
        this.changedPathToAccept = changedPathToAccept;
    }

    public String getGangedPathToAccept() {
        return this.changedPathToAccept;
    }
}

