/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.PreparedBranchTagOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.remote.BranchTagAction;
import org.eclipse.ui.IWorkbenchPart;

public class CreateBranchTagAction
extends BaseRevisionGraphAction {
    public static final String CreateBranchAction_ID = "CreateBranch";
    public static final String CreateTagAction_ID = "CreateTag";
    protected int action;

    public CreateBranchTagAction(IWorkbenchPart part, int action) {
        super(part);
        this.action = action;
        if (this.action == 0) {
            this.setText(SVNUIMessages.HistoryView_BranchFromRevision);
            this.setId(CreateBranchAction_ID);
            this.setToolTipText(SVNUIMessages.HistoryView_BranchFromRevision);
            this.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/branch.gif"));
        } else {
            this.setText(SVNUIMessages.HistoryView_TagFromRevision);
            this.setId(CreateTagAction_ID);
            this.setToolTipText(SVNUIMessages.HistoryView_TagFromRevision);
            this.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/tag.gif"));
        }
    }

    protected boolean calculateEnabled() {
        RevisionEditPart[] editParts = null;
        if (this.getSelectedEditParts().length == 1 && (editParts = this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER)).length == 1) {
            String revision = String.valueOf(editParts[0].getCastedModel().getRevision());
            String title = this.action == 0 ? SVNUIMessages.format((String)SVNUIMessages.HistoryView_BranchFrom, (Object[])new String[]{revision}) : SVNUIMessages.format((String)SVNUIMessages.HistoryView_TagFrom, (Object[])new String[]{revision});
            this.setText(title);
            this.setToolTipText(title);
            return true;
        }
        String title = this.action == 0 ? SVNUIMessages.HistoryView_BranchFromRevision : SVNUIMessages.HistoryView_TagFromRevision;
        this.setText(title);
        this.setToolTipText(title);
        return false;
    }

    public void run() {
        IRepositoryResource[] resources = BaseRevisionGraphAction.convertToResources(this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER));
        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation((IRepositoryResource[])resources, (Shell)this.getWorkbenchPart().getSite().getShell(), (int)this.action);
        this.runOperation((IActionOperation)op);
    }
}

