/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.internal.tabbed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.utils.ConnectStateHelper;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.utils.DataHelper;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.utils.CommonUtils;
import org.eclipse.tcf.te.ui.interfaces.services.INodePropertiesTableUIDelegate;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.tables.properties.NodePropertiesTableTableNode;
import org.eclipse.tcf.te.ui.views.extensions.LabelProviderDelegateExtensionPointManager;
import org.eclipse.ui.forms.widgets.Section;

public class PeerNodePropertiesSectionContentProvider
implements IStructuredContentProvider {
    private final boolean updateParentSectionTitle;

    public PeerNodePropertiesSectionContentProvider(boolean updateParentSectionTitle) {
        this.updateParentSectionTitle = updateParentSectionTitle;
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getElements(final Object inputElement) {
        if (inputElement instanceof IPeerNode) {
            final HashMap properties = new HashMap();
            final HashMap debugProperties = new HashMap();
            if (Protocol.isDispatchThread()) {
                properties.putAll(((IPeerNode)inputElement).getPeer().getAttributes());
            } else {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Map warnings;
                        IPeerNode peerNode = (IPeerNode)inputElement;
                        properties.putAll(peerNode.getPeer().getAttributes());
                        properties.put("ConnectState", ConnectStateHelper.getConnectState((int)peerNode.getConnectState()));
                        String error = CommonUtils.getPeerError((IPeerNode)peerNode);
                        if (error != null) {
                            properties.put("Error", error);
                        }
                        if ((warnings = CommonUtils.getPeerWarnings((IPeerNode)peerNode)) != null && !warnings.isEmpty()) {
                            PropertiesContainer container = new PropertiesContainer();
                            container.addProperties(warnings);
                            properties.put("Warnings", DataHelper.encodePropertiesContainer((IPropertiesContainer)container));
                        }
                        if (peerNode.getConnectState() == 11) {
                            properties.put("LocalServices", peerNode.getStringProperty("LocalServices"));
                            properties.put("RemoteServices", peerNode.getStringProperty("RemoteServices"));
                        }
                        if (Platform.inDebugMode()) {
                            debugProperties.putAll(peerNode.getProperties());
                        }
                    }
                });
            }
            INodePropertiesTableUIDelegate delegate = (INodePropertiesTableUIDelegate)ServiceUtils.getUIServiceDelegate((Object)inputElement, (Object)inputElement, INodePropertiesTableUIDelegate.class);
            ArrayList<NodePropertiesTableTableNode> nodes = new ArrayList<NodePropertiesTableTableNode>();
            for (Map.Entry entry : properties.entrySet()) {
                String string = (String)entry.getKey();
                if (!Platform.inDebugMode() && (string.endsWith(".silent") || string.contains(".transient") || delegate != null && delegate.isFiltered(inputElement, string, entry.getValue()))) continue;
                nodes.add(new NodePropertiesTableTableNode(string, entry.getValue() != null ? entry.getValue().toString() : ""));
            }
            Collections.sort(nodes, new Comparator<NodePropertiesTableTableNode>(){

                @Override
                public int compare(NodePropertiesTableTableNode arg0, NodePropertiesTableTableNode arg1) {
                    return arg0.name.compareToIgnoreCase(arg1.name);
                }
            });
            if (delegate != null) {
                delegate.expandNodesAfterSort(inputElement, nodes);
            }
            ILabelProvider provider = (ILabelProvider)ServiceUtils.getUIServiceDelegate((Object)inputElement, (Object)inputElement, ILabelProvider.class);
            ArrayList<Object> result = new ArrayList<Object>();
            for (NodePropertiesTableTableNode nodePropertiesTableTableNode : nodes) {
                void var8_12;
                String text = null;
                ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(inputElement, false);
                if (delegates != null && delegates.length > 0) {
                    text = delegates[0].getText((Object)nodePropertiesTableTableNode);
                }
                if (text == null && provider != null) {
                    text = provider.getText((Object)nodePropertiesTableTableNode);
                }
                if (text != null && !"".equals(text)) {
                    NodePropertiesTableTableNode nodePropertiesTableTableNode2 = new NodePropertiesTableTableNode(nodePropertiesTableTableNode.name, text);
                }
                result.add(var8_12);
            }
            if (!debugProperties.isEmpty()) {
                nodes.clear();
                for (Map.Entry entry : debugProperties.entrySet()) {
                    String name = (String)entry.getKey();
                    if (name.equals("ConnectState") || name.equals("Error") || name.equals("Warnings") || name.equals("LocalServices") || name.equals("RemoteServices")) continue;
                    nodes.add(new NodePropertiesTableTableNode(name, entry.getValue() != null ? entry.getValue().toString() : ""));
                }
                Collections.sort(nodes, new Comparator<NodePropertiesTableTableNode>(){

                    @Override
                    public int compare(NodePropertiesTableTableNode arg0, NodePropertiesTableTableNode arg1) {
                        return arg0.name.compareToIgnoreCase(arg1.name);
                    }
                });
                result.add(new NodePropertiesTableTableNode("", ""));
                result.addAll(nodes);
            }
            return result.toArray(new NodePropertiesTableTableNode[result.size()]);
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (!this.updateParentSectionTitle) {
            return;
        }
        String sectionTitle = null;
        Object element = null;
        if (newInput instanceof ITreeSelection && !((ITreeSelection)newInput).isEmpty()) {
            ITreeSelection selection = (ITreeSelection)newInput;
            TreePath[] pathes = selection.getPaths();
            TreePath path = pathes.length > 0 ? pathes[0] : null;
            Object object = element = path != null ? path.getLastSegment() : null;
        }
        if (newInput instanceof IPeerNode) {
            element = newInput;
        }
        if (element instanceof IPeerNode) {
            sectionTitle = NLS.bind((String)Messages.NodePropertiesTableControl_section_title, (Object)"Peer");
        }
        if (sectionTitle == null || "".equals(sectionTitle.trim())) {
            sectionTitle = Messages.NodePropertiesTableControl_section_title_noSelection;
        }
        if (sectionTitle.length() < 40) {
            StringBuilder buffer = new StringBuilder(sectionTitle);
            while (buffer.length() < 40) {
                buffer.append(" ");
            }
            sectionTitle = buffer.toString();
        }
        Control control = viewer.getControl();
        while (control != null && !control.isDisposed()) {
            if (control instanceof Section) {
                Section section = (Section)control;
                try {
                    section.setText(sectionTitle);
                }
                catch (SWTException sWTException) {}
                break;
            }
            control = control.getParent();
        }
    }
}

