/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.wizard;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;

public abstract class AbstractWizard
extends Wizard {
    public AbstractWizard() {
        this.setDialogSettings(S2ESdkUiActivator.getDefault().getDialogSettingsSection(this.getDialogSettingsKey()));
    }

    protected String getDialogSettingsKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void addPage(IWizardPage page) {
        if (!(page instanceof AbstractWizardPage)) {
            throw new IllegalArgumentException("Expecting an instance of '" + AbstractWizardPage.class.getName() + "'.");
        }
        super.addPage(page);
    }

    public AbstractWizardPage getPage(String name) {
        return (AbstractWizardPage)super.getPage(name);
    }

    public IWizardPage getStartingPage() {
        AbstractWizardPage startingPage = (AbstractWizardPage)super.getStartingPage();
        if (startingPage != null && startingPage.isExcludePage()) {
            return this.getNextPage((IWizardPage)startingPage);
        }
        return startingPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        List<IWizardPage> pages = Arrays.asList(this.getPages());
        int index = pages.indexOf(page);
        if (index == pages.size() - 1 || index == -1) {
            return null;
        }
        AbstractWizardPage nextPage = (AbstractWizardPage)pages.get(index + 1);
        if (nextPage.isExcludePage()) {
            return this.getNextPage((IWizardPage)nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        AbstractWizardPage prevPage = (AbstractWizardPage)super.getPreviousPage(page);
        if (prevPage != null && prevPage.isExcludePage()) {
            return this.getPreviousPage((IWizardPage)prevPage);
        }
        return prevPage;
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            AbstractWizardPage bcPage = (AbstractWizardPage)page;
            if (!bcPage.isExcludePage() && !bcPage.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean performFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractWizardPage wizPage;
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof AbstractWizardPage && !(wizPage = (AbstractWizardPage)page).performFinish()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

