/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.ui.forms.ContainerPart;
import org.eclipse.sapphire.ui.forms.FormComponentDef;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.FormDef;
import org.eclipse.sapphire.ui.forms.WithDef;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.FormPresentation;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.widgets.Composite;

public final class WithImpliedPart
extends ContainerPart<FormComponentPart> {
    private ModelPath path;
    private Element element;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init() {
        WithDef def = (WithDef)this.definition;
        this.path = new ModelPath(this.substituteParams(def.getPath().text()));
        this.element = this.getModelElement();
        int i = 0;
        int n = this.path.length();
        while (i < n) {
            ModelPath.Segment segment = this.path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                this.element = this.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                this.element = this.element.parent().element();
            } else {
                if (!(segment instanceof ModelPath.PropertySegment)) throw new RuntimeException(this.path.toString());
                Property property = this.element.property(((ModelPath.PropertySegment)segment).getPropertyName());
                if (property == null || !(property.definition() instanceof ImpliedElementProperty)) throw new RuntimeException(this.path.toString());
                this.element = ((ElementHandle)property).content();
            }
            ++i;
        }
    }

    @Override
    protected ContainerPart.Children initChildren() {
        return new ContainerPart.Children(this){

            protected void init(ListFactory<FormComponentPart> childPartsListFactory) {
                Element element = WithImpliedPart.this.getLocalModelElement();
                WithDef def = WithImpliedPart.this.definition();
                FormDef formdef = (FormDef)def.getCases().get(0);
                for (FormComponentDef childPartDef : formdef.getContent()) {
                    childPartsListFactory.add((Object)((FormComponentPart)WithImpliedPart.createWithoutInit(WithImpliedPart.this, element, childPartDef, WithImpliedPart.this.params)));
                }
            }
        };
    }

    @Override
    public WithDef definition() {
        return (WithDef)super.definition();
    }

    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public Element getLocalModelElement() {
        return this.element;
    }

    @Override
    public boolean setFocus(ModelPath path) {
        if (this.path.isPrefixOf(path)) {
            super.setFocus(path.makeRelativeTo(this.path));
        }
        return false;
    }

    @Override
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new FormPresentation(this, parent, composite);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.path = null;
        this.element = null;
    }
}

