/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeKind;

public final class ClassBasedJavaType
extends JavaType {
    private final Class<?> cl;
    private final JavaTypeKind kind;
    private final JavaType base;
    private final Set<JavaType> interfaces;

    public ClassBasedJavaType(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        this.cl = cl;
        this.kind = cl.isAnnotation() ? JavaTypeKind.ANNOTATION : (cl.isEnum() ? JavaTypeKind.ENUM : (cl.isInterface() ? JavaTypeKind.INTERFACE : (Modifier.isAbstract(cl.getModifiers()) ? JavaTypeKind.ABSTRACT_CLASS : JavaTypeKind.CLASS)));
        Class<?> base = cl.getSuperclass();
        this.base = base != null ? new ClassBasedJavaType(base) : null;
        HashSet<ClassBasedJavaType> interfaces = new HashSet<ClassBasedJavaType>();
        Class<?>[] classArray = cl.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            interfaces.add(new ClassBasedJavaType(i));
            ++n2;
        }
        this.interfaces = Collections.unmodifiableSet(interfaces);
    }

    @Override
    public Class<?> artifact() {
        return this.cl;
    }

    @Override
    public String name() {
        return this.cl.getName();
    }

    @Override
    public JavaTypeKind kind() {
        return this.kind;
    }

    @Override
    public JavaType base() {
        return this.base;
    }

    @Override
    public Set<JavaType> interfaces() {
        return this.interfaces;
    }
}

