/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.news.impl.poll;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.recommenders.news.api.NewsItem;
import org.eclipse.recommenders.news.api.poll.INewsPollingService;
import org.eclipse.recommenders.news.api.poll.PollingPolicy;
import org.eclipse.recommenders.news.api.poll.PollingRequest;
import org.eclipse.recommenders.news.api.poll.PollingResult;
import org.eclipse.recommenders.news.impl.poll.DefaultDownloadService;
import org.eclipse.recommenders.news.impl.poll.DefaultFeedItemStore;
import org.eclipse.recommenders.news.impl.poll.IDownloadService;
import org.eclipse.recommenders.news.impl.poll.IFeedItemStore;

public class DefaultNewsPollingService
implements INewsPollingService {
    private final IDownloadService downloadService;
    private final IFeedItemStore feedItemStore;

    public DefaultNewsPollingService() {
        this.downloadService = new DefaultDownloadService();
        this.feedItemStore = new DefaultFeedItemStore();
    }

    @VisibleForTesting
    DefaultNewsPollingService(IDownloadService downloadService, IFeedItemStore feedItemStore) {
        this.downloadService = downloadService;
        this.feedItemStore = feedItemStore;
    }

    public Collection<PollingResult> poll(Collection<PollingRequest> requests, @Nullable IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.size());
        try {
            Date now = new Date();
            ArrayList<PollingResult> results = new ArrayList<PollingResult>(requests.size());
            for (PollingRequest request : requests) {
                if (progress.isCanceled()) break;
                PollingResult result = this.poll(request, now, progress.newChild(1));
                results.add(result);
            }
            ArrayList<PollingResult> arrayList = results;
            return arrayList;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private PollingResult poll(PollingRequest request, Date pollingDate, SubMonitor monitor) {
        Date lastPolledDate;
        URI feedUri = request.getFeedUri();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)feedUri.toString(), (int)1);
        try {
            lastPolledDate = this.downloadService.getLastAttemptDate(feedUri);
        }
        catch (IOException iOException) {
            lastPolledDate = null;
        }
        PollingPolicy policy = request.getPollingPolicy();
        if (policy.shouldPoll(lastPolledDate, pollingDate)) {
            try {
                return this.performDownload(feedUri, progress.newChild(1));
            }
            catch (IOException iOException) {
                try {
                    progress.setWorkRemaining(1);
                    return this.fallbackToLocalStore(feedUri, progress.newChild(1));
                }
                catch (IOException iOException2) {
                    progress.setWorkRemaining(1);
                    return this.fallbackToErrorResult(feedUri, progress.newChild(1));
                }
            }
        }
        try {
            return this.fallbackToLocalStore(feedUri, progress.newChild(1));
        }
        catch (IOException iOException) {
            progress.setWorkRemaining(1);
            return this.fallbackToErrorResult(feedUri, progress.newChild(1));
        }
    }

    private PollingResult performDownload(URI feedUri, SubMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Throwable throwable = null;
        Object var8_6 = null;
        try (InputStream stream = this.downloadService.download(feedUri, (IProgressMonitor)progress.newChild(1));){
            List<NewsItem> newItems = this.feedItemStore.udpate(feedUri, stream, (IProgressMonitor)progress.newChild(1));
            List<NewsItem> allItems = this.feedItemStore.getNewsItems(feedUri);
            PollingResult.Status status = PollingResult.Status.DOWNLOADED;
            return new PollingResult(feedUri, newItems, allItems, status);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private PollingResult fallbackToLocalStore(URI feedUri, SubMonitor monitor) throws IOException {
        PollingResult.Status status;
        List<Object> allItems;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        List newItems = Collections.emptyList();
        InputStream in = this.downloadService.read(feedUri);
        if (in != null) {
            this.feedItemStore.udpate(feedUri, in, (IProgressMonitor)progress.newChild(1));
            allItems = this.feedItemStore.getNewsItems(feedUri);
            status = PollingResult.Status.DOWNLOADED;
        } else {
            progress.worked(1);
            allItems = Collections.emptyList();
            status = PollingResult.Status.NOT_DOWNLOADED;
        }
        return new PollingResult(feedUri, newItems, allItems, status);
    }

    private PollingResult fallbackToErrorResult(URI feedUri, SubMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        List newItems = Collections.emptyList();
        List allItems = Collections.emptyList();
        PollingResult.Status status = PollingResult.Status.NOT_DOWNLOADED;
        progress.worked(1);
        return new PollingResult(feedUri, newItems, allItems, status);
    }
}

