/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AssignmentPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RealizedPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculatedPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculationPartition;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;

public class Partitioner {
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull MappingRegion region;
    protected final @NonNull Set<@NonNull Property> corrolaryProperties;
    private final @NonNull List<@NonNull Edge> predicatedEdges = new ArrayList<Edge>();
    private final @NonNull List<@NonNull Node> predicatedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> predicatedOutputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> realizedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> realizedOutputNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull NavigableEdge> navigableEdges = new HashSet<NavigableEdge>();
    private final @NonNull Set<@NonNull Edge> realizedEdges = new HashSet<Edge>();
    private final @NonNull List<@NonNull Edge> realizedOutputEdges = new ArrayList<Edge>();
    private final @Nullable Node traceNode;
    private final @NonNull List<@NonNull Node> trueNodes = new ArrayList<Node>();
    private boolean hasLoadedNodes = false;
    private final @NonNull Set<@NonNull Edge> alreadyPredicatedEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Node> alreadyPredicatedNodes = new HashSet<Node>();
    private final @NonNull Set<@NonNull Edge> alreadyRealizedEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Node> alreadyRealizedNodes = new HashSet<Node>();
    private final @NonNull Set<@NonNull Node> alreadyTrueNodes = new HashSet<Node>();
    private final @NonNull Map<@NonNull Edge, @NonNull List<@NonNull AbstractPartition>> debugEdge2partitions = new HashMap<Edge, List<AbstractPartition>>();

    public static @NonNull Iterable<@NonNull MappingRegion> partition(@NonNull ProblemHandler problemHandler, @NonNull Iterable<@NonNull ? extends Region> activeRegions) {
        HashSet<@NonNull Property> corrolaryProperties = new HashSet<Property>();
        for (Region region : activeRegions) {
            if (!(region instanceof MappingRegion)) continue;
            Partitioner.gatherCorrolaries(corrolaryProperties, (MappingRegion)region);
        }
        ArrayList<@NonNull MappingRegion> arrayList = new ArrayList<MappingRegion>();
        for (Region region : activeRegions) {
            if (!(region instanceof MappingRegion)) continue;
            Partitioner partitioner = new Partitioner(problemHandler, (MappingRegion)region, corrolaryProperties);
            Iterables.addAll(arrayList, partitioner.partition());
        }
        return arrayList;
    }

    private static void gatherCorrolaries(@NonNull Set<@NonNull Property> corrolaryProperties, @NonNull MappingRegion region) {
        ArrayList<@NonNull Node> middleNodes = new ArrayList<Node>();
        for (Node node : RegionUtil.getOwnedNodes((Region)region)) {
            if (node.isTrue() || !node.isPattern() || !node.isRealized() || !RegionUtil.getClassDatumAnalysis(node).getDomainUsage().isMiddle()) continue;
            middleNodes.add(node);
        }
        for (Node node : middleNodes) {
            for (NavigableEdge edge : node.getNavigationEdges()) {
                if (!edge.isRealized() || !edge.getEdgeTarget().isRealized()) continue;
                corrolaryProperties.add(RegionUtil.getProperty((NavigableEdge)edge));
            }
        }
    }

    public Partitioner(@NonNull ProblemHandler problemHandler, @NonNull MappingRegion region, @NonNull Set<@NonNull Property> corrolaryProperties) {
        this.problemHandler = problemHandler;
        this.region = region;
        this.corrolaryProperties = corrolaryProperties;
        this.analyzeNodes();
        this.traceNode = this.analyzeTraceNode();
        this.analyzeEdges();
    }

    public void addEdge(@NonNull Edge edge, @NonNull Role newEdgeRole, @NonNull AbstractPartition partition) {
        if (newEdgeRole == Role.PREDICATED) {
            this.alreadyPredicatedEdges.add(edge);
        } else if (newEdgeRole == Role.REALIZED) {
            this.alreadyRealizedEdges.add(edge);
        }
        List<@NonNull AbstractPartition> partitions = this.debugEdge2partitions.get(edge);
        if (partitions == null) {
            partitions = new ArrayList<AbstractPartition>();
            this.debugEdge2partitions.put(edge, partitions);
        }
        assert (!partitions.contains(partition));
        partitions.add(partition);
    }

    public boolean addPredicatedNode(@NonNull Node node) {
        return this.alreadyPredicatedNodes.add(node);
    }

    public void addProblem(@NonNull CompilerProblem problem) {
        this.problemHandler.addProblem(problem);
    }

    public boolean addRealizedNode(@NonNull Node node) {
        return this.alreadyRealizedNodes.add(node);
    }

    public boolean addTrueNode(@NonNull Node node) {
        return this.alreadyTrueNodes.add(node);
    }

    private void analyzeEdges() {
        for (Edge edge : RegionUtil.getOwnedEdges((Region)this.region)) {
            if (edge.isSecondary()) continue;
            if (edge.isPredicated()) {
                this.predicatedEdges.add(edge);
            }
            if (!edge.isNavigation()) continue;
            if (edge.isRealized()) {
                Node targetNode;
                this.realizedEdges.add(edge);
                Node sourceNode = edge.getEdgeSource();
                if (!this.realizedMiddleNodes.contains(sourceNode) && (sourceNode.isPredicated() || sourceNode.isRealized()) && !this.realizedMiddleNodes.contains(targetNode = edge.getEdgeTarget()) && (targetNode.isPredicated() || targetNode.isRealized())) {
                    this.realizedOutputEdges.add(edge);
                }
                if (!edge.getEdgeTarget().isLoaded()) continue;
                RegionUtil.getClassDatumAnalysis(edge.getEdgeSource()).getDomainUsage().isMiddle();
                continue;
            }
            if (!edge.isMatched() || edge.isCast()) continue;
            assert (!edge.isExpression());
            assert (!edge.isComputation());
            Node targetNode = edge.getEdgeTarget();
            targetNode.isExplicitNull();
        }
        for (Edge edge : this.region.getNavigationEdges()) {
            if (edge.isSecondary() || edge.isRealized()) continue;
            this.navigableEdges.add((NavigableEdge)edge);
        }
    }

    private void analyzeNodes() {
        for (Node node : RegionUtil.getOwnedNodes((Region)this.region)) {
            if (node.isTrue()) {
                this.trueNodes.add(node);
                continue;
            }
            if (node.isPattern()) {
                if (node.isConstant()) continue;
                if (node.isLoaded()) {
                    this.hasLoadedNodes = true;
                    continue;
                }
                if (RegionUtil.getClassDatumAnalysis(node).getDomainUsage().isMiddle()) {
                    if (node.isPredicated()) {
                        this.predicatedMiddleNodes.add(node);
                        continue;
                    }
                    if (node.isRealized()) {
                        this.realizedMiddleNodes.add(node);
                        continue;
                    }
                    if (node.isExplicitNull()) continue;
                    throw new IllegalStateException("middle node must be predicated or realized : " + node);
                }
                if (node.isOperation()) continue;
                if (node.isPredicated()) {
                    this.predicatedOutputNodes.add(node);
                    continue;
                }
                if (!node.isRealized()) continue;
                this.realizedOutputNodes.add(node);
                continue;
            }
            if (!node.isOperation() || !node.isRealized()) continue;
            this.realizedOutputNodes.add(node);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Node analyzeTraceNode() {
        if (this.realizedMiddleNodes.size() == 0) {
            return null;
        }
        if (this.realizedMiddleNodes.size() == 1) {
            return this.realizedMiddleNodes.get(0);
        }
        HashMap<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure = new HashMap<Node, Set<Node>>();
        for (Node targetNode : this.realizedMiddleNodes) {
            targetFromSourceClosure.put(targetNode, Sets.newHashSet((Object[])new Node[]{targetNode}));
        }
        for (Node sourceNode : this.realizedMiddleNodes) {
            for (NavigableEdge navigationEdge : sourceNode.getRealizedNavigationEdges()) {
                Node targetNode = navigationEdge.getEdgeTarget();
                @NonNull Set sourceClosure = (Set)targetFromSourceClosure.get(targetNode);
                if (sourceClosure == null) continue;
                sourceClosure.add(sourceNode);
            }
        }
        RegionHelper regionHelper = new RegionHelper(this.region);
        List<@NonNull Node> headNodes = regionHelper.computeHeadNodes(targetFromSourceClosure);
        if (headNodes.size() == 0) {
            return null;
        }
        return headNodes.get(0);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void check() {
        for (Node node : RegionUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isSpeculated() && !node.isRealized() || this.hasRealizedNode(node)) continue;
            this.problemHandler.addProblem(RegionUtil.createRegionError((Region)this.region, "Should have realized " + node, new Object[0]));
        }
        HashSet<@NonNull Edge> allPrimaryEdges = new HashSet<Edge>();
        for (Edge edge : RegionUtil.getOwnedEdges((Region)this.region)) {
            if (edge.isSecondary()) continue;
            allPrimaryEdges.add(edge);
            if (!edge.isRealized() || this.hasRealizedEdge(edge)) continue;
            this.problemHandler.addProblem(RegionUtil.createRegionError((Region)this.region, "Should have realized " + edge, new Object[0]));
        }
        Set<@NonNull Node> deadNodes = this.computeDeadNodes(RegionUtil.getOwnedNodes((Region)this.region));
        Set<@NonNull Edge> deadEdges = this.computeDeadEdges(deadNodes);
        allPrimaryEdges.removeAll(deadEdges);
        HashSet<@NonNull Edge> partitionedEdges = new HashSet<Edge>(this.debugEdge2partitions.keySet());
        if (!partitionedEdges.equals(allPrimaryEdges)) {
            @NonNull HashSet extraEdgesSet = Sets.newHashSet(partitionedEdges);
            CompilerUtil.removeAll(extraEdgesSet, allPrimaryEdges);
            for (Edge edge : extraEdgesSet) {
                this.problemHandler.addProblem(RegionUtil.createRegionWarning((Region)this.region, "Extra " + edge, new Object[0]));
            }
            @NonNull HashSet missingEdgesSet = Sets.newHashSet(allPrimaryEdges);
            missingEdgesSet.removeAll(partitionedEdges);
            for (Edge edge : missingEdgesSet) {
                if (this.isCorrolary(edge)) continue;
                this.problemHandler.addProblem(RegionUtil.createRegionWarning((Region)this.region, "Missing " + edge, new Object[0]));
            }
        }
    }

    private @NonNull Set<@NonNull Edge> computeDeadEdges(@NonNull Iterable<@NonNull Node> deadNodes) {
        HashSet<@NonNull Edge> deadEdges = new HashSet<Edge>();
        for (Node node : deadNodes) {
            Iterables.addAll(deadEdges, (Iterable)RegionUtil.getIncomingEdges((Node)node));
            Iterables.addAll(deadEdges, (Iterable)RegionUtil.getOutgoingEdges((Node)node));
        }
        return deadEdges;
    }

    /*
     * Unable to fully structure code
     */
    private @NonNull Set<@NonNull Node> computeDeadNodes(@NonNull Iterable<@NonNull Node> nodes) {
        deadNodes = new HashSet<Node>();
        moreDeadNodes = null;
        for (Node node : nodes) {
            if (node.isHead() || !this.isDead(node, null)) continue;
            if (moreDeadNodes == null) {
                moreDeadNodes = new HashSet<Node>();
            }
            moreDeadNodes.add(node);
        }
        if (moreDeadNodes != null) ** GOTO lbl27
        return deadNodes;
lbl-1000:
        // 1 sources

        {
            deadNodes.addAll((Collection<Node>)moreDeadNodes);
            moreDeadNodesList = new ArrayList<E>(moreDeadNodes);
            moreDeadNodes = null;
            for (Node deadNode : moreDeadNodesList) {
                for (Edge edge : RegionUtil.getIncomingEdges((Node)deadNode)) {
                    sourceNode = edge.getEdgeSource();
                    if (sourceNode.isHead() || !this.isDead(sourceNode, deadNodes)) continue;
                    if (moreDeadNodes == null) {
                        moreDeadNodes = new HashSet<E>();
                    }
                    moreDeadNodes.add(sourceNode);
                }
            }
            if (moreDeadNodes == null) break;
lbl27:
            // 2 sources

            ** while (moreDeadNodes.size() > 0)
        }
lbl28:
        // 2 sources

        return deadNodes;
    }

    private @NonNull MicroMappingRegion createAssignmentRegion(@NonNull Edge outputEdge, int i) {
        AssignmentPartition realizedPartition = new AssignmentPartition(this, outputEdge);
        MicroMappingRegion microMappingRegion = realizedPartition.createMicroMappingRegion("\u00abedge" + i + "\u00bb", "_p" + i);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            RegionUtil.getScheduleManager((Region)microMappingRegion).writeDebugGraphs((Region)microMappingRegion, null);
        }
        return microMappingRegion;
    }

    private @NonNull MicroMappingRegion createRealizedRegion() {
        RealizedPartition realizedPartition = new RealizedPartition(this);
        MicroMappingRegion microMappingRegion = realizedPartition.createMicroMappingRegion("\u00abrealized\u00bb", "_r0");
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            RegionUtil.getScheduleManager((Region)microMappingRegion).writeDebugGraphs((Region)microMappingRegion, null);
        }
        return microMappingRegion;
    }

    private @NonNull MicroMappingRegion createSpeculatedRegion() {
        SpeculatedPartition speculatedPartition = new SpeculatedPartition(this);
        MicroMappingRegion microMappingRegion = speculatedPartition.createMicroMappingRegion("\u00abspeculated\u00bb", "_p1");
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            RegionUtil.getScheduleManager((Region)microMappingRegion).writeDebugGraphs((Region)microMappingRegion, null);
        }
        return microMappingRegion;
    }

    private @NonNull MicroMappingRegion createSpeculationRegion() {
        SpeculationPartition speculationPartition = new SpeculationPartition(this);
        MicroMappingRegion microMappingRegion = speculationPartition.createMicroMappingRegion("\u00abspeculation\u00bb", "_p0");
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            RegionUtil.getScheduleManager((Region)microMappingRegion).writeDebugGraphs((Region)microMappingRegion, null);
        }
        return microMappingRegion;
    }

    public @NonNull Iterable<@NonNull Edge> getAlreadyPredicatedEdges() {
        return this.alreadyPredicatedEdges;
    }

    public @NonNull Iterable<@NonNull Edge> getAlreadyRealizedEdges() {
        return this.alreadyRealizedEdges;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getNavigableEdges() {
        return this.navigableEdges;
    }

    public @NonNull Iterable<@NonNull Edge> getPredicatedEdges() {
        return this.predicatedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedMiddleNodes() {
        return this.predicatedMiddleNodes;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedOutputNodes() {
        return this.predicatedOutputNodes;
    }

    public @NonNull Iterable<@NonNull Edge> getRealizedEdges() {
        return this.realizedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedMiddleNodes() {
        return this.realizedMiddleNodes;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedOutputNodes() {
        return this.realizedOutputNodes;
    }

    public @NonNull MappingRegion getRegion() {
        return this.region;
    }

    public @Nullable Node getTraceNode() {
        return this.traceNode;
    }

    public @NonNull Iterable<@NonNull Node> getTrueNodes() {
        return this.trueNodes;
    }

    public boolean hasPredicatedEdge(@NonNull Edge edge) {
        return this.alreadyPredicatedEdges.contains(edge);
    }

    public boolean hasPredicatedNode(@NonNull Node node) {
        return this.alreadyPredicatedNodes.contains(node);
    }

    public boolean hasRealizedEdge(@NonNull Edge edge) {
        return this.alreadyRealizedEdges.contains(edge);
    }

    public boolean hasRealizedNode(@NonNull Node node) {
        return this.alreadyRealizedNodes.contains(node);
    }

    public boolean hasTrueNode(@NonNull Node node) {
        return this.alreadyTrueNodes.contains(node);
    }

    public boolean isCorrolary(@NonNull Edge edge) {
        if (!edge.isNavigation()) {
            return false;
        }
        return this.corrolaryProperties.contains(((NavigableEdge)edge).getProperty());
    }

    private boolean isDead(@NonNull Node node, @Nullable Set<@NonNull Node> knownDeadNodes) {
        if (node.isHead()) {
            return false;
        }
        for (Edge edge : RegionUtil.getIncomingEdges((Node)node)) {
            if (!edge.isNavigation() || knownDeadNodes != null && knownDeadNodes.contains(edge.getEdgeSource())) continue;
            return false;
        }
        for (Edge edge : RegionUtil.getOutgoingEdges((Node)node)) {
            if (!edge.isNavigation() && !edge.isExpression() || knownDeadNodes != null && knownDeadNodes.contains(edge.getEdgeTarget())) continue;
            return false;
        }
        return true;
    }

    public @NonNull Iterable<@NonNull MappingRegion> partition() {
        ArrayList<@NonNull MappingRegion> regions = new ArrayList<MappingRegion>();
        if (!this.realizedMiddleNodes.isEmpty() || !this.predicatedMiddleNodes.isEmpty()) {
            if (!this.hasLoadedNodes) {
                regions.add(this.region);
            } else {
                if (this.predicatedMiddleNodes.isEmpty()) {
                    regions.add((MappingRegion)this.createRealizedRegion());
                } else {
                    regions.add((MappingRegion)this.createSpeculationRegion());
                    regions.add((MappingRegion)this.createSpeculatedRegion());
                }
                for (Edge outputEdge : this.realizedOutputEdges) {
                    if (this.hasRealizedEdge(outputEdge)) continue;
                    regions.add((MappingRegion)this.createAssignmentRegion(outputEdge, regions.size()));
                }
                for (Edge edge : this.realizedEdges) {
                    if (this.hasRealizedEdge(edge)) continue;
                    regions.add((MappingRegion)this.createAssignmentRegion(edge, regions.size()));
                }
                this.check();
            }
        }
        return regions;
    }

    public String toString() {
        return this.region.toString();
    }
}

