/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.Library;
import org.eclipse.pmf.pim.PMFFactory;
import org.eclipse.pmf.pim.PMFPackage;
import org.eclipse.pmf.pim.impl.EClassToEventEntryMapImpl;
import org.eclipse.pmf.pim.presentation.PmfEditorPlugin;
import org.eclipse.pmf.pim.provider.PmfEditPlugin;
import org.eclipse.pmf.pim.ui.Button;
import org.eclipse.pmf.pim.ui.UIEvent;
import org.eclipse.pmf.pim.ui.UiFactory;
import org.eclipse.pmf.pim.ui.UiPackage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class PMFApplicationWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(PmfEditorPlugin.INSTANCE.getString("_UI_PMFEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = PmfEditorPlugin.INSTANCE.getString("_UI_PMFEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected PMFPackage pmfPackage = PMFPackage.eINSTANCE;
    protected PMFFactory pmfFactory = this.pmfPackage.getPMFFactory();
    protected PMFModelWizardNewFileCreationPage newFileCreationPage;
    protected PMFModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(PmfEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(PmfEditorPlugin.INSTANCE.getImage("full/wizban/NewPMF")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.pmfPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.pmfPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject rootObject = this.pmfFactory.create(eClass);
        this.initialObjectCreationPage.init(rootObject);
        return rootObject;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = PMFApplicationWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            if (rootObject instanceof Application) {
                                Application application = (Application)rootObject;
                                try {
                                    URI uri = application.eResource().getURI();
                                    String targetURI = PMFApplicationWizard.extractDirectoryPath(uri.toPlatformString(true));
                                    try {
                                        Library libObjectEvents = PMFApplicationWizard.this.addLibraryEvent(targetURI, "System.plb");
                                        if (!application.getLibraries().contains((Object)libObjectEvents)) {
                                            application.getLibraries().add((Object)libObjectEvents);
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    application.eResource().save(Collections.emptyMap());
                                }
                                catch (IOException e) {
                                    EMFEditUIPlugin.INSTANCE.log((Object)e);
                                }
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", PMFApplicationWizard.this.initialObjectCreationPage.getEncoding());
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            PmfEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)PmfEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            PmfEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new PMFModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(PmfEditorPlugin.INSTANCE.getString("_UI_PMFApplicationWizard_label"));
        this.newFileCreationPage.setDescription(PmfEditorPlugin.INSTANCE.getString("_UI_PMFApplicationWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(PmfEditorPlugin.INSTANCE.getString("_UI_PMFEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = PmfEditorPlugin.INSTANCE.getString("_UI_PMFEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new PMFModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(PmfEditorPlugin.INSTANCE.getString("_UI_PMFApplicationWizard_label"));
        this.initialObjectCreationPage.setDescription(PmfEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    protected Library addLibraryEvent(String path, String fileName) throws IOException {
        Library libObject = PMFFactory.eINSTANCE.createLibrary();
        libObject.setName("System");
        EMap<EClass, EList<UIEvent>> uiEventsMap = PMFApplicationWizard.createUIEventsforLibrary(libObject);
        libObject.eSet((EStructuralFeature)PMFPackage.Literals.LIBRARY__EVENTS, (Object)uiEventsMap.map());
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(path) + "/" + fileName), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)libObject);
        resource.save(Collections.EMPTY_MAP);
        return libObject;
    }

    public static EMap<EClass, EList<UIEvent>> createUIEventsforLibrary(Library libObject) {
        EcoreEMap uiEventsMap = new EcoreEMap(PMFPackage.Literals.ECLASS_TO_EVENT_ENTRY_MAP, EClassToEventEntryMapImpl.class, (InternalEObject)libObject, 11);
        BasicEList uiButtonEvents = new BasicEList();
        Button button = UiFactory.eINSTANCE.createButton();
        EClass eButton = button.eClass();
        UIEvent clickEvent = UiFactory.eINSTANCE.createUIEvent();
        clickEvent.setName("Click");
        clickEvent.setId("click");
        uiButtonEvents.add((Object)clickEvent);
        uiEventsMap.put((Object)eButton, (Object)uiButtonEvents);
        BasicEList uiUIElementEvents = new BasicEList();
        EClass eUIElement = (EClass)UiPackage.eINSTANCE.getEClassifier("UIElement");
        UIEvent exposeEvent = UiFactory.eINSTANCE.createUIEvent();
        exposeEvent.setName("Expose");
        exposeEvent.setId("Expose");
        UIEvent mouseInEvent = UiFactory.eINSTANCE.createUIEvent();
        mouseInEvent.setName("MouseIn");
        mouseInEvent.setId("MouseIn");
        UIEvent mouseOutEvent = UiFactory.eINSTANCE.createUIEvent();
        mouseOutEvent.setName("MouseOut");
        mouseOutEvent.setId("MouseOut");
        UIEvent dragEvent = UiFactory.eINSTANCE.createUIEvent();
        dragEvent.setName("DragDetect");
        dragEvent.setId("DragDetect");
        UIEvent focusinEvent = UiFactory.eINSTANCE.createUIEvent();
        focusinEvent.setName("FocusIn");
        focusinEvent.setId("FocusIn");
        UIEvent focusoutEvent = UiFactory.eINSTANCE.createUIEvent();
        focusoutEvent.setName("FocusOut");
        focusoutEvent.setId("FocusOut");
        UIEvent doubleclickEvent = UiFactory.eINSTANCE.createUIEvent();
        doubleclickEvent.setName("MouseDoubleClick");
        doubleclickEvent.setId("MouseDoubleClick");
        UIEvent resizeEvent = UiFactory.eINSTANCE.createUIEvent();
        resizeEvent.setName("Resize");
        resizeEvent.setId("Resize");
        uiUIElementEvents.add((Object)exposeEvent);
        uiUIElementEvents.add((Object)mouseInEvent);
        uiUIElementEvents.add((Object)mouseOutEvent);
        uiUIElementEvents.add((Object)dragEvent);
        uiUIElementEvents.add((Object)focusinEvent);
        uiUIElementEvents.add((Object)focusoutEvent);
        uiUIElementEvents.add((Object)doubleclickEvent);
        uiUIElementEvents.add((Object)resizeEvent);
        uiEventsMap.put((Object)eUIElement, (Object)uiUIElementEvents);
        BasicEList uiListEvents = new BasicEList();
        EClass eList = (EClass)UiPackage.eINSTANCE.getEClassifier("ListView");
        UIEvent selectionEvent = UiFactory.eINSTANCE.createUIEvent();
        selectionEvent.setName("Selection");
        selectionEvent.setId("Selection");
        uiListEvents.add((Object)selectionEvent);
        uiEventsMap.put((Object)eList, (Object)uiListEvents);
        BasicEList uiTextEvents = new BasicEList();
        EClass eText = (EClass)UiPackage.eINSTANCE.getEClassifier("Text");
        UIEvent focusInEvent = UiFactory.eINSTANCE.createUIEvent();
        focusInEvent.setName("focusIn");
        focusInEvent.setId("focusIn");
        UIEvent focusOutEvent = UiFactory.eINSTANCE.createUIEvent();
        focusOutEvent.setName("focusOut");
        focusOutEvent.setId("focusOut");
        UIEvent clickTextEvent = UiFactory.eINSTANCE.createUIEvent();
        clickTextEvent.setName("Click");
        clickTextEvent.setId("Click");
        UIEvent modifyTextEvent = UiFactory.eINSTANCE.createUIEvent();
        modifyTextEvent.setName("Modify");
        modifyTextEvent.setId("Modify");
        uiTextEvents.add((Object)focusInEvent);
        uiTextEvents.add((Object)focusOutEvent);
        uiTextEvents.add((Object)clickTextEvent);
        uiTextEvents.add((Object)modifyTextEvent);
        uiEventsMap.put((Object)eText, (Object)uiTextEvents);
        BasicEList uiComboEvents = new BasicEList();
        EClass eCombo = (EClass)UiPackage.eINSTANCE.getEClassifier("Combo");
        UIEvent selectionComboEvent = UiFactory.eINSTANCE.createUIEvent();
        selectionComboEvent.setName("Selection");
        selectionComboEvent.setId("Selection");
        UIEvent modifyComboEvent = UiFactory.eINSTANCE.createUIEvent();
        modifyComboEvent.setName("Modify");
        modifyComboEvent.setId("Modify");
        uiComboEvents.add((Object)selectionComboEvent);
        uiComboEvents.add((Object)modifyComboEvent);
        uiEventsMap.put((Object)eCombo, (Object)uiComboEvents);
        BasicEList uiLinkEvents = new BasicEList();
        EClass eLink = (EClass)UiPackage.eINSTANCE.getEClassifier("Hyperlink");
        UIEvent clickComboEvent = UiFactory.eINSTANCE.createUIEvent();
        clickComboEvent.setName("Click");
        clickComboEvent.setId("Click");
        uiLinkEvents.add((Object)clickComboEvent);
        uiEventsMap.put((Object)eLink, (Object)uiLinkEvents);
        BasicEList uiMenuItemEvents = new BasicEList();
        EClass eMenuItem = (EClass)UiPackage.eINSTANCE.getEClassifier("MenuItem");
        UIEvent selectMenuItemEvent = UiFactory.eINSTANCE.createUIEvent();
        selectMenuItemEvent.setName("Selection");
        selectMenuItemEvent.setId("Selection");
        uiMenuItemEvents.add((Object)selectMenuItemEvent);
        uiEventsMap.put((Object)eMenuItem, (Object)uiMenuItemEvents);
        BasicEList uiTabEvents = new BasicEList();
        EClass eTab = (EClass)UiPackage.eINSTANCE.getEClassifier("Tab");
        UIEvent selectTabEvent = UiFactory.eINSTANCE.createUIEvent();
        selectTabEvent.setName("Selection");
        selectTabEvent.setId("Selection");
        uiTabEvents.add((Object)selectTabEvent);
        uiEventsMap.put((Object)eTab, (Object)uiTabEvents);
        BasicEList uiTableEvents = new BasicEList();
        EClass eTable = (EClass)UiPackage.eINSTANCE.getEClassifier("Table");
        UIEvent selectTableEvent = UiFactory.eINSTANCE.createUIEvent();
        selectTableEvent.setName("Selection");
        selectTableEvent.setId("Selection");
        UIEvent sortTableEvent = UiFactory.eINSTANCE.createUIEvent();
        sortTableEvent.setName("Sort");
        sortTableEvent.setId("Sort");
        uiTableEvents.add((Object)selectTableEvent);
        uiTableEvents.add((Object)sortTableEvent);
        uiEventsMap.put((Object)eTable, (Object)uiTableEvents);
        BasicEList uiDateTimePickerEvents = new BasicEList();
        EClass eDateTimePicker = (EClass)UiPackage.eINSTANCE.getEClassifier("DateTimePicker");
        UIEvent selectDateTimePickerEvent = UiFactory.eINSTANCE.createUIEvent();
        selectDateTimePickerEvent.setName("Selection");
        selectDateTimePickerEvent.setId("Selection");
        uiDateTimePickerEvents.add((Object)selectDateTimePickerEvent);
        uiEventsMap.put((Object)eDateTimePicker, (Object)uiDateTimePickerEvents);
        return uiEventsMap;
    }

    public static String extractDirectoryPath(String path) {
        if (path == null || path.equals("") || path.equals("/")) {
            return "";
        }
        int lastSlashPos = path.lastIndexOf(47);
        if (lastSlashPos >= 0) {
            return path.substring(0, lastSlashPos);
        }
        return "";
    }

    public class PMFModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Text nameField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public PMFModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PMFModelWizardInitialObjectCreationPage.this.setPageComplete(PMFModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(PmfEditorPlugin.INSTANCE.getString("_UI_ModelName"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.nameField = new Text(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.nameField.setLayoutData((Object)data);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(PmfEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data2);
            this.encodingField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data2);
            for (String encoding : this.getEncodings()) {
                this.encodingField.add(encoding);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.nameField.setFocus();
            }
        }

        public String getInitialObjectName() {
            return "Application";
        }

        public void init(EObject object) {
            if (object instanceof Library) {
                Library library = (Library)object;
                library.setName(this.nameField.getText());
            }
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        protected String getLabel(String typeName) {
            try {
                return PmfEditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                PmfEditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(PmfEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class PMFModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public PMFModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(PmfEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

