/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathUtils;
import org.eclipse.php.internal.ui.preferences.includepath.PHPSourceContainerWorkbookPage;
import org.eclipse.ui.internal.IChangeListener;

public class PHPBuildPathSourcePage
extends PHPSourceContainerWorkbookPage {
    private List<BPListElement> fRemovedElements = new ArrayList<BPListElement>();
    private boolean removeFromIncludePath = false;
    private List<IChangeListener> removedElementListeners = new ArrayList<IChangeListener>(1);

    public List<BPListElement> getRemovedElements() {
        return this.fRemovedElements;
    }

    public boolean shouldRemoveFromIncludePath() {
        return this.removeFromIncludePath;
    }

    public PHPBuildPathSourcePage(ListDialogField buildpathList) {
        super(buildpathList);
    }

    @Override
    protected void removeEntry() {
        this.fRemovedElements.clear();
        List selElements = this.fFoldersList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof BPListElementAttribute) {
                BPListElementAttribute attrib = (BPListElementAttribute)elem;
                String key = attrib.getKey();
                Path[] value = null;
                if (key.equals("exclusion") || key.equals("inclusion")) {
                    value = new Path[]{};
                }
                attrib.getParent().setAttribute(key, (Object)value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fFoldersList.refresh();
            this.fBuildpathList.dialogFieldChanged();
        } else {
            for (BPListElement element : selElements) {
                if (element.getEntryKind() != 3) continue;
                if (IncludePathManager.isInIncludePath((IProject)this.fCurrJProject.getProject(), (IPath)element.getPath()) != null) {
                    this.fRemovedElements.add(element);
                }
                List list = BuildpathModifier.removeFilters((IPath)element.getPath(), (IScriptProject)this.fCurrJProject, (List)this.fFoldersList.getElements());
                for (BPListElement modified : list) {
                    this.fFoldersList.refresh((Object)modified);
                    this.fFoldersList.expandElement((Object)modified, 3);
                }
            }
            if (this.fRemovedElements.size() > 0) {
                this.fFoldersList.removeElements(this.fRemovedElements);
                this.removeFromIncludePath = IncludePathUtils.openConfirmationDialog(this.getShell(), PHPUIMessages.IncludePath_RemoveEntryTitle, PHPUIMessages.IncludePath_RemoveEntryFromIncludePathMessage);
                for (IChangeListener listener : this.removedElementListeners) {
                    listener.update(true);
                }
            }
            this.fFoldersList.removeElements(selElements);
        }
    }

    public void registerRemovedElementListener(IChangeListener listener) {
        if (listener != null) {
            this.removedElementListeners.add(listener);
        }
    }

    public void unregisterRemovedElementListener(IChangeListener listener) {
        if (listener != null) {
            this.removedElementListeners.remove(listener);
        }
    }
}

