/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.PHPUILanguageToolkit;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.Messages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.corext.codemanipulation.OrganizeUseStatementsOperation;
import org.eclipse.php.internal.ui.dialogs.MultiElementListSelectionDialog;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.PHPTypeNameMatchLabelProvider;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class OrganizeUseStatementsAction
extends SelectionDispatchAction {
    private static final OrganizeImportComparator ORGANIZE_IMPORT_COMPARATOR = new OrganizeImportComparator();
    private PHPStructuredEditor fEditor;
    private boolean fIsQueryShowing = false;

    public OrganizeUseStatementsAction(IWorkbenchSite site) {
        super(site);
        this.setText(Messages.OrganizeImportsAction_label);
        this.setToolTipText(Messages.OrganizeImportsAction_tooltip);
        this.setDescription(Messages.OrganizeImportsAction_description);
    }

    public OrganizeUseStatementsAction(IEditorPart part) {
        this((IWorkbenchSite)part.getSite());
        if (part instanceof PHPStructuredEditor) {
            this.fEditor = (PHPStructuredEditor)part;
        }
    }

    @Override
    public void run(ITextSelection selection) {
        ISourceModule cu = OrganizeUseStatementsAction.getSourceModule(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    private static ISourceModule getSourceModule(PHPStructuredEditor fEditor) {
        return EditorUtility.getEditorInputModelElement((IEditorPart)fEditor, (boolean)false);
    }

    @Override
    public void run(IStructuredSelection selection) {
        ISourceModule cu = OrganizeUseStatementsAction.getSourceModule(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    public void run(ISourceModule sourceModule) {
        try {
            Program astRoot = SharedASTProvider.getAST(sourceModule, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
            OrganizeUseStatementsOperation op = new OrganizeUseStatementsOperation(sourceModule, astRoot, this.createChooseImportQuery(this.fEditor));
            IRewriteTarget target = (IRewriteTarget)this.fEditor.getAdapter(IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IWorkbenchWindow context = this.getSite().getWorkbenchWindow();
            IEditingSupport helper = this.createViewerHelper();
            try {
                try {
                    this.registerHelper(helper, this.fEditor);
                    progressService.runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                    this.setStatusBarMessage(this.getOrganizeInfo(op), this.fEditor);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.deregisterHelper(helper, this.fEditor);
                    if (target != null) {
                        target.endCompoundChange();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.deregisterHelper(helper, this.fEditor);
                    if (target != null) {
                        target.endCompoundChange();
                    }
                }
            }
            finally {
                this.deregisterHelper(helper, this.fEditor);
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
        catch (IOException | ModelException e) {
            PHPUiPlugin.log(e);
        }
    }

    private String getOrganizeInfo(OrganizeUseStatementsOperation op) {
        int nImportsAdded = op.getNumberOfImportsAdded();
        if (nImportsAdded >= 0) {
            if (nImportsAdded == 1) {
                return Messages.OrganizeImportsAction_summary_added_singular;
            }
            return Messages.format(Messages.OrganizeImportsAction_summary_added_plural, String.valueOf(nImportsAdded));
        }
        if (nImportsAdded == -1) {
            return Messages.OrganizeImportsAction_summary_removed_singular;
        }
        return Messages.format(Messages.OrganizeImportsAction_summary_removed_plural, String.valueOf(-nImportsAdded));
    }

    private OrganizeUseStatementsOperation.IChooseImportQuery createChooseImportQuery(final PHPStructuredEditor editor) {
        return new OrganizeUseStatementsOperation.IChooseImportQuery(){

            @Override
            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                return OrganizeUseStatementsAction.this.doChooseImports(openChoices, ranges, editor);
            }
        };
    }

    private TypeNameMatch[] doChooseImports(TypeNameMatch[][] openChoices, final ISourceRange[] ranges, final PHPStructuredEditor editor) {
        ISelection sel = editor.getSelectionProvider().getSelection();
        TypeNameMatch[] result = null;
        PHPTypeNameMatchLabelProvider labelProvider = new PHPTypeNameMatchLabelProvider(1, PHPUILanguageToolkit.getInstance());
        MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                OrganizeUseStatementsAction.this.doListSelectionChanged(this.getCurrentPage(), ranges, editor);
            }
        };
        this.fIsQueryShowing = true;
        dialog.setTitle(Messages.OrganizeImportsAction_selectiondialog_title);
        dialog.setMessage(Messages.OrganizeImportsAction_selectiondialog_message);
        dialog.setElements(openChoices);
        dialog.setComparator(ORGANIZE_IMPORT_COMPARATOR);
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            result = new TypeNameMatch[res.length];
            int i = 0;
            while (i < res.length) {
                Object[] array = (Object[])res[i];
                if (array.length > 0) {
                    result[i] = (TypeNameMatch)array[0];
                    QualifiedTypeNameHistory.remember((String)result[i].getFullyQualifiedName());
                }
                ++i;
            }
        }
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            editor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
        this.fIsQueryShowing = false;
        return result;
    }

    private void doListSelectionChanged(int page, ISourceRange[] ranges, PHPStructuredEditor editor) {
        if (ranges != null && page >= 0 && page < ranges.length) {
            ISourceRange range = ranges[page];
            editor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    private void setStatusBarMessage(String message, PHPStructuredEditor editor) {
        IStatusLineManager manager = editor.getEditorSite().getActionBars().getStatusLineManager();
        manager.setMessage(message);
    }

    private IEditingSupport createViewerHelper() {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
                return true;
            }

            public boolean ownsFocusShell() {
                return OrganizeUseStatementsAction.this.fIsQueryShowing;
            }
        };
    }

    private void registerHelper(IEditingSupport helper, PHPStructuredEditor editor) {
        ISourceViewer viewer = editor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.register(helper);
        }
    }

    private void deregisterHelper(IEditingSupport helper, PHPStructuredEditor editor) {
        ISourceViewer viewer = editor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister(helper);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private OrganizeUseStatementsAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new OrganizeUseStatementsAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }

    private static final class OrganizeImportComparator
    implements Comparator<String> {
        private OrganizeImportComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int pos2;
            if (o1.equals(o2)) {
                return 0;
            }
            QualifiedTypeNameHistory history = QualifiedTypeNameHistory.getDefault();
            int pos1 = history.getPosition((Object)o1);
            if (pos1 == (pos2 = history.getPosition((Object)o2))) {
                return Collator.getInstance().compare(o1, o2);
            }
            if (pos1 > pos2) {
                return -1;
            }
            return 1;
        }
    }
}

