/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.ConstructedCEditorMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.actions.TextSearchGroup;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class CDTBasedTextEditor
extends TextEditor
implements ISelectionChangedListener {
    private TextSearchGroup textSearchGroup;
    private CContentOutlinePage fOutlinePage;

    protected void useCDTDocumentProvider() {
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
    }

    protected void useCDTRulerContextMenuID() {
        this.setRulerContextMenuId("#CEditorRulerContext");
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ConstructedCEditorMessages.getResourceBundle();
        ContentAssistAction action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new TextOperationAction(bundle, "ContentAssistContextInformation.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        this.textSearchGroup = new TextSearchGroup((IEditorPart)this);
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (this.textSearchGroup != null) {
            this.textSearchGroup.fillContextMenu(menu);
        }
    }

    public void dispose() {
        if (this.textSearchGroup != null) {
            this.textSearchGroup.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.getOutlinePage();
        }
        if (required == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.cdt.ui.CView", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (required == IShowInSource.class) {
            ICElement ce = null;
            try {
                ce = SelectionConverter.getElementAtOffset((ITextEditor)this);
            }
            catch (CModelException cModelException) {
                ce = null;
            }
            if (ce != null) {
                StructuredSelection selection = new StructuredSelection((Object)ce);
                return new IShowInSource((ISelection)selection){
                    private final /* synthetic */ ISelection val$selection;
                    {
                        this.val$selection = iSelection;
                    }

                    public ShowInContext getShowInContext() {
                        return new ShowInContext((Object)CDTBasedTextEditor.this.getEditorInput(), this.val$selection);
                    }
                };
            }
        }
        return super.getAdapter(required);
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new CContentOutlinePage(new CEditor());
            this.fOutlinePage.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        CDTBasedTextEditor.setOutlinePageInput(this.fOutlinePage, this.getEditorInput());
        return this.fOutlinePage;
    }

    public static void setOutlinePageInput(CContentOutlinePage page, IEditorInput input) {
        IWorkingCopyManager manager;
        IWorkingCopy workingCopy;
        if (page != null && (workingCopy = (manager = CUIPlugin.getDefault().getWorkingCopyManager()).getWorkingCopy(input)) != null) {
            page.setInput((ITranslationUnit)workingCopy);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)obj).getSourceRange();
                if (range != null) {
                    this.setSelection(range, !this.isActivePart());
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ISourceRange element, boolean moveCursor) {
        if (element == null) {
            return;
        }
        try {
            IRegion alternateRegion = null;
            int start = element.getStartPos();
            int length = element.getLength();
            if (start < 0 || length < 0) {
                start = 0;
                length = 0;
            }
            if (length == 0 && start == 0 && element.getStartLine() > 0) {
                start = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getStartLine() - 1);
                length = element.getEndLine() > 0 ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getEndLine()) - start : start;
                alternateRegion = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(element.getStartLine() - 1);
                if ((start == length || length < 0) && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
            }
            this.setHighlightRange(start, length, moveCursor);
            if (moveCursor) {
                start = element.getIdStartPos();
                length = element.getIdLength();
                if (start == 0 && length == 0 && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
                if (start > -1 && this.getSourceViewer() != null) {
                    this.getSourceViewer().revealRange(start, length);
                    this.getSourceViewer().setSelectedRange(start, length);
                }
                this.updateStatusField("InputPosition");
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BadLocationException badLocationException) {}
        if (moveCursor) {
            this.resetHighlightRange();
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return this == service.getActivePart();
    }

    public void forceOutlineViewUpdate() {
        try {
            CoreModel.getDefault().getCModel().makeConsistent((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CModelException cModelException) {}
    }
}

