/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class Open64ErrorParser
implements IErrorParser {
    private static final Pattern F_ERROR_WARNING_LINE = Pattern.compile("^openf..-[0-9]+ open(f..): ([A-Z]+)( [A-Za-z0-9$_]+, File = (.*), Line = ([0-9]+)(, Column = ([0-9]+))?|.*)?[ \t]*$");
    private static final int SEVERITY_GROUP = 2;
    private static final int FILENAME_GROUP = 4;
    private static final int LINE_NUMBER_GROUP = 5;
    private static final Pattern F_ALTERNATE_ERROR_LINE = Pattern.compile("openf90 ERROR: (.*)[ \t]*$");
    private static final int ALT_DESCRIPTION_GROUP = 1;
    private String previousLine = "";

    public boolean processLine(String currentLine, ErrorParserManager eoParser) {
        Matcher matcher = this.matchErrorWarningLine(this.previousLine);
        this.previousLine = currentLine;
        if (matcher != null) {
            int severity = matcher.group(2).equals("WARNING") ? 1 : 2;
            String filename = matcher.group(4);
            IFile file = filename == null ? null : eoParser.findFileName(filename);
            int lineNumber = this.atoi(matcher.group(5));
            String description = currentLine.trim();
            eoParser.generateMarker((IResource)file, lineNumber, description, severity, null);
            return true;
        }
        matcher = this.matchAlternateErrorLine(currentLine);
        if (matcher != null) {
            eoParser.generateMarker(null, 0, matcher.group(1), 2, null);
            return true;
        }
        return false;
    }

    private Matcher matchErrorWarningLine(String previousLine) {
        Matcher m;
        if (previousLine != null && (m = F_ERROR_WARNING_LINE.matcher(previousLine)).matches()) {
            return m;
        }
        return null;
    }

    private Matcher matchAlternateErrorLine(String currentLine) {
        Matcher m;
        if (currentLine != null && (m = F_ALTERNATE_ERROR_LINE.matcher(currentLine)).matches()) {
            return m;
        }
        return null;
    }

    private int atoi(String string) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

