/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class CrayErrorParser
implements IErrorParser {
    private static final Pattern F_ERROR_WARNING_LINE = Pattern.compile("^ftn-[0-9]+ (cray)?(ftn): ([A-Z]+)( ?[A-Za-z0-9$_]*,? File = (.*), Line = ([0-9]+)(, Column = ([0-9]+))?|.*)?[ \t]*$");
    private static final int SEVERITY_GROUP = 3;
    private static final int FILENAME_GROUP = 5;
    private static final int LINE_NUMBER_GROUP = 6;
    private String previousLine = "";

    public boolean processLine(String currentLine, ErrorParserManager eoParser) {
        Matcher matcher = this.matchErrorWarningLine(this.previousLine);
        this.previousLine = currentLine;
        if (matcher != null) {
            int severity = this.determineSeverity(matcher.group(3));
            String filename = matcher.group(5);
            IFile file = filename == null ? null : eoParser.findFileName(filename);
            int lineNumber = this.atoi(matcher.group(6));
            String description = currentLine.trim();
            eoParser.generateMarker((IResource)file, lineNumber, description, severity, null);
            return true;
        }
        return false;
    }

    private Matcher matchErrorWarningLine(String previousLine) {
        Matcher m;
        if (previousLine != null && (m = F_ERROR_WARNING_LINE.matcher(previousLine)).matches()) {
            return m;
        }
        return null;
    }

    private int determineSeverity(String text) {
        if (text.equals("WARNING")) {
            return 1;
        }
        if (text.equals("SCALAR") || text.equals("VECTOR") || text.equals("IPA") || text.equals("THREAD") || text.equals("ACCEL")) {
            return 0;
        }
        return 2;
    }

    private int atoi(String string) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

