/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionEditPartTN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.TimingDiagramEditPart;

public class CustomTimingDiagramEditPart
extends TimingDiagramEditPart {
    public CustomTimingDiagramEditPart(View view) {
        super(view);
    }

    public Command getCommand(Request request) {
        if (request.getType() == "drop" && !CustomTimingDiagramEditPart.canBeDropped(((GroupRequest)request).getEditParts())) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(request);
    }

    private static boolean canBeDropped(List<EditPart> editParts) {
        for (EditPart editPart : editParts) {
            if (editPart instanceof InteractionEditPartTN) continue;
            return false;
        }
        return true;
    }

    protected IFigure createFigure() {
        IFigure fig = super.createFigure();
        String message = "This diagram is not available, it will be fixed for the next service release.";
        Label label = new Label(message);
        label.setBackgroundColor(ColorConstants.lightBlue);
        label.setOpaque(true);
        label.setBounds(new Rectangle(20, 20, 600, 40));
        fig.add((IFigure)label);
        return fig;
    }
}

