/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.iteration;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.iteration.AbstractIteration2Java;
import org.eclipse.ocl.examples.codegen.java.types.JavaTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ExistsIteration2Java
extends AbstractIteration2Java {
    public static final @NonNull ExistsIteration2Java INSTANCE = new ExistsIteration2Java();

    @Override
    public void appendAccumulatorInit(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        js.appendClassReference(ValueUtil.class);
        js.append(".FALSE_VALUE");
    }

    @Override
    public boolean appendFinalValue(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGIterator cgAccumulator = cgIterationCallExp.getAccumulator();
        CGValuedElement cgBody = this.getBody(cgIterationCallExp);
        if (!cgBody.isNonNull()) {
            js.append("if (");
            js.appendValueName(cgAccumulator);
            js.append(" == null) {\n");
            js.pushIndentation(null);
            js.appendValueName(cgIterationCallExp);
            js.append(" = null;\n");
            js.popIndentation();
            js.append("}\n");
            js.append("else ");
        }
        js.append("if (");
        js.appendValueName(cgAccumulator);
        js.append(" == ");
        js.appendClassReference(ValueUtil.class);
        js.append(".FALSE_VALUE) {\n");
        js.pushIndentation(null);
        js.appendValueName(cgIterationCallExp);
        js.append(" = ");
        js.appendClassReference(ValueUtil.class);
        js.append(".FALSE_VALUE;\n");
        js.popIndentation();
        js.append("}\n");
        js.append("else {\n");
        js.pushIndentation(null);
        js.append("throw (");
        js.appendClassReference(InvalidValueException.class);
        js.append(")");
        js.appendValueName(cgAccumulator);
        js.append(";\n");
        js.popIndentation();
        js.append("}\n");
        return true;
    }

    @Override
    public boolean appendUpdate(@NonNull JavaStream js, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGIterator cgAccumulator = cgIterationCallExp.getAccumulator();
        CGValuedElement cgBody = this.getBody(cgIterationCallExp);
        if (cgBody.isTrue()) {
            js.appendValueName(cgIterationCallExp);
            js.append(" = ");
            js.appendClassReference(ValueUtil.class);
            js.append(".TRUE_VALUE;\n");
            js.append("break;\n");
        } else if (cgBody.isFalse()) {
            js.appendValueName(cgIterationCallExp);
            js.append(" = ");
            js.appendClassReference(ValueUtil.class);
            js.append(".FALSE_VALUE;\n");
            js.append("break;\n");
        } else if (cgBody.isNull()) {
            js.appendValueName(cgIterationCallExp);
            js.append(" = null;\n");
            js.append("break;\n");
        } else {
            CGInvalid cgInvalidValue = cgBody.getInvalidValue();
            if (cgInvalidValue != null) {
                js.append("throw ");
                js.appendValueName(cgInvalidValue);
                js.append(";\n");
                js.append("break;\n");
            } else {
                if (cgBody.isConstant()) {
                    return js.appendThrowInvalidValueException(PivotMessages.NonBooleanBody, "exists");
                }
                js.append("if (");
                js.appendValueName(cgBody);
                js.append(" == ");
                js.appendClassReference(ValueUtil.class);
                js.append(".TRUE_VALUE) {\t\t\t\t\t// Normal successful body evaluation result\n");
                js.pushIndentation(null);
                js.appendValueName(cgIterationCallExp);
                js.append(" = ");
                js.appendClassReference(ValueUtil.class);
                js.append(".TRUE_VALUE;\n");
                js.append("break;\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Stop immediately \n");
                js.popIndentation();
                js.append("}\n");
                js.append("else if (");
                js.appendValueName(cgBody);
                js.append(" == ");
                js.appendClassReference(ValueUtil.class);
                js.append(".FALSE_VALUE) {\t\t\t\t// Normal unsuccessful body evaluation result\n");
                js.pushIndentation(null);
                js.append(";\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Carry on\n");
                js.popIndentation();
                js.append("}\n");
                if (!cgBody.isNonNull()) {
                    js.append("else if (");
                    js.appendValueName(cgBody);
                    js.append(" == null) {\t\t\t\t\t\t\t\t// Abnormal null body evaluation result\n");
                    js.pushIndentation(null);
                    js.append("if (");
                    js.appendValueName(cgAccumulator);
                    js.append(" == ");
                    js.appendClassReference(ValueUtil.class);
                    js.append(".FALSE_VALUE) {\n");
                    js.pushIndentation(null);
                    js.appendValueName(cgAccumulator);
                    js.append(" = null;\t\t\t\t\t\t\t\t\t\t// Cache a null failure\n");
                    js.popIndentation();
                    js.append("}\n");
                    js.popIndentation();
                    js.append("}\n");
                }
                if (!cgBody.isNonInvalid()) {
                    js.append("else if (");
                    js.appendValueName(cgBody);
                    js.append(" instanceof ");
                    js.appendClassReference(InvalidValueException.class);
                    js.append(") {\t\t// Abnormal exception evaluation result\n");
                    js.pushIndentation(null);
                    js.appendValueName(cgAccumulator);
                    js.append(" = ");
                    js.appendValueName(cgBody);
                    js.append(";\t\t\t\t\t\t\t\t\t// Cache an exception failure\n");
                    js.popIndentation();
                    js.append("}\n");
                }
                js.append("else {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// Impossible badly typed result\n");
                js.pushIndentation(null);
                js.appendValueName(cgAccumulator);
                js.append(" = new ");
                js.appendClassReference(InvalidValueException.class);
                js.append("(");
                js.appendClassReference(PivotMessages.class);
                js.append(".NonBooleanBody, \"exists\");\n");
                js.popIndentation();
                js.append("}\n");
            }
        }
        return true;
    }

    @Override
    public @Nullable CGTypeId getAccumulatorTypeId(@NonNull CodeGenAnalyzer analyzer, @NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        return analyzer.getTypeId((TypeId)new JavaTypeId(Object.class));
    }
}

